/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import net.sf.portecle.DViewExtensions;
import net.sf.portecle.FPortecle;
import net.sf.portecle.FileChooserFactory;
import net.sf.portecle.NetUtil;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.StringUtil;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.DigestType;
import net.sf.portecle.crypto.DigestUtil;
import net.sf.portecle.crypto.KeyPairUtil;
import net.sf.portecle.crypto.SignatureType;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.crypto.DViewPEM;
import net.sf.portecle.gui.error.DThrowable;

class DViewCertificate
extends PortecleJDialog {
    private JButton m_jbLeft;
    private JButton m_jbRight;
    private JLabel m_jlSelector;
    private JTextField m_jtfVersion;
    private JTextField m_jtfSubject;
    private JTextField m_jtfIssuer;
    private JTextField m_jtfSerialNumber;
    private JTextField m_jtfValidFrom;
    private JTextField m_jtfValidUntil;
    private JTextField m_jtfPublicKey;
    private JTextField m_jtfSignatureAlgorithm;
    private JTextField m_jtfMD5Fingerprint;
    private JTextField m_jtfSHA1Fingerprint;
    private JTextField m_jtfProtocol;
    private JTextField m_jtfCipherSuite;
    private JButton m_jbExtensions;
    private final X509Certificate[] m_certs;
    private int m_iSelCert;
    private final String m_connectionProtocol;
    private final String m_connectionCipherSuite;

    public DViewCertificate(Window window, String string, X509Certificate[] x509CertificateArray) throws CryptoException {
        this(window, string, x509CertificateArray, null, null);
    }

    public DViewCertificate(Window window, String string, X509Certificate[] x509CertificateArray, String string2, String string3) throws CryptoException {
        super(window, string, true);
        this.m_certs = x509CertificateArray;
        this.m_connectionProtocol = string2;
        this.m_connectionCipherSuite = string3;
        this.initComponents();
    }

    public static boolean showAndWait(Window window, Object object) {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        try {
            X509Certificate[] x509CertificateArray = X509CertUtil.loadCertificates(NetUtil.toURL(object), arrayList);
            if (x509CertificateArray == null) {
                int n = SwingHelper.showConfirmDialog(window, MessageFormat.format(FPortecle.RB.getString("FPortecle.NoOpenCertificate.message"), object), FPortecle.RB.getString("FPortecle.OpenCertificate.Title"));
                if (n == 0) {
                    for (Exception exception : arrayList) {
                        DThrowable.showAndWait(window, null, exception);
                    }
                }
                return false;
            }
            if (x509CertificateArray.length == 0) {
                JOptionPane.showMessageDialog(window, MessageFormat.format(FPortecle.RB.getString("FPortecle.NoCertsFound.message"), object), FPortecle.RB.getString("FPortecle.OpenCertificate.Title"), 2);
                return false;
            }
            DViewCertificate dViewCertificate = new DViewCertificate(window, MessageFormat.format(FPortecle.RB.getString("FPortecle.CertDetails.Title"), object), x509CertificateArray);
            dViewCertificate.setLocationRelativeTo(window);
            SwingHelper.showAndWait(dViewCertificate);
        }
        catch (Exception exception) {
            DThrowable.showAndWait(window, null, exception);
            return false;
        }
        return true;
    }

    private void initComponents() throws CryptoException {
        this.m_iSelCert = this.m_certs.length == 0 ? -1 : 0;
        this.m_jbLeft = new JButton();
        this.m_jbLeft.setMnemonic(37);
        this.m_jbLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCertificate.this.leftPressed();
            }
        });
        this.m_jbLeft.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jbLeft.tooltip"));
        this.m_jbLeft.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(FPortecle.RB.getString("DViewCertificate.m_jbLeft.image")))));
        this.m_jlSelector = new JLabel();
        this.m_jbRight = new JButton();
        this.m_jbRight.setMnemonic(39);
        this.m_jbRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCertificate.this.rightPressed();
            }
        });
        this.m_jbRight.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jbRight.tooltip"));
        this.m_jbRight.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource(FPortecle.RB.getString("DViewCertificate.m_jbRight.image")))));
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.m_jbLeft);
        jPanel.add(this.m_jlSelector);
        jPanel.add(this.m_jbRight);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        int n = 0;
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DViewCertificate.jlVersion.text"));
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = n;
        this.m_jtfVersion = new JTextField(3);
        this.m_jtfVersion.setEditable(false);
        this.m_jtfVersion.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfVersion.tooltip"));
        jLabel.setLabelFor(this.m_jtfVersion);
        GridBagConstraints gridBagConstraints4 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints4.gridy = n++;
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlSubject.text"));
        GridBagConstraints gridBagConstraints5 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints5.gridy = n;
        this.m_jtfSubject = new JTextField(36);
        this.m_jtfSubject.setEditable(false);
        this.m_jtfSubject.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfSubject.tooltip"));
        jLabel2.setLabelFor(this.m_jtfSubject);
        GridBagConstraints gridBagConstraints6 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints6.gridy = n++;
        JLabel jLabel3 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlIssuer.text"));
        GridBagConstraints gridBagConstraints7 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints7.gridy = n;
        this.m_jtfIssuer = new JTextField(36);
        this.m_jtfIssuer.setEditable(false);
        this.m_jtfIssuer.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfIssuer.tooltip"));
        jLabel3.setLabelFor(this.m_jtfIssuer);
        GridBagConstraints gridBagConstraints8 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints8.gridy = n++;
        JLabel jLabel4 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlSerialNumber.text"));
        GridBagConstraints gridBagConstraints9 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints9.gridy = n;
        this.m_jtfSerialNumber = new JTextField(25);
        this.m_jtfSerialNumber.setEditable(false);
        this.m_jtfSerialNumber.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfSerialNumber.tooltip"));
        jLabel4.setLabelFor(this.m_jtfSerialNumber);
        GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints10.gridy = n++;
        JLabel jLabel5 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlValidFrom.text"));
        GridBagConstraints gridBagConstraints11 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints11.gridy = n;
        this.m_jtfValidFrom = new JTextField(25);
        this.m_jtfValidFrom.setEditable(false);
        this.m_jtfValidFrom.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfValidFrom.tooltip"));
        jLabel5.setLabelFor(jLabel5);
        GridBagConstraints gridBagConstraints12 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints12.gridy = n++;
        JLabel jLabel6 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlValidUntil.text"));
        GridBagConstraints gridBagConstraints13 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints13.gridy = n;
        this.m_jtfValidUntil = new JTextField(25);
        this.m_jtfValidUntil.setEditable(false);
        this.m_jtfValidUntil.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfValidUntil.tooltip"));
        jLabel6.setLabelFor(this.m_jtfValidUntil);
        GridBagConstraints gridBagConstraints14 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints14.gridy = n++;
        JLabel jLabel7 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlPublicKey.text"));
        GridBagConstraints gridBagConstraints15 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints15.gridy = n;
        this.m_jtfPublicKey = new JTextField(15);
        this.m_jtfPublicKey.setEditable(false);
        this.m_jtfPublicKey.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfPublicKey.tooltip"));
        jLabel7.setLabelFor(this.m_jtfPublicKey);
        GridBagConstraints gridBagConstraints16 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints16.gridy = n++;
        JLabel jLabel8 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlSignatureAlgorithm.text"));
        GridBagConstraints gridBagConstraints17 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints17.gridy = n;
        this.m_jtfSignatureAlgorithm = new JTextField(15);
        this.m_jtfSignatureAlgorithm.setEditable(false);
        this.m_jtfSignatureAlgorithm.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfSignatureAlgorithm.tooltip"));
        jLabel8.setLabelFor(this.m_jtfSignatureAlgorithm);
        GridBagConstraints gridBagConstraints18 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints18.gridy = n++;
        JLabel jLabel9 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlSHA1Fingerprint.text"));
        GridBagConstraints gridBagConstraints19 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints19.gridy = n;
        this.m_jtfSHA1Fingerprint = new JTextField(36);
        this.m_jtfSHA1Fingerprint.setEditable(false);
        this.m_jtfSHA1Fingerprint.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfSHA1Fingerprint.tooltip"));
        jLabel9.setLabelFor(this.m_jtfSHA1Fingerprint);
        GridBagConstraints gridBagConstraints20 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints20.gridy = n++;
        JLabel jLabel10 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlMD5Fingerprint.text"));
        GridBagConstraints gridBagConstraints21 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints21.gridy = n;
        this.m_jtfMD5Fingerprint = new JTextField(36);
        this.m_jtfMD5Fingerprint.setEditable(false);
        this.m_jtfMD5Fingerprint.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfMD5Fingerprint.tooltip"));
        jLabel10.setLabelFor(this.m_jtfMD5Fingerprint);
        GridBagConstraints gridBagConstraints22 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints22.gridy = n++;
        this.m_jbExtensions = new JButton(FPortecle.RB.getString("DViewCertificate.m_jbExtensions.text"));
        this.m_jbExtensions.setMnemonic(FPortecle.RB.getString("DViewCertificate.m_jbExtensions.mnemonic").charAt(0));
        this.m_jbExtensions.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jbExtensions.tooltip"));
        this.m_jbExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCertificate.this.extensionsPressed();
            }
        });
        JButton jButton = new JButton(FPortecle.RB.getString("DViewCertificate.jbPemEncoding.text"));
        jButton.setMnemonic(FPortecle.RB.getString("DViewCertificate.jbPemEncoding.mnemonic").charAt(0));
        jButton.setToolTipText(FPortecle.RB.getString("DViewCertificate.jbPemEncoding.tooltip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCertificate.this.pemEncodingPressed();
            }
        });
        if (this.m_certs.length == 0) {
            jButton.setEnabled(false);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.m_jbExtensions);
        jPanel2.add(jButton);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.gridx = 0;
        gridBagConstraints23.gridy = n++;
        gridBagConstraints23.gridwidth = 2;
        gridBagConstraints23.gridheight = 1;
        gridBagConstraints23.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints23.anchor = 13;
        JLabel jLabel11 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlProtocol.text"));
        GridBagConstraints gridBagConstraints24 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints24.gridy = n;
        this.m_jtfProtocol = new JTextField(36);
        this.m_jtfProtocol.setEditable(false);
        this.m_jtfProtocol.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfProtocol.tooltip"));
        jLabel11.setLabelFor(this.m_jtfProtocol);
        GridBagConstraints gridBagConstraints25 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints25.gridy = n++;
        JLabel jLabel12 = new JLabel(FPortecle.RB.getString("DViewCertificate.jlCipherSuite.text"));
        GridBagConstraints gridBagConstraints26 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints26.gridy = n;
        this.m_jtfCipherSuite = new JTextField(36);
        this.m_jtfCipherSuite.setEditable(false);
        this.m_jtfCipherSuite.setToolTipText(FPortecle.RB.getString("DViewCertificate.m_jtfCipherSuite.tooltip"));
        jLabel12.setLabelFor(this.m_jtfCipherSuite);
        GridBagConstraints gridBagConstraints27 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints27.gridy = n++;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()));
        jPanel3.add((Component)jLabel, gridBagConstraints3);
        jPanel3.add((Component)this.m_jtfVersion, gridBagConstraints4);
        jPanel3.add((Component)jLabel2, gridBagConstraints5);
        jPanel3.add((Component)this.m_jtfSubject, gridBagConstraints6);
        jPanel3.add((Component)jLabel3, gridBagConstraints7);
        jPanel3.add((Component)this.m_jtfIssuer, gridBagConstraints8);
        jPanel3.add((Component)jLabel4, gridBagConstraints9);
        jPanel3.add((Component)this.m_jtfSerialNumber, gridBagConstraints10);
        jPanel3.add((Component)jLabel5, gridBagConstraints11);
        jPanel3.add((Component)this.m_jtfValidFrom, gridBagConstraints12);
        jPanel3.add((Component)jLabel6, gridBagConstraints13);
        jPanel3.add((Component)this.m_jtfValidUntil, gridBagConstraints14);
        jPanel3.add((Component)jLabel7, gridBagConstraints15);
        jPanel3.add((Component)this.m_jtfPublicKey, gridBagConstraints16);
        jPanel3.add((Component)jLabel8, gridBagConstraints17);
        jPanel3.add((Component)this.m_jtfSignatureAlgorithm, gridBagConstraints18);
        jPanel3.add((Component)jLabel10, gridBagConstraints21);
        jPanel3.add((Component)this.m_jtfMD5Fingerprint, gridBagConstraints22);
        jPanel3.add((Component)jLabel9, gridBagConstraints19);
        jPanel3.add((Component)this.m_jtfSHA1Fingerprint, gridBagConstraints20);
        jPanel3.add((Component)jPanel2, gridBagConstraints23);
        if (this.m_connectionProtocol != null) {
            jPanel3.add((Component)jLabel11, gridBagConstraints24);
            jPanel3.add((Component)this.m_jtfProtocol, gridBagConstraints25);
        }
        if (this.m_connectionCipherSuite != null) {
            jPanel3.add((Component)jLabel12, gridBagConstraints26);
            jPanel3.add((Component)this.m_jtfCipherSuite, gridBagConstraints27);
        }
        this.populateDialog();
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        JButton jButton2 = this.getOkButton(true);
        jPanel4.add(jButton2);
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel4, "South");
        this.getRootPane().setDefaultButton(jButton2);
        this.initDialog();
        jButton2.requestFocusInWindow();
    }

    private void populateDialog() throws CryptoException {
        byte[] byArray;
        if (this.m_iSelCert < 0 || this.m_iSelCert >= this.m_certs.length) {
            this.m_jbLeft.setEnabled(false);
            this.m_jbRight.setEnabled(false);
            this.m_jlSelector.setText(MessageFormat.format(FPortecle.RB.getString("DViewCertificate.m_jlSelector.text"), 0, 0));
            return;
        }
        this.m_jlSelector.setText(MessageFormat.format(FPortecle.RB.getString("DViewCertificate.m_jlSelector.text"), this.m_iSelCert + 1, this.m_certs.length));
        if (this.m_iSelCert == 0) {
            this.m_jbLeft.setEnabled(false);
        } else {
            this.m_jbLeft.setEnabled(true);
        }
        if (this.m_iSelCert + 1 < this.m_certs.length) {
            this.m_jbRight.setEnabled(true);
        } else {
            this.m_jbRight.setEnabled(false);
        }
        X509Certificate x509Certificate = this.m_certs[this.m_iSelCert];
        Date date = new Date();
        Date date2 = x509Certificate.getNotBefore();
        Date date3 = x509Certificate.getNotAfter();
        boolean bl = date.before(date2);
        boolean bl2 = date.after(date3);
        this.m_jtfVersion.setText(Integer.toString(x509Certificate.getVersion()));
        this.m_jtfVersion.setCaretPosition(0);
        this.m_jtfSubject.setText(((Object)x509Certificate.getSubjectDN()).toString());
        this.m_jtfSubject.setCaretPosition(0);
        this.m_jtfIssuer.setText(((Object)x509Certificate.getIssuerDN()).toString());
        this.m_jtfIssuer.setCaretPosition(0);
        this.m_jtfSerialNumber.setText(StringUtil.toHex(x509Certificate.getSerialNumber(), 4, " ").toString());
        this.m_jtfSerialNumber.setCaretPosition(0);
        this.m_jtfValidFrom.setText(DateFormat.getDateTimeInstance(2, 1).format(date2));
        if (bl) {
            this.m_jtfValidFrom.setText(MessageFormat.format(FPortecle.RB.getString("DViewCertificate.m_jtfValidFrom.notyetvalid.text"), this.m_jtfValidFrom.getText()));
            this.m_jtfValidFrom.setForeground(Color.red);
        } else {
            this.m_jtfValidFrom.setForeground(this.m_jtfVersion.getForeground());
        }
        this.m_jtfValidFrom.setCaretPosition(0);
        this.m_jtfValidUntil.setText(DateFormat.getDateTimeInstance(2, 1).format(date3));
        if (bl2) {
            this.m_jtfValidUntil.setText(MessageFormat.format(FPortecle.RB.getString("DViewCertificate.m_jtfValidUntil.expired.text"), this.m_jtfValidUntil.getText()));
            this.m_jtfValidUntil.setForeground(Color.red);
        } else {
            this.m_jtfValidUntil.setForeground(this.m_jtfVersion.getForeground());
        }
        this.m_jtfValidUntil.setCaretPosition(0);
        int n = KeyPairUtil.getKeyLength(x509Certificate.getPublicKey());
        this.m_jtfPublicKey.setText(x509Certificate.getPublicKey().getAlgorithm());
        if (n != -1) {
            this.m_jtfPublicKey.setText(MessageFormat.format(FPortecle.RB.getString("DViewCertificate.m_jtfPublicKey.text"), this.m_jtfPublicKey.getText(), n));
        }
        this.m_jtfPublicKey.setCaretPosition(0);
        String string = SignatureType.toString(x509Certificate.getSigAlgName());
        this.m_jtfSignatureAlgorithm.setText(string);
        this.m_jtfSignatureAlgorithm.setCaretPosition(0);
        try {
            byArray = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CryptoException(FPortecle.RB.getString("DViewCertificate.NoGetEncodedCert.exception.message"), certificateEncodingException);
        }
        this.m_jtfMD5Fingerprint.setText(DigestUtil.getMessageDigest(byArray, DigestType.MD5));
        this.m_jtfMD5Fingerprint.setCaretPosition(0);
        this.m_jtfSHA1Fingerprint.setText(DigestUtil.getMessageDigest(byArray, DigestType.SHA1));
        this.m_jtfSHA1Fingerprint.setCaretPosition(0);
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        Set<String> set2 = x509Certificate.getNonCriticalExtensionOIDs();
        if (set != null && !set.isEmpty() || set2 != null && !set2.isEmpty()) {
            this.m_jbExtensions.setEnabled(true);
        } else {
            this.m_jbExtensions.setEnabled(false);
        }
        this.m_jtfProtocol.setText(this.m_connectionProtocol);
        this.m_jtfProtocol.setCaretPosition(0);
        this.m_jtfCipherSuite.setText(this.m_connectionCipherSuite);
        this.m_jtfCipherSuite.setCaretPosition(0);
    }

    private void leftPressed() {
        if (this.m_iSelCert > 0) {
            --this.m_iSelCert;
            try {
                this.populateDialog();
            }
            catch (CryptoException cryptoException) {
                DThrowable.showAndWait(this, null, cryptoException);
                this.dispose();
            }
        }
    }

    private void rightPressed() {
        if (this.m_iSelCert + 1 < this.m_certs.length) {
            ++this.m_iSelCert;
            try {
                this.populateDialog();
            }
            catch (CryptoException cryptoException) {
                DThrowable.showAndWait(this, null, cryptoException);
                this.dispose();
            }
        }
    }

    private void extensionsPressed() {
        if (this.m_iSelCert == -1 || this.m_iSelCert >= this.m_certs.length) {
            return;
        }
        X509Certificate x509Certificate = this.m_certs[this.m_iSelCert];
        DViewExtensions dViewExtensions = new DViewExtensions((Window)this, MessageFormat.format(FPortecle.RB.getString("DViewCertificate.Extensions.Title"), this.m_iSelCert + 1, this.m_certs.length), true, x509Certificate);
        dViewExtensions.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dViewExtensions);
    }

    private void pemEncodingPressed() {
        if (this.m_iSelCert == -1 || this.m_iSelCert >= this.m_certs.length) {
            return;
        }
        X509Certificate x509Certificate = this.m_certs[this.m_iSelCert];
        JFileChooser jFileChooser = FileChooserFactory.getPEMFileChooser(X509CertUtil.getCertificateAlias(x509Certificate));
        jFileChooser.setDialogTitle(FPortecle.RB.getString("DViewCertificate.Save.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        try {
            DViewPEM dViewPEM = new DViewPEM((Window)this, MessageFormat.format(FPortecle.RB.getString("DViewCertificate.PemEncoding.Title"), this.m_iSelCert + 1, this.m_certs.length), x509Certificate, jFileChooser);
            dViewPEM.setLocationRelativeTo(this);
            SwingHelper.showAndWait(dViewPEM);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
            return;
        }
    }
}

