/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import net.sf.portecle.DViewExtensions;
import net.sf.portecle.FPortecle;
import net.sf.portecle.NetUtil;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.RevokedCertsTableCellRend;
import net.sf.portecle.RevokedCertsTableHeadRend;
import net.sf.portecle.RevokedCertsTableModel;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.SwingHelper;
import net.sf.portecle.gui.error.DThrowable;

final class DViewCRL
extends PortecleJDialog {
    private JTextField m_jtfVersion;
    private JTextField m_jtfIssuer;
    private JTextField m_jtfEffectiveDate;
    private JTextField m_jtfNextUpdate;
    private JTextField m_jtfSignatureAlgorithm;
    private JButton m_jbCrlExtensions;
    private JTable m_jtRevokedCerts;
    private JButton m_jbCrlEntryExtensions;
    private X509CRL m_crl;

    private DViewCRL(Window window, String string, X509CRL x509CRL) {
        super(window, string, true);
        this.m_crl = x509CRL;
        this.initComponents();
    }

    public static boolean showAndWait(Window window, Object object) {
        DViewCRL dViewCRL;
        String string = MessageFormat.format(FPortecle.RB.getString("FPortecle.CrlDetails.Title"), object);
        try {
            X509CRL x509CRL = X509CertUtil.loadCRL(NetUtil.toURL(object));
            dViewCRL = new DViewCRL(window, string, x509CRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(window, MessageFormat.format(FPortecle.RB.getString("FPortecle.NoRead.message"), object), string, 2);
            return false;
        }
        catch (Exception exception) {
            DThrowable.showAndWait(window, null, exception);
            return false;
        }
        dViewCRL.setLocationRelativeTo(window);
        SwingHelper.showAndWait(dViewCRL);
        return true;
    }

    private void initComponents() {
        Serializable serializable;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 13;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 17;
        JLabel jLabel = new JLabel(FPortecle.RB.getString("DViewCRL.jlVersion.text"));
        GridBagConstraints gridBagConstraints3 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints3.gridy = 0;
        this.m_jtfVersion = new JTextField(3);
        this.m_jtfVersion.setEditable(false);
        this.m_jtfVersion.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jtfVersion.tooltip"));
        jLabel.setLabelFor(this.m_jtfVersion);
        GridBagConstraints gridBagConstraints4 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints4.gridy = 0;
        JLabel jLabel2 = new JLabel(FPortecle.RB.getString("DViewCRL.jlIssuer.text"));
        GridBagConstraints gridBagConstraints5 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints5.gridy = 1;
        this.m_jtfIssuer = new JTextField(40);
        this.m_jtfIssuer.setEditable(false);
        this.m_jtfIssuer.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jtfIssuer.tooltip"));
        jLabel2.setLabelFor(this.m_jtfIssuer);
        GridBagConstraints gridBagConstraints6 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints6.gridy = 1;
        JLabel jLabel3 = new JLabel(FPortecle.RB.getString("DViewCRL.jlEffectiveDate.text"));
        GridBagConstraints gridBagConstraints7 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints7.gridy = 2;
        this.m_jtfEffectiveDate = new JTextField(30);
        this.m_jtfEffectiveDate.setEditable(false);
        this.m_jtfEffectiveDate.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jtfEffectiveDate.tooltip"));
        jLabel3.setLabelFor(this.m_jtfEffectiveDate);
        GridBagConstraints gridBagConstraints8 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints8.gridy = 2;
        JLabel jLabel4 = new JLabel(FPortecle.RB.getString("DViewCRL.jlNextUpdate.text"));
        GridBagConstraints gridBagConstraints9 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints9.gridy = 3;
        this.m_jtfNextUpdate = new JTextField(30);
        this.m_jtfNextUpdate.setEditable(false);
        this.m_jtfNextUpdate.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jtfNextUpdate.tooltip"));
        jLabel4.setLabelFor(this.m_jtfNextUpdate);
        GridBagConstraints gridBagConstraints10 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints10.gridy = 3;
        JLabel jLabel5 = new JLabel(FPortecle.RB.getString("DViewCRL.jlSignatureAlgorithm.text"));
        GridBagConstraints gridBagConstraints11 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints11.gridy = 4;
        this.m_jtfSignatureAlgorithm = new JTextField(15);
        this.m_jtfSignatureAlgorithm.setEditable(false);
        this.m_jtfSignatureAlgorithm.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jtfSignatureAlgorithm.tooltip"));
        jLabel5.setLabelFor(this.m_jtfSignatureAlgorithm);
        GridBagConstraints gridBagConstraints12 = (GridBagConstraints)gridBagConstraints2.clone();
        gridBagConstraints12.gridy = 4;
        this.m_jbCrlExtensions = new JButton(FPortecle.RB.getString("DViewCRL.m_jbCrlExtensions.text"));
        this.m_jbCrlExtensions.setMnemonic(FPortecle.RB.getString("DViewCRL.m_jbCrlExtensions.mnemonic").charAt(0));
        this.m_jbCrlExtensions.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jbCrlExtensions.tooltip"));
        this.m_jbCrlExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCRL.this.crlExtensionsPressed();
            }
        });
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 5;
        gridBagConstraints13.gridwidth = 2;
        gridBagConstraints13.gridheight = 1;
        gridBagConstraints13.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints13.anchor = 13;
        RevokedCertsTableModel revokedCertsTableModel = new RevokedCertsTableModel();
        this.m_jtRevokedCerts = new JTable(revokedCertsTableModel);
        this.m_jtRevokedCerts.setShowGrid(false);
        this.m_jtRevokedCerts.setRowMargin(0);
        this.m_jtRevokedCerts.getColumnModel().setColumnMargin(0);
        this.m_jtRevokedCerts.getTableHeader().setReorderingAllowed(false);
        this.m_jtRevokedCerts.setAutoResizeMode(4);
        for (int i = 0; i < this.m_jtRevokedCerts.getColumnCount(); ++i) {
            serializable = this.m_jtRevokedCerts.getColumnModel().getColumn(i);
            if (i == 0) {
                ((TableColumn)serializable).setPreferredWidth(150);
            }
            ((TableColumn)serializable).setHeaderRenderer(new RevokedCertsTableHeadRend());
            ((TableColumn)serializable).setCellRenderer(new RevokedCertsTableCellRend(this.m_jtRevokedCerts));
        }
        ListSelectionModel listSelectionModel = this.m_jtRevokedCerts.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    DViewCRL.this.crlEntrySelection();
                }
            }
        });
        this.m_jtRevokedCerts.setAutoCreateRowSorter(true);
        this.m_jtRevokedCerts.getRowSorter().toggleSortOrder(0);
        serializable = new JScrollPane(this.m_jtRevokedCerts, 20, 30);
        ((JScrollPane)serializable).getViewport().setBackground(this.m_jtRevokedCerts.getBackground());
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setPreferredSize(new Dimension(100, 200));
        jPanel.add((Component)serializable, "Center");
        this.m_jbCrlEntryExtensions = new JButton(FPortecle.RB.getString("DViewCRL.m_jbCrlEntryExtensions.text"));
        this.m_jbCrlEntryExtensions.setMnemonic(FPortecle.RB.getString("DViewCRL.m_jbCrlEntryExtensions.mnemonic").charAt(0));
        this.m_jbCrlEntryExtensions.setToolTipText(FPortecle.RB.getString("DViewCRL.m_jbCrlEntryExtensions.tooltip"));
        this.m_jbCrlEntryExtensions.setEnabled(false);
        this.m_jbCrlEntryExtensions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DViewCRL.this.crlEntryExtensionsPressed();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(this.m_jbCrlEntryExtensions);
        jPanel.add((Component)jPanel2, "South");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 6;
        gridBagConstraints14.gridwidth = 2;
        gridBagConstraints14.gridheight = 1;
        gridBagConstraints14.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints14.fill = 1;
        gridBagConstraints14.anchor = 10;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new EtchedBorder()));
        jPanel3.add((Component)jLabel, gridBagConstraints3);
        jPanel3.add((Component)this.m_jtfVersion, gridBagConstraints4);
        jPanel3.add((Component)jLabel2, gridBagConstraints5);
        jPanel3.add((Component)this.m_jtfIssuer, gridBagConstraints6);
        jPanel3.add((Component)jLabel3, gridBagConstraints7);
        jPanel3.add((Component)this.m_jtfEffectiveDate, gridBagConstraints8);
        jPanel3.add((Component)jLabel4, gridBagConstraints9);
        jPanel3.add((Component)this.m_jtfNextUpdate, gridBagConstraints10);
        jPanel3.add((Component)jLabel5, gridBagConstraints11);
        jPanel3.add((Component)this.m_jtfSignatureAlgorithm, gridBagConstraints12);
        jPanel3.add((Component)this.m_jbCrlExtensions, gridBagConstraints13);
        jPanel3.add((Component)jPanel, gridBagConstraints14);
        this.populateDialog();
        jPanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), MessageFormat.format(FPortecle.RB.getString("DViewCRL.TableTitle"), this.m_jtRevokedCerts.getRowCount())), new EmptyBorder(5, 5, 5, 5)));
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        JButton jButton = this.getOkButton(true);
        jPanel4.add(jButton);
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel4, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        jButton.requestFocusInWindow();
    }

    private void populateDialog() {
        Date date = new Date();
        Date date2 = this.m_crl.getThisUpdate();
        boolean bl = date.before(date2);
        this.m_jtfVersion.setText(Integer.toString(this.m_crl.getVersion()));
        this.m_jtfVersion.setCaretPosition(0);
        this.m_jtfIssuer.setText(((Object)this.m_crl.getIssuerDN()).toString());
        this.m_jtfIssuer.setCaretPosition(0);
        this.m_jtfEffectiveDate.setText(DateFormat.getDateTimeInstance(2, 1).format(date2));
        if (bl) {
            this.m_jtfEffectiveDate.setText(MessageFormat.format(FPortecle.RB.getString("DViewCRL.m_jtfEffectiveDate.noteffective.text"), this.m_jtfEffectiveDate.getText()));
            this.m_jtfEffectiveDate.setForeground(Color.red);
        } else {
            this.m_jtfEffectiveDate.setForeground(this.m_jtfVersion.getForeground());
        }
        this.m_jtfEffectiveDate.setCaretPosition(0);
        Date date3 = this.m_crl.getNextUpdate();
        if (date3 != null) {
            this.m_jtfNextUpdate.setText(DateFormat.getDateTimeInstance(2, 1).format(date3));
            if (date.after(date3)) {
                this.m_jtfNextUpdate.setText(MessageFormat.format(FPortecle.RB.getString("DViewCRL.m_jtfNextUpdate.updateavailable.text"), this.m_jtfNextUpdate.getText()));
                this.m_jtfNextUpdate.setForeground(Color.red);
            } else {
                this.m_jtfNextUpdate.setForeground(this.m_jtfVersion.getForeground());
            }
        } else {
            this.m_jtfNextUpdate.setText(FPortecle.RB.getString("DViewCRL.m_jtfNextUpdate.notavailable.text"));
            this.m_jtfNextUpdate.setForeground(this.m_jtfVersion.getForeground());
            this.m_jtfNextUpdate.setEnabled(false);
        }
        this.m_jtfNextUpdate.setCaretPosition(0);
        this.m_jtfSignatureAlgorithm.setText(this.m_crl.getSigAlgName());
        this.m_jtfSignatureAlgorithm.setCaretPosition(0);
        Set<String> set = this.m_crl.getCriticalExtensionOIDs();
        Set<String> set2 = this.m_crl.getNonCriticalExtensionOIDs();
        if (set != null && !set.isEmpty() || set2 != null && !set2.isEmpty()) {
            this.m_jbCrlExtensions.setEnabled(true);
        } else {
            this.m_jbCrlExtensions.setEnabled(false);
        }
        Set<X509CRLEntry> set3 = this.m_crl.getRevokedCertificates();
        if (set3 == null) {
            set3 = Collections.emptySet();
        }
        X509CRLEntry[] x509CRLEntryArray = set3.toArray(new X509CRLEntry[set3.size()]);
        RevokedCertsTableModel revokedCertsTableModel = (RevokedCertsTableModel)this.m_jtRevokedCerts.getModel();
        revokedCertsTableModel.load(x509CRLEntryArray);
        if (revokedCertsTableModel.getRowCount() > 0) {
            this.m_jtRevokedCerts.changeSelection(0, 0, false, false);
        }
    }

    private void crlEntrySelection() {
        ListSelectionModel listSelectionModel = this.m_jtRevokedCerts.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            int n = listSelectionModel.getMinSelectionIndex();
            BigInteger bigInteger = (BigInteger)this.m_jtRevokedCerts.getValueAt(n, 0);
            Set<? extends X509CRLEntry> set = this.m_crl.getRevokedCertificates();
            X509CRLEntry x509CRLEntry = null;
            for (X509CRLEntry x509CRLEntry2 : set) {
                if (!bigInteger.equals(x509CRLEntry2.getSerialNumber())) continue;
                x509CRLEntry = x509CRLEntry2;
                break;
            }
            if (x509CRLEntry != null && x509CRLEntry.hasExtensions()) {
                this.m_jbCrlEntryExtensions.setEnabled(true);
                return;
            }
        }
        this.m_jbCrlEntryExtensions.setEnabled(false);
    }

    private void crlExtensionsPressed() {
        DViewExtensions dViewExtensions = new DViewExtensions((Window)this, FPortecle.RB.getString("DViewCRL.Extensions.Title"), true, this.m_crl);
        dViewExtensions.setLocationRelativeTo(this);
        SwingHelper.showAndWait(dViewExtensions);
    }

    private void crlEntryExtensionsPressed() {
        ListSelectionModel listSelectionModel = this.m_jtRevokedCerts.getSelectionModel();
        if (!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex()) {
            int n = listSelectionModel.getMinSelectionIndex();
            BigInteger bigInteger = (BigInteger)this.m_jtRevokedCerts.getValueAt(n, 0);
            Set<? extends X509CRLEntry> set = this.m_crl.getRevokedCertificates();
            X509CRLEntry x509CRLEntry = null;
            for (X509CRLEntry x509CRLEntry2 : set) {
                if (!bigInteger.equals(x509CRLEntry2.getSerialNumber())) continue;
                x509CRLEntry = x509CRLEntry2;
                break;
            }
            if (x509CRLEntry != null && x509CRLEntry.hasExtensions()) {
                DViewExtensions dViewExtensions = new DViewExtensions((Window)this, FPortecle.RB.getString("DViewCRL.EntryExtensions.Title"), true, x509CRLEntry);
                dViewExtensions.setLocationRelativeTo(this);
                SwingHelper.showAndWait(dViewExtensions);
            }
        }
    }
}

