/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.FileChooserFactory;
import net.sf.portecle.PortecleJDialog;

class DOptions
extends PortecleJDialog {
    private JCheckBox m_jcbUseCaCerts;
    private JTextField m_jtfCaCertsFile;
    private JComboBox m_jcbLookFeel;
    private JCheckBox m_jcbLookFeelDecorated;
    private boolean m_bUseCaCerts;
    private File m_fCaCertsFile;
    private TreeMap<String, UIManager.LookAndFeelInfo> lookFeelInfos = new TreeMap();
    private String lookFeelClassName;
    private boolean m_bLookFeelDecorated;

    public DOptions(Window window, boolean bl, File file) {
        super(window, true);
        this.m_bUseCaCerts = bl;
        this.m_fCaCertsFile = file;
        this.initComponents();
    }

    private void initComponents() {
        Object exception;
        Object object;
        this.m_jcbUseCaCerts = new JCheckBox(FPortecle.RB.getString("DOptions.m_jcbUseCaCerts.text"), this.m_bUseCaCerts);
        this.m_jcbUseCaCerts.setToolTipText(FPortecle.RB.getString("DOptions.m_jcbUseCaCerts.tooltip"));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.m_jcbUseCaCerts);
        this.m_jtfCaCertsFile = new JTextField(this.m_fCaCertsFile.toString(), 20);
        this.m_jtfCaCertsFile.setToolTipText(FPortecle.RB.getString("DOptions.m_jtfCaCertsFile.tooltip"));
        this.m_jtfCaCertsFile.setEditable(false);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(FPortecle.RB.getString("DOptions.jlCaCertsFile.text")));
        jPanel2.add(this.m_jtfCaCertsFile);
        JButton jButton = new JButton(FPortecle.RB.getString("DOptions.jbBrowseCaCertsFile.text"));
        jButton.setMnemonic(FPortecle.RB.getString("DOptions.jbBrowseCaCertsFile.mnemonic").charAt(0));
        jButton.setToolTipText(FPortecle.RB.getString("DOptions.jbBrowseCaCertsFile.tooltip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOptions.this.browsePressed();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(FPortecle.RB.getString("DOptions.jbResetCaCertsFile.text"));
        jButton2.setMnemonic(FPortecle.RB.getString("DOptions.jbResetCaCertsFile.mnemonic").charAt(0));
        jButton2.setToolTipText(FPortecle.RB.getString("DOptions.jbResetCaCertsFile.tooltip"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOptions.this.resetPressed();
            }
        });
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        this.m_jcbLookFeel = new JComboBox();
        this.m_jcbLookFeel.setToolTipText(FPortecle.RB.getString("DOptions.m_jcbLookFeel.tooltip"));
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo object32 : UIManager.getInstalledLookAndFeels()) {
            object = object32.getName();
            if (this.lookFeelInfos.containsKey(object)) continue;
            boolean jButton3 = false;
            try {
                exception = (LookAndFeel)Class.forName(object32.getClassName()).newInstance();
                jButton3 = ((LookAndFeel)exception).isSupportedLookAndFeel();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (!jButton3) continue;
            this.lookFeelInfos.put((String)object, object32);
        }
        for (Map.Entry entry : this.lookFeelInfos.entrySet()) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)entry.getValue();
            this.m_jcbLookFeel.addItem(lookAndFeelInfo.getName());
            if (lookAndFeel == null || !lookAndFeel.getClass().getName().equals(lookAndFeelInfo.getClassName())) continue;
            this.m_jcbLookFeel.setSelectedIndex(this.m_jcbLookFeel.getItemCount() - 1);
        }
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(new JLabel(FPortecle.RB.getString("DOptions.jlLookFeel.text")));
        jPanel4.add(this.m_jcbLookFeel);
        this.m_jcbLookFeelDecorated = new JCheckBox(FPortecle.RB.getString("DOptions.m_jcbLookFeelDecorated.text"), JFrame.isDefaultLookAndFeelDecorated());
        this.m_jcbLookFeelDecorated.setToolTipText(FPortecle.RB.getString("DOptions.m_jcbLookFeelDecorated.tooltip"));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        jPanel5.add(this.m_jcbLookFeelDecorated);
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        jPanel6.add(new JLabel(FPortecle.RB.getString("DOptions.jlDecorationNote.text")));
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.add((Component)jPanel4, "North");
        jPanel7.add((Component)jPanel5, "Center");
        jPanel7.add((Component)jPanel6, "South");
        object = new JTabbedPane();
        ((JTabbedPane)object).addTab(FPortecle.RB.getString("DOptions.jpCaCerts.text"), null, jPanel3, FPortecle.RB.getString("DOptions.jpCaCerts.tooltip"));
        ((JTabbedPane)object).addTab(FPortecle.RB.getString("DOptions.jpLookFeel.text"), null, jPanel7, FPortecle.RB.getString("DOptions.jpLookFeel.tooltip"));
        ((JComponent)object).setBorder(new EmptyBorder(5, 5, 5, 5));
        JButton jButton3 = this.getOkButton(false);
        exception = this.getCancelButton();
        JPanel jPanel8 = new JPanel(new FlowLayout(2));
        jPanel8.add(jButton3);
        jPanel8.add((Component)exception);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)object, "Center");
        this.getContentPane().add((Component)jPanel8, "South");
        this.setTitle(FPortecle.RB.getString("DOptions.Title"));
        this.getRootPane().setDefaultButton(jButton3);
        this.initDialog();
    }

    private void storeOptions() {
        this.m_fCaCertsFile = new File(this.m_jtfCaCertsFile.getText());
        this.m_bUseCaCerts = this.m_jcbUseCaCerts.isSelected();
        this.lookFeelClassName = this.lookFeelInfos.get(this.m_jcbLookFeel.getSelectedItem()).getClassName();
        this.m_bLookFeelDecorated = this.m_jcbLookFeelDecorated.isSelected();
    }

    public File getCaCertsFile() {
        return this.m_fCaCertsFile;
    }

    public boolean isUseCaCerts() {
        return this.m_bUseCaCerts;
    }

    public String getLookFeelClassName() {
        return this.lookFeelClassName;
    }

    public boolean isLookFeelDecoration() {
        return this.m_bLookFeelDecorated;
    }

    private void browsePressed() {
        JFileChooser jFileChooser = FileChooserFactory.getKeyStoreFileChooser(null);
        if (this.m_fCaCertsFile.getParentFile().exists()) {
            jFileChooser.setCurrentDirectory(this.m_fCaCertsFile.getParentFile());
        }
        jFileChooser.setDialogTitle(FPortecle.RB.getString("DOptions.ChooseCACertsKeyStore.Title"));
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showDialog(this, FPortecle.RB.getString("DOptions.CaCertsKeyStoreFileChooser.button"));
        if (n == 0) {
            this.m_jtfCaCertsFile.setText(jFileChooser.getSelectedFile().toString());
            this.m_jtfCaCertsFile.setCaretPosition(0);
        }
    }

    private void resetPressed() {
        this.m_fCaCertsFile = FPortecle.DEFAULT_CA_CERTS_FILE;
        this.m_jtfCaCertsFile.setText(this.m_fCaCertsFile.getAbsolutePath());
        this.m_jtfCaCertsFile.setCaretPosition(0);
    }

    @Override
    protected void okPressed() {
        this.storeOptions();
        super.okPressed();
    }
}

