/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.portecle.FPortecle;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.ReportTreeCellRend;
import net.sf.portecle.StringUtil;
import net.sf.portecle.crypto.CryptoException;
import net.sf.portecle.crypto.DigestType;
import net.sf.portecle.crypto.DigestUtil;
import net.sf.portecle.crypto.KeyPairUtil;
import net.sf.portecle.crypto.KeyStoreType;
import net.sf.portecle.crypto.X509CertUtil;
import net.sf.portecle.gui.error.DThrowable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DKeyStoreReport
extends PortecleJDialog {
    private static final TransformerFactory TF_FACTORY = TransformerFactory.newInstance();
    private static final Properties TF_PROPS;
    private KeyStore m_keystore;

    public DKeyStoreReport(JFrame jFrame, KeyStore keyStore) throws CryptoException {
        super((Window)jFrame, true);
        this.m_keystore = keyStore;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = this.getOkButton(true);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(FPortecle.RB.getString("DKeyStoreReport.jbCopy.text"));
        jButton2.setMnemonic(FPortecle.RB.getString("DKeyStoreReport.jbCopy.mnemonic").charAt(0));
        jButton2.setToolTipText(FPortecle.RB.getString("DKeyStoreReport.jbCopy.tooltip"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DKeyStoreReport.this.copyPressed(false);
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(FPortecle.RB.getString("DKeyStoreReport.jbCopyXml.text"));
        jButton3.setMnemonic(FPortecle.RB.getString("DKeyStoreReport.jbCopyXml.mnemonic").charAt(0));
        jButton3.setToolTipText(FPortecle.RB.getString("DKeyStoreReport.jbCopyXml.tooltip"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DKeyStoreReport.this.copyPressed(true);
            }
        });
        jPanel.add(jButton3);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTree jTree = new JTree(this.createReportNodes());
        jTree.setRowHeight(18);
        jTree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(jTree);
        jTree.setCellRenderer(new ReportTreeCellRend());
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandTree(jTree, new TreePath(treeNode));
        JScrollPane jScrollPane = new JScrollPane(jTree, 22, 32);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        jPanel2.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        this.setTitle(FPortecle.RB.getString("DKeyStoreReport.Title"));
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
        this.setResizable(true);
        jButton.requestFocusInWindow();
    }

    private void expandTree(JTree jTree, TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandTree(jTree, treePath2);
            }
        }
        jTree.expandPath(treePath);
    }

    private void copyPressed(boolean bl) {
        try {
            String string = null;
            string = !bl ? this.getKeyStoreReport() : this.getKeyStoreReportXml();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(string);
            clipboard.setContents(stringSelection, stringSelection);
        }
        catch (CryptoException cryptoException) {
            DThrowable.showAndWait(this, null, cryptoException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            DThrowable.showAndWait(this, null, parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            DThrowable.showAndWait(this, null, transformerException);
        }
    }

    private String getKeyStoreReportXml() throws CryptoException, ParserConfigurationException, TransformerException {
        StringWriter stringWriter = new StringWriter();
        Transformer transformer = TF_FACTORY.newTransformer();
        transformer.setOutputProperties(TF_PROPS);
        transformer.transform(new DOMSource(this.generateDocument()), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    private String getKeyStoreReport() throws CryptoException {
        try {
            StringBuilder stringBuilder = new StringBuilder(2000);
            KeyStoreType keyStoreType = KeyStoreType.valueOf(this.m_keystore.getType());
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.type"), keyStoreType.name()));
            stringBuilder.append("\n");
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.provider"), this.m_keystore.getProvider().getName()));
            stringBuilder.append("\n");
            stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.entries"), this.m_keystore.size()));
            stringBuilder.append("\n\n");
            Enumeration<String> enumeration = this.m_keystore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate[] x509CertificateArray;
                Certificate[] certificateArray;
                String string = enumeration.nextElement();
                stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.alias"), string));
                stringBuilder.append("\n");
                if (keyStoreType.isEntryCreationDateUseful()) {
                    certificateArray = this.m_keystore.getCreationDate(string);
                    x509CertificateArray = DateFormat.getDateTimeInstance(2, 1).format((Date)certificateArray);
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.creation"), new Object[]{x509CertificateArray}));
                    stringBuilder.append("\n");
                }
                certificateArray = null;
                if (this.m_keystore.isKeyEntry(string)) {
                    certificateArray = this.m_keystore.getCertificateChain(string);
                    if (certificateArray == null || certificateArray.length == 0) {
                        stringBuilder.append(FPortecle.RB.getString("DKeyStoreReport.report.key"));
                        stringBuilder.append("\n");
                    } else {
                        stringBuilder.append(FPortecle.RB.getString("DKeyStoreReport.report.keypair"));
                        stringBuilder.append("\n");
                    }
                } else {
                    stringBuilder.append(FPortecle.RB.getString("DKeyStoreReport.report.trustcert"));
                    stringBuilder.append("\n");
                    x509CertificateArray = this.m_keystore.getCertificate(string);
                    if (x509CertificateArray != null) {
                        certificateArray = new Certificate[]{x509CertificateArray};
                    }
                }
                if (certificateArray == null || certificateArray.length == 0) {
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.certs"), 0));
                    stringBuilder.append("\n\n");
                    continue;
                }
                x509CertificateArray = X509CertUtil.convertCertificates(certificateArray);
                int n = x509CertificateArray.length;
                stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.certs"), n));
                stringBuilder.append("\n\n");
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.cert"), i + 1, n));
                    stringBuilder.append("\n");
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.version"), x509Certificate.getVersion()));
                    stringBuilder.append("\n");
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.subject"), x509Certificate.getSubjectDN()));
                    stringBuilder.append("\n");
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.issuer"), x509Certificate.getIssuerDN()));
                    stringBuilder.append("\n");
                    StringBuilder stringBuilder2 = StringUtil.toHex(x509Certificate.getSerialNumber(), 4, " ");
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.serial"), stringBuilder2));
                    stringBuilder.append("\n");
                    Date date = x509Certificate.getNotBefore();
                    String string2 = DateFormat.getDateTimeInstance(2, 2).format(date);
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.validfrom"), string2));
                    stringBuilder.append("\n");
                    Date date2 = x509Certificate.getNotAfter();
                    String string3 = DateFormat.getDateTimeInstance(2, 2).format(date2);
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.validuntil"), string3));
                    stringBuilder.append("\n");
                    int n2 = KeyPairUtil.getKeyLength(x509Certificate.getPublicKey());
                    String string4 = x509Certificate.getPublicKey().getAlgorithm();
                    String string5 = n2 == -1 ? "DKeyStoreReport.report.pubkeynosize" : "DKeyStoreReport.report.pubkey";
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString(string5), string4, n2));
                    stringBuilder.append("\n");
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.sigalg"), x509Certificate.getSigAlgName()));
                    stringBuilder.append("\n");
                    byte[] byArray = x509Certificate.getEncoded();
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.sha1"), DigestUtil.getMessageDigest(byArray, DigestType.SHA1)));
                    stringBuilder.append("\n");
                    stringBuilder.append(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.report.md5"), DigestUtil.getMessageDigest(byArray, DigestType.MD5)));
                    stringBuilder.append("\n");
                    if (i + 1 >= n) continue;
                    stringBuilder.append("\n");
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("DKeyStoreReport.NoGenerateReport.exception.message"), generalSecurityException);
        }
    }

    private Document generateDocument() throws CryptoException, ParserConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            KeyStoreType keyStoreType = KeyStoreType.valueOf(this.m_keystore.getType());
            String string = this.m_keystore.getProvider().getName();
            Element element = document.createElement("keystore");
            element.setAttribute("type", keyStoreType.name());
            element.setAttribute("provider", string);
            document.appendChild(element);
            Enumeration<String> enumeration = this.m_keystore.aliases();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2;
                String string2 = enumeration.nextElement();
                String string3 = null;
                if (keyStoreType.isEntryCreationDateUseful()) {
                    object2 = this.m_keystore.getCreationDate(string2);
                    string3 = DateFormat.getDateTimeInstance(2, 2).format((Date)object2);
                }
                object2 = null;
                Certificate[] certificateArray = null;
                if (this.m_keystore.isKeyEntry(string2)) {
                    certificateArray = this.m_keystore.getCertificateChain(string2);
                    object2 = certificateArray == null || certificateArray.length == 0 ? "Key" : "KeyPair";
                } else {
                    object2 = "TrustedCertificate";
                    object = this.m_keystore.getCertificate(string2);
                    if (object != null) {
                        certificateArray = new Certificate[]{object};
                    }
                }
                object = document.createElement("entry");
                object.setAttribute("alias", string2);
                if (string3 != null) {
                    object.setAttribute("creation_date", string3);
                }
                object.setAttribute("type", (String)object2);
                element.appendChild((Node)object);
                if (certificateArray == null) continue;
                for (X509Certificate x509Certificate : X509CertUtil.convertCertificates(certificateArray)) {
                    Element element2 = document.createElement("certificate");
                    object.appendChild(element2);
                    Element element3 = document.createElement("version");
                    element2.appendChild(element3);
                    element3.appendChild(document.createTextNode("" + x509Certificate.getVersion()));
                    Element element4 = document.createElement("subject");
                    element2.appendChild(element4);
                    element4.appendChild(document.createTextNode(((Object)x509Certificate.getSubjectDN()).toString()));
                    Element element5 = document.createElement("issuer");
                    element2.appendChild(element5);
                    element5.appendChild(document.createTextNode(((Object)x509Certificate.getIssuerDN()).toString()));
                    Element element6 = document.createElement("serial_number");
                    element2.appendChild(element6);
                    element6.appendChild(document.createTextNode(StringUtil.toHex(x509Certificate.getSerialNumber(), 4, " ").toString()));
                    Date date = x509Certificate.getNotBefore();
                    String string4 = DateFormat.getDateTimeInstance(2, 2).format(date);
                    Element element7 = document.createElement("valid_from");
                    element2.appendChild(element7);
                    element7.appendChild(document.createTextNode(string4));
                    Date date2 = x509Certificate.getNotAfter();
                    String string5 = DateFormat.getDateTimeInstance(2, 2).format(date2);
                    Element element8 = document.createElement("valid_until");
                    element2.appendChild(element8);
                    element8.appendChild(document.createTextNode(string5));
                    int n = KeyPairUtil.getKeyLength(x509Certificate.getPublicKey());
                    String string6 = x509Certificate.getPublicKey().getAlgorithm();
                    if (n != -1) {
                        string6 = MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.KeyAlg"), string6, n);
                    }
                    Element element9 = document.createElement("public_key_algorithm");
                    element2.appendChild(element9);
                    element9.appendChild(document.createTextNode(string6));
                    Element element10 = document.createElement("signature_algorithm");
                    element2.appendChild(element10);
                    element10.appendChild(document.createTextNode(x509Certificate.getSigAlgName()));
                    byte[] byArray = x509Certificate.getEncoded();
                    Element element11 = document.createElement("sha1_fingerprint");
                    element2.appendChild(element11);
                    element11.appendChild(document.createTextNode(DigestUtil.getMessageDigest(byArray, DigestType.SHA1)));
                    Element element12 = document.createElement("md5_fingerprint");
                    element2.appendChild(element12);
                    element12.appendChild(document.createTextNode(DigestUtil.getMessageDigest(byArray, DigestType.MD5)));
                }
            }
            return document;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("DKeyStoreReport.NoGenerateReport.exception.message"), generalSecurityException);
        }
    }

    private DefaultMutableTreeNode createReportNodes() throws CryptoException {
        try {
            KeyStoreType keyStoreType = KeyStoreType.valueOf(this.m_keystore.getType());
            String string = this.m_keystore.getProvider().getName();
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.TopNodeName"), keyStoreType.name(), string));
            Enumeration<String> enumeration = this.m_keystore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate[] x509CertificateArray;
                Serializable serializable;
                String string2 = enumeration.nextElement();
                Certificate[] certificateArray = null;
                DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                if (this.m_keystore.isKeyEntry(string2)) {
                    certificateArray = this.m_keystore.getCertificateChain(string2);
                    defaultMutableTreeNode2 = certificateArray == null || certificateArray.length == 0 ? new DefaultMutableTreeNode(ReportTreeCellRend.Entry.getKeyInstance(string2)) : new DefaultMutableTreeNode(ReportTreeCellRend.Entry.getKeyPairInstance(string2));
                } else {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(ReportTreeCellRend.Entry.getTrustedCertificateInstance(string2));
                    serializable = this.m_keystore.getCertificate(string2);
                    if (serializable != null) {
                        certificateArray = new Certificate[]{serializable};
                    }
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                if (keyStoreType.isEntryCreationDateUseful()) {
                    serializable = this.m_keystore.getCreationDate(string2);
                    x509CertificateArray = DateFormat.getDateTimeInstance(2, 2).format((Date)serializable);
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(x509CertificateArray));
                }
                if (certificateArray == null || certificateArray.length == 0) continue;
                serializable = new DefaultMutableTreeNode(FPortecle.RB.getString("DKeyStoreReport.Certificates"));
                defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                x509CertificateArray = X509CertUtil.convertCertificates(certificateArray);
                int n = x509CertificateArray.length;
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.Certificate"), i + 1, n));
                    ((DefaultMutableTreeNode)serializable).add(defaultMutableTreeNode3);
                    X509Certificate x509Certificate = x509CertificateArray[i];
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode("" + x509Certificate.getVersion()));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(x509Certificate.getSubjectDN()));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(x509Certificate.getIssuerDN()));
                    StringBuilder stringBuilder = StringUtil.toHex(x509Certificate.getSerialNumber(), 4, " ");
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(stringBuilder));
                    Date date = x509Certificate.getNotBefore();
                    String string3 = DateFormat.getDateTimeInstance(2, 2).format(date);
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(string3));
                    Date date2 = x509Certificate.getNotAfter();
                    String string4 = DateFormat.getDateTimeInstance(2, 2).format(date2);
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(string4));
                    int n2 = KeyPairUtil.getKeyLength(x509Certificate.getPublicKey());
                    String string5 = x509Certificate.getPublicKey().getAlgorithm();
                    if (n2 != -1) {
                        string5 = MessageFormat.format(FPortecle.RB.getString("DKeyStoreReport.KeyAlg"), string5, n2);
                    }
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(string5));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(x509Certificate.getSigAlgName()));
                    byte[] byArray = x509Certificate.getEncoded();
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DigestUtil.getMessageDigest(byArray, DigestType.SHA1)));
                    defaultMutableTreeNode3.add(new DefaultMutableTreeNode(DigestUtil.getMessageDigest(byArray, DigestType.MD5)));
                }
            }
            return defaultMutableTreeNode;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CryptoException(FPortecle.RB.getString("DKeyStoreReport.NoGenerateReport.exception.message"), generalSecurityException);
        }
    }

    static {
        try {
            TF_FACTORY.setAttribute("indent-number", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TF_PROPS = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = DKeyStoreReport.class.getResourceAsStream("keystore-report-xml.properties");
            TF_PROPS.load(inputStream);
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new ExceptionInInitializerError(iOException);
                }
            }
        }
    }
}

