/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.sf.portecle.FPortecle;
import net.sf.portecle.KeyStoreWrapper;
import net.sf.portecle.PortecleJDialog;
import net.sf.portecle.crypto.CryptoException;

class DExport
extends PortecleJDialog {
    private JRadioButton m_jrbHeadCertOnly;
    private JRadioButton m_jrbCertChain;
    private JRadioButton m_jrbPrivKeyCertChain;
    private JRadioButton m_jrbDEREncoded;
    private JRadioButton m_jrbPemEncoded;
    private JRadioButton m_jrbPKCS7;
    private JRadioButton m_jrbPkiPath;
    private JRadioButton m_jrbPKCS12;
    private KeyStoreWrapper m_keyStoreWrap;
    private String m_sEntryAlias;
    private boolean m_bExportSelected;

    public DExport(Window window, KeyStoreWrapper keyStoreWrapper, String string) throws CryptoException {
        super(window, true);
        this.m_keyStoreWrap = keyStoreWrapper;
        this.m_sEntryAlias = string;
        this.initComponents();
    }

    private void initComponents() throws CryptoException {
        JPanel jPanel = new JPanel(new GridLayout(3, 1));
        jPanel.setBorder(new TitledBorder(FPortecle.RB.getString("DExport.jpExportType.text")));
        this.m_jrbHeadCertOnly = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbHeadCertOnly.text"), true);
        this.m_jrbHeadCertOnly.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DExport.this.m_jrbDEREncoded.setEnabled(true);
                if (DExport.this.m_jrbPKCS12.isSelected()) {
                    DExport.this.m_jrbDEREncoded.setSelected(true);
                }
                DExport.this.m_jrbPemEncoded.setEnabled(true);
                DExport.this.m_jrbPKCS7.setEnabled(true);
                DExport.this.m_jrbPkiPath.setEnabled(true);
                DExport.this.m_jrbPKCS12.setEnabled(false);
            }
        });
        this.m_jrbCertChain = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbCertChain.text"));
        this.m_jrbCertChain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DExport.this.m_jrbDEREncoded.setEnabled(false);
                DExport.this.m_jrbPemEncoded.setEnabled(false);
                DExport.this.m_jrbPKCS7.setEnabled(true);
                if (!DExport.this.m_jrbPkiPath.isSelected()) {
                    DExport.this.m_jrbPKCS7.setSelected(true);
                }
                DExport.this.m_jrbPkiPath.setEnabled(true);
                DExport.this.m_jrbPKCS12.setEnabled(false);
            }
        });
        this.m_jrbPrivKeyCertChain = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbPrivKeyCertChain.text"));
        this.m_jrbPrivKeyCertChain.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DExport.this.m_jrbDEREncoded.setEnabled(false);
                DExport.this.m_jrbPemEncoded.setEnabled(true);
                DExport.this.m_jrbPKCS7.setEnabled(false);
                DExport.this.m_jrbPkiPath.setEnabled(false);
                DExport.this.m_jrbPKCS12.setEnabled(true);
                if (!DExport.this.m_jrbPemEncoded.isSelected()) {
                    DExport.this.m_jrbPKCS12.setSelected(true);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_jrbHeadCertOnly);
        buttonGroup.add(this.m_jrbCertChain);
        buttonGroup.add(this.m_jrbPrivKeyCertChain);
        jPanel.add(this.m_jrbHeadCertOnly);
        jPanel.add(this.m_jrbCertChain);
        jPanel.add(this.m_jrbPrivKeyCertChain);
        JPanel jPanel2 = new JPanel(new GridLayout(5, 1));
        jPanel2.setBorder(new TitledBorder(FPortecle.RB.getString("DExport.jpExportFormat.text")));
        this.m_jrbDEREncoded = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbDEREncoded.text"), true);
        this.m_jrbPemEncoded = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbPemEncoded.text"));
        this.m_jrbPKCS7 = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbPKCS7.text"));
        this.m_jrbPkiPath = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbPkiPath.text"));
        this.m_jrbPKCS12 = new JRadioButton(FPortecle.RB.getString("DExport.m_jrbPKCS12.text"));
        this.m_jrbPKCS12.setEnabled(false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_jrbDEREncoded);
        buttonGroup2.add(this.m_jrbPemEncoded);
        buttonGroup2.add(this.m_jrbPKCS7);
        buttonGroup2.add(this.m_jrbPkiPath);
        buttonGroup2.add(this.m_jrbPKCS12);
        jPanel2.add(this.m_jrbDEREncoded);
        jPanel2.add(this.m_jrbPemEncoded);
        jPanel2.add(this.m_jrbPKCS7);
        jPanel2.add(this.m_jrbPkiPath);
        jPanel2.add(this.m_jrbPKCS12);
        KeyStore keyStore = this.m_keyStoreWrap.getKeyStore();
        try {
            if (keyStore.isCertificateEntry(this.m_sEntryAlias)) {
                this.m_jrbCertChain.setEnabled(false);
                this.m_jrbPrivKeyCertChain.setEnabled(false);
            }
        }
        catch (KeyStoreException keyStoreException) {
            String string = MessageFormat.format(FPortecle.RB.getString("DExport.NoAccessEntry.message"), this.m_sEntryAlias);
            throw new CryptoException(string, keyStoreException);
        }
        JPanel jPanel3 = new JPanel(new BorderLayout(10, 0));
        jPanel3.setBorder(new CompoundBorder(new CompoundBorder(new EmptyBorder(5, 5, 5, 5), new EtchedBorder()), new EmptyBorder(5, 5, 5, 5)));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        JButton jButton = this.getOkButton(false);
        JButton jButton2 = this.getCancelButton();
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel3, "Center");
        this.getContentPane().add((Component)jPanel4, "South");
        this.setTitle(MessageFormat.format(FPortecle.RB.getString("DExport.Title"), this.m_sEntryAlias));
        this.getRootPane().setDefaultButton(jButton);
        this.initDialog();
    }

    public boolean exportSelected() {
        return this.m_bExportSelected;
    }

    public boolean exportHead() {
        return this.m_jrbHeadCertOnly.isSelected();
    }

    public boolean exportChain() {
        return this.m_jrbCertChain.isSelected();
    }

    public boolean exportKeyChain() {
        return this.m_jrbPrivKeyCertChain.isSelected();
    }

    public boolean exportDer() {
        return this.m_jrbDEREncoded.isSelected();
    }

    public boolean exportPem() {
        return this.m_jrbPemEncoded.isSelected();
    }

    public boolean exportPkcs7() {
        return this.m_jrbPKCS7.isSelected();
    }

    public boolean exportPkiPath() {
        return this.m_jrbPkiPath.isSelected();
    }

    public boolean exportPkcs12() {
        return this.m_jrbPKCS12.isSelected();
    }

    @Override
    protected void okPressed() {
        this.m_bExportSelected = true;
        super.okPressed();
    }
}

