drop table CATEGORIES if exists;
drop table CAT_CHANNEL_LINK if exists;
drop table CAT_GROUP_CHANNEL if exists;
drop table CAT_ITEM_LINK if exists;
drop table CHANNELS if exists;
drop table CHANNEL_GROUPS if exists;
drop table CHANNEL_SUBSCRIPTIONS if exists;
drop table CLOUDS if exists;
drop table IMAGES if exists;
drop table ITEMS if exists;
drop table ITEM_ENCLOSURE if exists;
drop table ITEM_GUID if exists;
drop table ITEM_METADATA if exists;
drop table ITEM_SOURCE if exists;
drop table TEXTINPUTS if exists;
drop table CONFIG if exists;


SET IGNORECASE TRUE;


create CACHED table CONFIG (
   CONFIG_ID INTEGER NOT NULL IDENTITY,
   NAME VARCHAR(255),
   ALLOW_DUPLICATED_CHANNELS BIT,
   MAX_CACHE_ITEMS INTEGER,
   REFRESH_TIME INTEGER,
   USE_DEFAULT_BROWSER BIT,
   BROWSER VARCHAR(255) DEFAULT '',
   DESCRIPTION VARCHAR(255)
);

create CACHED table ITEMS (
   ITEM_ID INTEGER NOT NULL IDENTITY,
   CHANNEL_ID INTEGER not null,
   TITLE VARCHAR(255) not null,
   DESCRIPTION VARCHAR(255),
   UNREAD BIT,
   LINK VARBINARY(255),
   CREATOR VARCHAR(255),
   SUBJECT VARCHAR(255),
   DATE VARCHAR(32),
   FOUND TIMESTAMP,
   GUID INTEGER,
   COMMENTS VARBINARY(255),
   SOURCE INTEGER,
   ENCLOSURE INTEGER,
   TIMESTAMP TIMESTAMP DEFAULT 'now'
);

create CACHED table CAT_GROUP_CHANNEL (
   GROUP_ID INTEGER not null,
   CHANNEL_ID INTEGER not null,
   primary key (GROUP_ID, CHANNEL_ID)
);

create CACHED table ITEM_GUID (
   ITEM_GUID_ID INTEGER NOT NULL IDENTITY,
   ITEM_ID INTEGER not null,
   LOCATION VARCHAR(255),
   PERMA_LINK BIT
);

create CACHED table CLOUDS (
   CLOUD_ID INTEGER NOT NULL IDENTITY,
   DOMAIN VARCHAR(255) not null,
   PORT INTEGER not null,
   PATH VARCHAR(255) not null,
   REGISTER_PROCEDURE VARCHAR(255) not null,
   PROTOCOL VARCHAR(255) not null
);

create CACHED table TEXTINPUTS (
   TEXTINPUT_ID INTEGER NOT NULL IDENTITY,
   TITLE VARCHAR(255) not null,
   DESCRIPTION VARCHAR(255),
   NAME VARCHAR(255),
   LINK VARBINARY(255)
);

create CACHED table ITEM_ENCLOSURE (
   ITEM_ENCLOSURE_ID INTEGER NOT NULL IDENTITY,
   ITEM_ID INTEGER not null,
   LOCATION VARBINARY(255),
   TYPE VARCHAR(255),
   LENGTH INTEGER
);

create CACHED table CAT_ITEM_LINK (
   ITEM_ID INTEGER not null,
   CATEGORY_ID INTEGER not null
);

create CACHED table CAT_CHANNEL_LINK (
   CHANNEL_ID INTEGER not null,
   CATEGORY_ID INTEGER not null
);

create CACHED table CATEGORIES (
   CATEGORY_ID INTEGER NOT NULL IDENTITY,
   TITLE VARCHAR(255) not null,
   PARENT_ID INTEGER
);

create CACHED table IMAGES (
   IMAGE_ID INTEGER NOT NULL IDENTITY,
   TITLE VARCHAR(255) not null,
   DESCRIPTION VARCHAR(255),
   LOCATION VARBINARY(255),
   LINK VARBINARY(255),
   WIDTH INTEGER,
   HEIGHT INTEGER
);

create CACHED table ITEM_SOURCE (
   ITEM_SOURCE_ID INTEGER NOT NULL IDENTITY,
   ITEM_ID INTEGER not null,
   NAME VARCHAR(255),
   LOCATION VARCHAR(255),
   TIMESTAMP TIMESTAMP
);

create CACHED table CHANNEL_SUBSCRIPTIONS (
   CHANNEL_SUBSCRIPTION_ID INTEGER NOT NULL IDENTITY,
   CHANNEL_ID INTEGER not null,
   ACTIVE BIT,
   UPDATE_INTERVAL INTEGER
);

create CACHED table CHANNELS (
   CHANNEL_ID INTEGER NOT NULL IDENTITY,
   TITLE VARCHAR(255) not null,
   DESCRIPTION VARCHAR(255),
   LOCSTRING VARCHAR(255),
   SITE VARBINARY(255),
   CREATOR VARCHAR(255),
   PUBLISHER VARCHAR(255),
   LANGUAGE VARCHAR(255),
   FORMAT VARCHAR(255),
   IMAGE_ID INTEGER,
   TEXTINPUT_ID INTEGER,
   COPYRIGHT VARCHAR(255),
   RATING VARCHAR(255),
   CLOUD_ID INTEGER,
   GENERATOR VARCHAR(255),
   DOCS VARCHAR(255),
   TTL INTEGER,
   LAST_UPDATED TIMESTAMP,
   LAST_BUILD_DATE TIMESTAMP,
   PUB_DATE TIMESTAMP,
   UPDATE_PERIOD VARCHAR(255),
   UPDATE_FREQUENCY INTEGER,
   UPDATE_BASE TIMESTAMP,
   TIMESTAMP TIMESTAMP DEFAULT 'now'
);

create CACHED table ITEM_METADATA (
   ITEM_METADATA_ID INTEGER NOT NULL IDENTITY,
   ITEM_ID INTEGER not null,
   MARKED_READ BIT,
   SCORE INTEGER
);

create CACHED table CHANNEL_GROUPS (
   CHANNEL_GROUP_ID INTEGER NOT NULL IDENTITY,
   TITLE VARCHAR(255) not null,
   PARENT_ID INTEGER
);

alter table ITEMS add constraint FK42BEFA0A9D495F7 foreign key (CHANNEL_ID) references CHANNELS;
alter table ITEMS add constraint FK42BEFA0218E89 foreign key (GUID) references ITEM_GUID;
alter table ITEMS add constraint FK42BEFA092235C1B foreign key (SOURCE) references ITEM_SOURCE;
alter table ITEMS add constraint FK42BEFA0FB7FAD52 foreign key (ENCLOSURE) references ITEM_ENCLOSURE;
alter table CAT_GROUP_CHANNEL add constraint FK94C7FE3AA9D495F7 foreign key (CHANNEL_ID) references CHANNELS;
alter table CAT_GROUP_CHANNEL add constraint FK94C7FE3A4CD4DEFB foreign key (GROUP_ID) references CHANNEL_GROUPS;
alter table ITEM_GUID add constraint FK2835C835A8EEBDC7 foreign key (ITEM_ID) references ITEMS;
alter table ITEM_ENCLOSURE add constraint FK29A89F26A8EEBDC7 foreign key (ITEM_ID) references ITEMS;
alter table CAT_ITEM_LINK add constraint FKAE9345DA8EEBDC7 foreign key (ITEM_ID) references ITEMS;
alter table CAT_ITEM_LINK add constraint FKAE9345DDBFCB7FC foreign key (CATEGORY_ID) references CATEGORIES;
alter table CAT_CHANNEL_LINK add constraint FK510BBFA9D495F7 foreign key (CHANNEL_ID) references CHANNELS;
alter table CAT_CHANNEL_LINK add constraint FK510BBFDBFCB7FC foreign key (CATEGORY_ID) references CATEGORIES;
alter table CATEGORIES add constraint FK6A31321C217F38D0 foreign key (PARENT_ID) references CATEGORIES;
alter table ITEM_SOURCE add constraint FK60FDAC7A8EEBDC7 foreign key (ITEM_ID) references ITEMS;
alter table CHANNEL_SUBSCRIPTIONS add constraint FK9CF8F47AA9D495F7 foreign key (CHANNEL_ID) references CHANNELS;
alter table CHANNELS add constraint FK840A13D06FE55385 foreign key (CLOUD_ID) references CLOUDS;
alter table CHANNELS add constraint FK840A13D09256B5FD foreign key (TEXTINPUT_ID) references TEXTINPUTS;
alter table CHANNELS add constraint FK840A13D0FB69EE9F foreign key (IMAGE_ID) references IMAGES;
alter table ITEM_METADATA add constraint FK3E9AEEDBA8EEBDC7 foreign key (ITEM_ID) references ITEMS;
alter table CHANNEL_GROUPS add constraint FKDE9B8CB0217F38D0 foreign key (PARENT_ID) references CHANNEL_GROUPS;	


INSERT INTO CONFIG(NAME, ALLOW_DUPLICATED_CHANNELS, MAX_CACHE_ITEMS, REFRESH_TIME, USE_DEFAULT_BROWSER, BROWSER, DESCRIPTION) VALUES('JideRssReader', 0, 10, 30, 1, '', 'JideRssReader');
INSERT INTO CHANNEL_GROUPS(CHANNEL_GROUP_ID, TITLE) VALUES(0, 'Default Category');
