/*
 * Copyright 2004-2014 SmartBear Software
 *
 * Licensed under the EUPL, Version 1.1 or - as soon as they will be approved by the European Commission - subsequent
 * versions of the EUPL (the "Licence");
 * You may not use this work except in compliance with the Licence.
 * You may obtain a copy of the Licence at:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the Licence is
 * distributed on an "AS IS" basis, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the Licence for the specific language governing permissions and limitations
 * under the Licence.
*/

package org.syntax.jedit.tokenmarker;

import org.syntax.jedit.KeywordMap;

/**
 * Transact-SQL token marker.
 *
 * @author mike dillon
 * @version $Id: TSQLTokenMarker.java,v 1.9 1999/12/13 03:40:30 sp Exp $
 */
public class TSQLTokenMarker extends SQLTokenMarker {
    // public members
    public TSQLTokenMarker() {
        super(getKeywordMap(), true);
    }

    public static KeywordMap getKeywordMap() {
        if (tsqlKeywords == null) {
            tsqlKeywords = new KeywordMap(true);
            addKeywords();
            addDataTypes();
            addSystemFunctions();
            addOperators();
            addSystemStoredProcedures();
            addSystemTables();
        }
        return tsqlKeywords;
    }

    private static void addKeywords() {
        tsqlKeywords.add("ADD", Token.KEYWORD1);
        tsqlKeywords.add("ALTER", Token.KEYWORD1);
        tsqlKeywords.add("ANSI_NULLS", Token.KEYWORD1);
        tsqlKeywords.add("AS", Token.KEYWORD1);
        tsqlKeywords.add("ASC", Token.KEYWORD1);
        tsqlKeywords.add("AUTHORIZATION", Token.KEYWORD1);
        tsqlKeywords.add("BACKUP", Token.KEYWORD1);
        tsqlKeywords.add("BEGIN", Token.KEYWORD1);
        tsqlKeywords.add("BREAK", Token.KEYWORD1);
        tsqlKeywords.add("BROWSE", Token.KEYWORD1);
        tsqlKeywords.add("BULK", Token.KEYWORD1);
        tsqlKeywords.add("BY", Token.KEYWORD1);
        tsqlKeywords.add("CASCADE", Token.KEYWORD1);
        tsqlKeywords.add("CHECK", Token.KEYWORD1);
        tsqlKeywords.add("CHECKPOINT", Token.KEYWORD1);
        tsqlKeywords.add("CLOSE", Token.KEYWORD1);
        tsqlKeywords.add("CLUSTERED", Token.KEYWORD1);
        tsqlKeywords.add("COLUMN", Token.KEYWORD1);
        tsqlKeywords.add("COMMIT", Token.KEYWORD1);
        tsqlKeywords.add("COMMITTED", Token.KEYWORD1);
        tsqlKeywords.add("COMPUTE", Token.KEYWORD1);
        tsqlKeywords.add("CONFIRM", Token.KEYWORD1);
        tsqlKeywords.add("CONSTRAINT", Token.KEYWORD1);
        tsqlKeywords.add("CONTAINS", Token.KEYWORD1);
        tsqlKeywords.add("CONTAINSTABLE", Token.KEYWORD1);
        tsqlKeywords.add("CONTINUE", Token.KEYWORD1);
        tsqlKeywords.add("CONTROLROW", Token.KEYWORD1);
        tsqlKeywords.add("CREATE", Token.KEYWORD1);
        tsqlKeywords.add("CURRENT", Token.KEYWORD1);
        tsqlKeywords.add("CURRENT_DATE", Token.KEYWORD1);
        tsqlKeywords.add("CURRENT_TIME", Token.KEYWORD1);
        tsqlKeywords.add("CURSOR", Token.KEYWORD1);
        tsqlKeywords.add("DATABASE", Token.KEYWORD1);
        tsqlKeywords.add("DBCC", Token.KEYWORD1);
        tsqlKeywords.add("DEALLOCATE", Token.KEYWORD1);
        tsqlKeywords.add("DECLARE", Token.KEYWORD1);
        tsqlKeywords.add("DEFAULT", Token.KEYWORD1);
        tsqlKeywords.add("DELETE", Token.KEYWORD1);
        tsqlKeywords.add("DENY", Token.KEYWORD1);
        tsqlKeywords.add("DESC", Token.KEYWORD1);
        tsqlKeywords.add("DISK", Token.KEYWORD1);
        tsqlKeywords.add("DISTINCT", Token.KEYWORD1);
        tsqlKeywords.add("DISTRIBUTED", Token.KEYWORD1);
        tsqlKeywords.add("DOUBLE", Token.KEYWORD1);
        tsqlKeywords.add("DROP", Token.KEYWORD1);
        tsqlKeywords.add("DUMMY", Token.KEYWORD1);
        tsqlKeywords.add("DUMP", Token.KEYWORD1);
        tsqlKeywords.add("ELSE", Token.KEYWORD1);
        tsqlKeywords.add("END", Token.KEYWORD1);
        tsqlKeywords.add("ERRLVL", Token.KEYWORD1);
        tsqlKeywords.add("ERROREXIT", Token.KEYWORD1);
        tsqlKeywords.add("ESCAPE", Token.KEYWORD1);
        tsqlKeywords.add("EXCEPT", Token.KEYWORD1);
        tsqlKeywords.add("EXEC", Token.KEYWORD1);
        tsqlKeywords.add("EXECUTE", Token.KEYWORD1);
        tsqlKeywords.add("EXIT", Token.KEYWORD1);
        tsqlKeywords.add("FETCH", Token.KEYWORD1);
        tsqlKeywords.add("FILE", Token.KEYWORD1);
        tsqlKeywords.add("FILLFACTOR", Token.KEYWORD1);
        tsqlKeywords.add("FLOPPY", Token.KEYWORD1);
        tsqlKeywords.add("FOR", Token.KEYWORD1);
        tsqlKeywords.add("FOREIGN", Token.KEYWORD1);
        tsqlKeywords.add("FREETEXT", Token.KEYWORD1);
        tsqlKeywords.add("FREETEXTTABLE", Token.KEYWORD1);
        tsqlKeywords.add("FROM", Token.KEYWORD1);
        tsqlKeywords.add("FULL", Token.KEYWORD1);
        tsqlKeywords.add("GOTO", Token.KEYWORD1);
        tsqlKeywords.add("GRANT", Token.KEYWORD1);
        tsqlKeywords.add("GROUP", Token.KEYWORD1);
        tsqlKeywords.add("HAVING", Token.KEYWORD1);
        tsqlKeywords.add("HOLDLOCK", Token.KEYWORD1);
        tsqlKeywords.add("IDENTITY_INSERT", Token.KEYWORD1);
        tsqlKeywords.add("IDENTITYCOL", Token.KEYWORD1);
        tsqlKeywords.add("ID", Token.KEYWORD1);
        tsqlKeywords.add("IF", Token.KEYWORD1);
        tsqlKeywords.add("INDEX", Token.KEYWORD1);
        tsqlKeywords.add("INNER", Token.KEYWORD1);
        tsqlKeywords.add("INSERT", Token.KEYWORD1);
        tsqlKeywords.add("INTO", Token.KEYWORD1);
        tsqlKeywords.add("IS", Token.KEYWORD1);
        tsqlKeywords.add("ISOLATION", Token.KEYWORD1);
        tsqlKeywords.add("KEY", Token.KEYWORD1);
        tsqlKeywords.add("KILL", Token.KEYWORD1);
        tsqlKeywords.add("LEVEL", Token.KEYWORD1);
        tsqlKeywords.add("LINENO", Token.KEYWORD1);
        tsqlKeywords.add("LOAD", Token.KEYWORD1);
        tsqlKeywords.add("MAX", Token.KEYWORD1);
        tsqlKeywords.add("MIN", Token.KEYWORD1);
        tsqlKeywords.add("MIRROREXIT", Token.KEYWORD1);
        tsqlKeywords.add("NATIONAL", Token.KEYWORD1);
        tsqlKeywords.add("NOCHECK", Token.KEYWORD1);
        tsqlKeywords.add("NONCLUSTERED", Token.KEYWORD1);
        tsqlKeywords.add("OF", Token.KEYWORD1);
        tsqlKeywords.add("OFF", Token.KEYWORD1);
        tsqlKeywords.add("OFFSETS", Token.KEYWORD1);
        tsqlKeywords.add("ON", Token.KEYWORD1);
        tsqlKeywords.add("ONCE", Token.KEYWORD1);
        tsqlKeywords.add("ONLY", Token.KEYWORD1);
        tsqlKeywords.add("OPEN", Token.KEYWORD1);
        tsqlKeywords.add("OPENDATASOURCE", Token.KEYWORD1);
        tsqlKeywords.add("OPENQUERY", Token.KEYWORD1);
        tsqlKeywords.add("OPENROWSET", Token.KEYWORD1);
        tsqlKeywords.add("OPTION", Token.KEYWORD1);
        tsqlKeywords.add("ORDER", Token.KEYWORD1);
        tsqlKeywords.add("OVER", Token.KEYWORD1);
        tsqlKeywords.add("PERCENT", Token.KEYWORD1);
        tsqlKeywords.add("PERM", Token.KEYWORD1);
        tsqlKeywords.add("PERMANENT", Token.KEYWORD1);
        tsqlKeywords.add("PIPE", Token.KEYWORD1);
        tsqlKeywords.add("PLAN", Token.KEYWORD1);
        tsqlKeywords.add("PRECISION", Token.KEYWORD1);
        tsqlKeywords.add("PREPARE", Token.KEYWORD1);
        tsqlKeywords.add("PRIMARY", Token.KEYWORD1);
        tsqlKeywords.add("PRINT", Token.KEYWORD1);
        tsqlKeywords.add("PRIVILEGES", Token.KEYWORD1);
        tsqlKeywords.add("PROC", Token.KEYWORD1);
        tsqlKeywords.add("PROCEDURE", Token.KEYWORD1);
        tsqlKeywords.add("PROCESSEXIT", Token.KEYWORD1);
        tsqlKeywords.add("PUBLIC", Token.KEYWORD1);
        tsqlKeywords.add("QUOTED_IDENTIFIER", Token.KEYWORD1);
        tsqlKeywords.add("RAISERROR", Token.KEYWORD1);
        tsqlKeywords.add("READ", Token.KEYWORD1);
        tsqlKeywords.add("READTEXT", Token.KEYWORD1);
        tsqlKeywords.add("RECONFIGURE", Token.KEYWORD1);
        tsqlKeywords.add("REFERENCES", Token.KEYWORD1);
        tsqlKeywords.add("REPEATABLE", Token.KEYWORD1);
        tsqlKeywords.add("REPLICATION", Token.KEYWORD1);
        tsqlKeywords.add("RESTORE", Token.KEYWORD1);
        tsqlKeywords.add("RESTRICT", Token.KEYWORD1);
        tsqlKeywords.add("RETURN", Token.KEYWORD1);
        tsqlKeywords.add("REVOKE", Token.KEYWORD1);
        tsqlKeywords.add("ROLLBACK", Token.KEYWORD1);
        tsqlKeywords.add("ROWGUIDCOL", Token.KEYWORD1);
        tsqlKeywords.add("RULE", Token.KEYWORD1);
        tsqlKeywords.add("SAVE", Token.KEYWORD1);
        tsqlKeywords.add("SCHEMA", Token.KEYWORD1);
        tsqlKeywords.add("SELECT", Token.KEYWORD1);
        tsqlKeywords.add("SERIALIZABLE", Token.KEYWORD1);
        tsqlKeywords.add("SET", Token.KEYWORD1);
        tsqlKeywords.add("SETUSER", Token.KEYWORD1);
        tsqlKeywords.add("SHUTDOWN", Token.KEYWORD1);
        tsqlKeywords.add("STATISTICS", Token.KEYWORD1);
        tsqlKeywords.add("TABLE", Token.KEYWORD1);
        tsqlKeywords.add("TAPE", Token.KEYWORD1);
        tsqlKeywords.add("TEMP", Token.KEYWORD1);
        tsqlKeywords.add("TEMPORARY", Token.KEYWORD1);
        tsqlKeywords.add("TEXTIMAGE_ON", Token.KEYWORD1);
        tsqlKeywords.add("THEN", Token.KEYWORD1);
        tsqlKeywords.add("TO", Token.KEYWORD1);
        tsqlKeywords.add("TOP", Token.KEYWORD1);
        tsqlKeywords.add("TRAN", Token.KEYWORD1);
        tsqlKeywords.add("TRANSACTION", Token.KEYWORD1);
        tsqlKeywords.add("TRIGGER", Token.KEYWORD1);
        tsqlKeywords.add("TRUNCATE", Token.KEYWORD1);
        tsqlKeywords.add("TSEQUAL", Token.KEYWORD1);
        tsqlKeywords.add("UNCOMMITTED", Token.KEYWORD1);
        tsqlKeywords.add("UNION", Token.KEYWORD1);
        tsqlKeywords.add("UNIQUE", Token.KEYWORD1);
        tsqlKeywords.add("UPDATE", Token.KEYWORD1);
        tsqlKeywords.add("UPDATETEXT", Token.KEYWORD1);
        tsqlKeywords.add("USE", Token.KEYWORD1);
        tsqlKeywords.add("VALUES", Token.KEYWORD1);
        tsqlKeywords.add("VARYING", Token.KEYWORD1);
        tsqlKeywords.add("VIEW", Token.KEYWORD1);
        tsqlKeywords.add("WAITFOR", Token.KEYWORD1);
        tsqlKeywords.add("WHEN", Token.KEYWORD1);
        tsqlKeywords.add("WHERE", Token.KEYWORD1);
        tsqlKeywords.add("WHILE", Token.KEYWORD1);
        tsqlKeywords.add("WITH", Token.KEYWORD1);
        tsqlKeywords.add("WORK", Token.KEYWORD1);
        tsqlKeywords.add("WRITETEXT", Token.KEYWORD1);
    }

    private static void addDataTypes() {
        tsqlKeywords.add("binary", Token.KEYWORD1);
        tsqlKeywords.add("bit", Token.KEYWORD1);
        tsqlKeywords.add("char", Token.KEYWORD1);
        tsqlKeywords.add("character", Token.KEYWORD1);
        tsqlKeywords.add("datetime", Token.KEYWORD1);
        tsqlKeywords.add("decimal", Token.KEYWORD1);
        tsqlKeywords.add("float", Token.KEYWORD1);
        tsqlKeywords.add("image", Token.KEYWORD1);
        tsqlKeywords.add("int", Token.KEYWORD1);
        tsqlKeywords.add("integer", Token.KEYWORD1);
        tsqlKeywords.add("money", Token.KEYWORD1);
        tsqlKeywords.add("name", Token.KEYWORD1);
        tsqlKeywords.add("numeric", Token.KEYWORD1);
        tsqlKeywords.add("nchar", Token.KEYWORD1);
        tsqlKeywords.add("nvarchar", Token.KEYWORD1);
        tsqlKeywords.add("ntext", Token.KEYWORD1);
        tsqlKeywords.add("real", Token.KEYWORD1);
        tsqlKeywords.add("smalldatetime", Token.KEYWORD1);
        tsqlKeywords.add("smallint", Token.KEYWORD1);
        tsqlKeywords.add("smallmoney", Token.KEYWORD1);
        tsqlKeywords.add("text", Token.KEYWORD1);
        tsqlKeywords.add("timestamp", Token.KEYWORD1);
        tsqlKeywords.add("tinyint", Token.KEYWORD1);
        tsqlKeywords.add("uniqueidentifier", Token.KEYWORD1);
        tsqlKeywords.add("varbinary", Token.KEYWORD1);
        tsqlKeywords.add("varchar", Token.KEYWORD1);
    }

    private static void addSystemFunctions() {
        tsqlKeywords.add("@@CONNECTIONS", Token.KEYWORD2);
        tsqlKeywords.add("@@CPU_BUSY", Token.KEYWORD2);
        tsqlKeywords.add("@@CURSOR_ROWS", Token.KEYWORD2);
        tsqlKeywords.add("@@DATEFIRST", Token.KEYWORD2);
        tsqlKeywords.add("@@DBTS", Token.KEYWORD2);
        tsqlKeywords.add("@@ERROR", Token.KEYWORD2);
        tsqlKeywords.add("@@FETCH_STATUS", Token.KEYWORD2);
        tsqlKeywords.add("@@IDENTITY", Token.KEYWORD2);
        tsqlKeywords.add("@@IDLE", Token.KEYWORD2);
        tsqlKeywords.add("@@IO_BUSY", Token.KEYWORD2);
        tsqlKeywords.add("@@LANGID", Token.KEYWORD2);
        tsqlKeywords.add("@@LANGUAGE", Token.KEYWORD2);
        tsqlKeywords.add("@@LOCK_TIMEOUT", Token.KEYWORD2);
        tsqlKeywords.add("@@MAX_CONNECTIONS", Token.KEYWORD2);
        tsqlKeywords.add("@@MAX_PRECISION", Token.KEYWORD2);
        tsqlKeywords.add("@@NESTLEVEL", Token.KEYWORD2);
        tsqlKeywords.add("@@OPTIONS", Token.KEYWORD2);
        tsqlKeywords.add("@@PACK_RECEIVED", Token.KEYWORD2);
        tsqlKeywords.add("@@PACK_SENT", Token.KEYWORD2);
        tsqlKeywords.add("@@PACKET_ERRORS", Token.KEYWORD2);
        tsqlKeywords.add("@@PROCID", Token.KEYWORD2);
        tsqlKeywords.add("@@REMSERVER", Token.KEYWORD2);
        tsqlKeywords.add("@@ROWCOUNT", Token.KEYWORD2);
        tsqlKeywords.add("@@SERVERNAME", Token.KEYWORD2);
        tsqlKeywords.add("@@SERVICENAME", Token.KEYWORD2);
        tsqlKeywords.add("@@SPID", Token.KEYWORD2);
        tsqlKeywords.add("@@TEXTSIZE", Token.KEYWORD2);
        tsqlKeywords.add("@@TIMETICKS", Token.KEYWORD2);
        tsqlKeywords.add("@@TOTAL_ERRORS", Token.KEYWORD2);
        tsqlKeywords.add("@@TOTAL_READ", Token.KEYWORD2);
        tsqlKeywords.add("@@TOTAL_WRITE", Token.KEYWORD2);
        tsqlKeywords.add("@@TRANCOUNT", Token.KEYWORD2);
        tsqlKeywords.add("@@VERSION", Token.KEYWORD2);
        tsqlKeywords.add("ABS", Token.KEYWORD2);
        tsqlKeywords.add("ACOS", Token.KEYWORD2);
        tsqlKeywords.add("APP_NAME", Token.KEYWORD2);
        tsqlKeywords.add("ASCII", Token.KEYWORD2);
        tsqlKeywords.add("ASIN", Token.KEYWORD2);
        tsqlKeywords.add("ATAN", Token.KEYWORD2);
        tsqlKeywords.add("ATN2", Token.KEYWORD2);
        tsqlKeywords.add("CASE", Token.KEYWORD2);
        tsqlKeywords.add("CAST", Token.KEYWORD2);
        tsqlKeywords.add("CEILING", Token.KEYWORD2);
        // tsqlKeywords.add("CHAR",Token.KEYWORD2);
        tsqlKeywords.add("CHARINDEX", Token.KEYWORD2);
        tsqlKeywords.add("COALESCE", Token.KEYWORD2);
        tsqlKeywords.add("COL_LENGTH", Token.KEYWORD2);
        tsqlKeywords.add("COL_NAME", Token.KEYWORD2);
        tsqlKeywords.add("COLUMNPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("CONVERT", Token.KEYWORD2);
        tsqlKeywords.add("COS", Token.KEYWORD2);
        tsqlKeywords.add("COT", Token.KEYWORD2);
        tsqlKeywords.add("CURRENT_TIME", Token.KEYWORD2);
        tsqlKeywords.add("CURRENT_DATE", Token.KEYWORD2);
        tsqlKeywords.add("CURRENT_TIMESTAMP", Token.KEYWORD2);
        tsqlKeywords.add("CURRENT_USER", Token.KEYWORD2);
        tsqlKeywords.add("CURSOR_STATUS", Token.KEYWORD2);
        tsqlKeywords.add("DATABASEPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("DATALENGTH", Token.KEYWORD2);
        tsqlKeywords.add("DATEADD", Token.KEYWORD2);
        tsqlKeywords.add("DATEDIFF", Token.KEYWORD2);
        tsqlKeywords.add("DATENAME", Token.KEYWORD2);
        tsqlKeywords.add("DATEPART", Token.KEYWORD2);
        tsqlKeywords.add("DAY", Token.KEYWORD2);
        tsqlKeywords.add("DB_ID", Token.KEYWORD2);
        tsqlKeywords.add("DB_NAME", Token.KEYWORD2);
        tsqlKeywords.add("DEGREES", Token.KEYWORD2);
        tsqlKeywords.add("DIFFERENCE", Token.KEYWORD2);
        tsqlKeywords.add("EXP", Token.KEYWORD2);
        tsqlKeywords.add("FILE_ID", Token.KEYWORD2);
        tsqlKeywords.add("FILE_NAME", Token.KEYWORD2);
        tsqlKeywords.add("FILEGROUP_ID", Token.KEYWORD2);
        tsqlKeywords.add("FILEGROUP_NAME", Token.KEYWORD2);
        tsqlKeywords.add("FILEGROUPPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("FILEPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("FLOOR", Token.KEYWORD2);
        tsqlKeywords.add("FORMATMESSAGE", Token.KEYWORD2);
        tsqlKeywords.add("FULLTEXTCATALOGPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("FULLTEXTSERVICEPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("GETANSINULL", Token.KEYWORD2);
        tsqlKeywords.add("GETDATE", Token.KEYWORD2);
        tsqlKeywords.add("HOST_ID", Token.KEYWORD2);
        tsqlKeywords.add("HOST_NAME", Token.KEYWORD2);
        tsqlKeywords.add("IDENT_INCR", Token.KEYWORD2);
        tsqlKeywords.add("IDENT_SEED", Token.KEYWORD2);
        // tsqlKeywords.add("IDENTITY",Token.KEYWORD2);
        tsqlKeywords.add("IDENTITY_INSERT", Token.KEYWORD2);
        tsqlKeywords.add("INDEX_COL", Token.KEYWORD2);
        tsqlKeywords.add("INDEXPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("IS_MEMBER", Token.KEYWORD2);
        tsqlKeywords.add("IS_SRVROLEMEMBER", Token.KEYWORD2);
        tsqlKeywords.add("ISDATE", Token.KEYWORD2);
        tsqlKeywords.add("ISNULL", Token.KEYWORD2);
        tsqlKeywords.add("ISNUMERIC", Token.KEYWORD2);
        tsqlKeywords.add("LEFT", Token.KEYWORD2);
        tsqlKeywords.add("LEN", Token.KEYWORD2);
        tsqlKeywords.add("LOG", Token.KEYWORD2);
        tsqlKeywords.add("LOG10", Token.KEYWORD2);
        tsqlKeywords.add("LOWER", Token.KEYWORD2);
        tsqlKeywords.add("LTRIM", Token.KEYWORD2);
        tsqlKeywords.add("MONTH", Token.KEYWORD2);
        // tsqlKeywords.add("NCHAR",Token.KEYWORD2);
        tsqlKeywords.add("NEWID", Token.KEYWORD2);
        tsqlKeywords.add("NULLIF", Token.KEYWORD2);
        tsqlKeywords.add("OBJECT_ID", Token.KEYWORD2);
        tsqlKeywords.add("OBJECT_NAME", Token.KEYWORD2);
        tsqlKeywords.add("OBJECTPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("PARSENAME", Token.KEYWORD2);
        tsqlKeywords.add("PATINDEX", Token.KEYWORD2);
        tsqlKeywords.add("PERMISSIONS", Token.KEYWORD2);
        tsqlKeywords.add("PI", Token.KEYWORD2);
        tsqlKeywords.add("POWER", Token.KEYWORD2);
        tsqlKeywords.add("QUOTENAME", Token.KEYWORD2);
        tsqlKeywords.add("RADIANS", Token.KEYWORD2);
        tsqlKeywords.add("RAND", Token.KEYWORD2);
        tsqlKeywords.add("REPLACE", Token.KEYWORD2);
        tsqlKeywords.add("REPLICATE", Token.KEYWORD2);
        tsqlKeywords.add("REVERSE", Token.KEYWORD2);
        tsqlKeywords.add("RIGHT", Token.KEYWORD2);
        tsqlKeywords.add("ROUND", Token.KEYWORD2);
        tsqlKeywords.add("RTRIM", Token.KEYWORD2);
        tsqlKeywords.add("SESSION_USER", Token.KEYWORD2);
        tsqlKeywords.add("SIGN", Token.KEYWORD2);
        tsqlKeywords.add("SIN", Token.KEYWORD2);
        tsqlKeywords.add("SOUNDEX", Token.KEYWORD2);
        tsqlKeywords.add("SPACE", Token.KEYWORD2);
        tsqlKeywords.add("SQRT", Token.KEYWORD2);
        tsqlKeywords.add("SQUARE", Token.KEYWORD2);
        tsqlKeywords.add("STATS_DATE", Token.KEYWORD2);
        tsqlKeywords.add("STR", Token.KEYWORD2);
        tsqlKeywords.add("STUFF", Token.KEYWORD2);
        tsqlKeywords.add("SUBSTRING", Token.KEYWORD2);
        tsqlKeywords.add("SUSER_ID", Token.KEYWORD2);
        tsqlKeywords.add("SUSER_NAME", Token.KEYWORD2);
        tsqlKeywords.add("SUSER_SID", Token.KEYWORD2);
        tsqlKeywords.add("SUSER_SNAME", Token.KEYWORD2);
        tsqlKeywords.add("SYSTEM_USER", Token.KEYWORD2);
        tsqlKeywords.add("TAN", Token.KEYWORD2);
        tsqlKeywords.add("TEXTPTR", Token.KEYWORD2);
        tsqlKeywords.add("TEXTVALID", Token.KEYWORD2);
        tsqlKeywords.add("TYPEPROPERTY", Token.KEYWORD2);
        tsqlKeywords.add("UNICODE", Token.KEYWORD2);
        tsqlKeywords.add("UPPER", Token.KEYWORD2);
        tsqlKeywords.add("USER_ID", Token.KEYWORD2);
        tsqlKeywords.add("USER_NAME", Token.KEYWORD2);
        tsqlKeywords.add("USER", Token.KEYWORD2);
        tsqlKeywords.add("YEAR", Token.KEYWORD2);
    }

    private static void addOperators() {
        tsqlKeywords.add("ALL", Token.KEYWORD1);
        tsqlKeywords.add("AND", Token.KEYWORD1);
        tsqlKeywords.add("ANY", Token.KEYWORD1);
        tsqlKeywords.add("BETWEEN", Token.KEYWORD1);
        tsqlKeywords.add("CROSS", Token.KEYWORD1);
        tsqlKeywords.add("EXISTS", Token.KEYWORD1);
        tsqlKeywords.add("IN", Token.KEYWORD1);
        tsqlKeywords.add("INTERSECT", Token.KEYWORD1);
        tsqlKeywords.add("JOIN", Token.KEYWORD1);
        tsqlKeywords.add("LIKE", Token.KEYWORD1);
        tsqlKeywords.add("NOT", Token.KEYWORD1);
        tsqlKeywords.add("NULL", Token.KEYWORD1);
        tsqlKeywords.add("OR", Token.KEYWORD1);
        tsqlKeywords.add("OUTER", Token.KEYWORD1);
        tsqlKeywords.add("SOME", Token.KEYWORD1);
    }

    private static void addSystemStoredProcedures() {
        tsqlKeywords.add("sp_add_agent_parameter", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_agent_profile", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_alert", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_category", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_data_file_recover_suspect_db", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_jobschedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_jobserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_jobstep", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_log_file_recover_suspect_db", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_notification", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_operator", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_targetservergroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_add_targetsvrgrp_member", Token.KEYWORD3);
        tsqlKeywords.add("sp_addalias", Token.KEYWORD3);
        tsqlKeywords.add("sp_addapprole", Token.KEYWORD3);
        tsqlKeywords.add("sp_addarticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_adddistpublisher", Token.KEYWORD3);
        tsqlKeywords.add("sp_adddistributiondb", Token.KEYWORD3);
        tsqlKeywords.add("sp_adddistributor", Token.KEYWORD3);
        tsqlKeywords.add("sp_addextendedproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_addgroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_addlinkedserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_addlinkedsrvlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_addlinkedsrvlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_addlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergearticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergefilter", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergepublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergepullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergepullsubscription_agent", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmergesubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_addmessage", Token.KEYWORD3);
        tsqlKeywords.add("sp_addpublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_addpublication_snapshot", Token.KEYWORD3);
        tsqlKeywords.add("sp_addpublisher70", Token.KEYWORD3);
        tsqlKeywords.add("sp_addpullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_addpullsubscription_agent", Token.KEYWORD3);
        tsqlKeywords.add("sp_addremotelogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_addrole", Token.KEYWORD3);
        tsqlKeywords.add("sp_addrolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_addserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_addsrvrolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_addsubscriber", Token.KEYWORD3);
        tsqlKeywords.add("sp_addsubscriber_schedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_addsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_addsynctriggers", Token.KEYWORD3);
        tsqlKeywords.add("sp_addtabletocontents", Token.KEYWORD3);
        tsqlKeywords.add("sp_addtask", Token.KEYWORD3);
        tsqlKeywords.add("sp_addtype", Token.KEYWORD3);
        tsqlKeywords.add("sp_addumpdevice", Token.KEYWORD3);
        tsqlKeywords.add("sp_adduser", Token.KEYWORD3);
        tsqlKeywords.add("sp_altermessage", Token.KEYWORD3);
        tsqlKeywords.add("sp_apply_job_to_targets", Token.KEYWORD3);
        tsqlKeywords.add("sp_approlepassword", Token.KEYWORD3);
        tsqlKeywords.add("sp_article_validation", Token.KEYWORD3);
        tsqlKeywords.add("sp_articlecolumn", Token.KEYWORD3);
        tsqlKeywords.add("sp_articlefilter", Token.KEYWORD3);
        tsqlKeywords.add("sp_articlesynctranprocs", Token.KEYWORD3);
        tsqlKeywords.add("sp_articleview", Token.KEYWORD3);
        tsqlKeywords.add("sp_attach_db", Token.KEYWORD3);
        tsqlKeywords.add("sp_attach_single_file_db", Token.KEYWORD3);
        tsqlKeywords.add("sp_autostats", Token.KEYWORD3);
        tsqlKeywords.add("sp_bindefault", Token.KEYWORD3);
        tsqlKeywords.add("sp_bindrule", Token.KEYWORD3);
        tsqlKeywords.add("sp_bindsession", Token.KEYWORD3);
        tsqlKeywords.add("sp_browsereplcmds", Token.KEYWORD3);
        tsqlKeywords.add("sp_catalogs", Token.KEYWORD3);
        tsqlKeywords.add("sp_certify_removable", Token.KEYWORD3);
        tsqlKeywords.add("sp_change_agent_parameter", Token.KEYWORD3);
        tsqlKeywords.add("sp_change_agent_profile", Token.KEYWORD3);
        tsqlKeywords.add("sp_change_subscription_properties", Token.KEYWORD3);
        tsqlKeywords.add("sp_change_users_login", Token.KEYWORD3);
        tsqlKeywords.add("sp_changearticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_changedbowner", Token.KEYWORD3);
        tsqlKeywords.add("sp_changedistpublisher", Token.KEYWORD3);
        tsqlKeywords.add("sp_changedistributiondb", Token.KEYWORD3);
        tsqlKeywords.add("sp_changedistributor_password", Token.KEYWORD3);
        tsqlKeywords.add("sp_changedistributor_property", Token.KEYWORD3);
        tsqlKeywords.add("sp_changegroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_changemergearticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_changemergefilter", Token.KEYWORD3);
        tsqlKeywords.add("sp_changemergepublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_changemergepullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_changemergesubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_changeobjectowner", Token.KEYWORD3);
        tsqlKeywords.add("sp_changepublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_changesubscriber", Token.KEYWORD3);
        tsqlKeywords.add("sp_changesubscriber_schedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_changesubstatus", Token.KEYWORD3);
        tsqlKeywords.add("sp_check_for_sync_trigger", Token.KEYWORD3);
        tsqlKeywords.add("sp_column_privileges", Token.KEYWORD3);
        tsqlKeywords.add("sp_column_privileges_ex", Token.KEYWORD3);
        tsqlKeywords.add("sp_columns", Token.KEYWORD3);
        tsqlKeywords.add("sp_columns_ex", Token.KEYWORD3);
        tsqlKeywords.add("sp_configure", Token.KEYWORD3);
        tsqlKeywords.add("sp_create_removable", Token.KEYWORD3);
        tsqlKeywords.add("sp_createorphan", Token.KEYWORD3);
        tsqlKeywords.add("sp_createstats", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursor", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursor_list", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursorclose", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursorexecute", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursorfetch", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursoropen", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursoroption", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursorprepare", Token.KEYWORD3);
        tsqlKeywords.add("sp_cursorunprepare", Token.KEYWORD3);
        tsqlKeywords.add("sp_cycle_errorlog", Token.KEYWORD3);
        tsqlKeywords.add("sp_databases", Token.KEYWORD3);
        tsqlKeywords.add("sp_datatype_info", Token.KEYWORD3);
        tsqlKeywords.add("sp_dbcmptlevel", Token.KEYWORD3);
        tsqlKeywords.add("sp_dbfixedrolepermission", Token.KEYWORD3);
        tsqlKeywords.add("sp_dboption", Token.KEYWORD3);
        tsqlKeywords.add("sp_defaultdb", Token.KEYWORD3);
        tsqlKeywords.add("sp_defaultlanguage", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_alert", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_backuphistory", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_category", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_jobschedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_jobserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_jobstep", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_notification", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_operator", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_targetserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_targetservergroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_delete_targetsvrgrp_member", Token.KEYWORD3);
        tsqlKeywords.add("sp_deletemergeconflictrow", Token.KEYWORD3);
        tsqlKeywords.add("sp_denylogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_depends", Token.KEYWORD3);
        tsqlKeywords.add("sp_describe_cursor", Token.KEYWORD3);
        tsqlKeywords.add("sp_describe_cursor_columns", Token.KEYWORD3);
        tsqlKeywords.add("sp_describe_cursor_tables", Token.KEYWORD3);
        tsqlKeywords.add("sp_detach_db", Token.KEYWORD3);
        tsqlKeywords.add("sp_drop_agent_parameter", Token.KEYWORD3);
        tsqlKeywords.add("sp_drop_agent_profile", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropalias", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropapprole", Token.KEYWORD3);
        tsqlKeywords.add("sp_droparticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropdevice", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropdistpublisher", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropdistributiondb", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropdistributor", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropextendedproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropgroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_droplinkedsrvlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_droplinkedsrvlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_droplogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmergearticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmergefilter", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmergepublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmergepullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmergesubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropmessage", Token.KEYWORD3);
        tsqlKeywords.add("sp_droporphans", Token.KEYWORD3);
        tsqlKeywords.add("sp_droppublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_droppullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropremotelogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_droprole", Token.KEYWORD3);
        tsqlKeywords.add("sp_droprolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropsrvrolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropsubscriber", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_droptask", Token.KEYWORD3);
        tsqlKeywords.add("sp_droptype", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropuser", Token.KEYWORD3);
        tsqlKeywords.add("sp_dropwebtask", Token.KEYWORD3);
        tsqlKeywords.add("sp_dsninfo", Token.KEYWORD3);
        tsqlKeywords.add("sp_dumpparamcmd", Token.KEYWORD3);
        tsqlKeywords.add("sp_enumcodepages", Token.KEYWORD3);
        tsqlKeywords.add("sp_enumcustomresolvers", Token.KEYWORD3);
        tsqlKeywords.add("sp_enumdsn", Token.KEYWORD3);
        tsqlKeywords.add("sp_enumfullsubscribers", Token.KEYWORD3);
        tsqlKeywords.add("sp_execute", Token.KEYWORD3);
        tsqlKeywords.add("sp_executesql", Token.KEYWORD3);
        tsqlKeywords.add("sp_expired_subscription_cleanup", Token.KEYWORD3);
        tsqlKeywords.add("sp_fkeys", Token.KEYWORD3);
        tsqlKeywords.add("sp_foreignkeys", Token.KEYWORD3);
        tsqlKeywords.add("sp_fulltext_catalog", Token.KEYWORD3);
        tsqlKeywords.add("sp_fulltext_column", Token.KEYWORD3);
        tsqlKeywords.add("sp_fulltext_database", Token.KEYWORD3);
        tsqlKeywords.add("sp_fulltext_service", Token.KEYWORD3);
        tsqlKeywords.add("sp_fulltext_table", Token.KEYWORD3);
        tsqlKeywords.add("sp_generatefilters", Token.KEYWORD3);
        tsqlKeywords.add("sp_get_distributor", Token.KEYWORD3);
        tsqlKeywords.add("sp_getbindtoken", Token.KEYWORD3);
        tsqlKeywords.add("sp_getmergedeletetype", Token.KEYWORD3);
        tsqlKeywords.add("sp_grant_publication_access", Token.KEYWORD3);
        tsqlKeywords.add("sp_grantdbaccess", Token.KEYWORD3);
        tsqlKeywords.add("sp_grantlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_help", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_agent_default", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_agent_parameter", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_agent_profile", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_alert", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_category", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_downloadlist", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_catalogs", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_catalogs_cursor", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_columns", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_columns_cursor", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_tables", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_fulltext_tables_cursor", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_jobhistory", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_jobschedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_jobserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_jobstep", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_notification", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_operator", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_publication_access", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_targetserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_help_targetservergroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_helparticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_helparticlecolumns", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpconstraint", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdb", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdbfixedrole", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdevice", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdistpublisher", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdistributiondb", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpdistributor", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpextendedproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpfile", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpfilegroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpgroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_helphistory", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpindex", Token.KEYWORD3);
        tsqlKeywords.add("sp_helplanguage", Token.KEYWORD3);
        tsqlKeywords.add("sp_helplinkedsrvlogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_helplogins", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergearticle", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergearticleconflicts", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergeconflictrows", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergedeleteconflictrows", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergefilter", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergepublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergepullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpmergesubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpntgroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_helppublication", Token.KEYWORD3);
        tsqlKeywords.add("sp_helppullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpremotelogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpreplicationdboption", Token.KEYWORD3);
        tsqlKeywords.add("sp_helprole", Token.KEYWORD3);
        tsqlKeywords.add("sp_helprolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_helprotect", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsort", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsrvrole", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsrvrolemember", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsubscriberinfo", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpsubscription_properties", Token.KEYWORD3);
        tsqlKeywords.add("sp_helptask", Token.KEYWORD3);
        tsqlKeywords.add("sp_helptext", Token.KEYWORD3);
        tsqlKeywords.add("sp_helptrigger", Token.KEYWORD3);
        tsqlKeywords.add("sp_helpuser", Token.KEYWORD3);
        tsqlKeywords.add("sp_indexes", Token.KEYWORD3);
        tsqlKeywords.add("sp_indexoption", Token.KEYWORD3);
        tsqlKeywords.add("sp_link_publication", Token.KEYWORD3);
        tsqlKeywords.add("sp_linkedservers", Token.KEYWORD3);
        tsqlKeywords.add("sp_lock", Token.KEYWORD3);
        tsqlKeywords.add("sp_makewebtask", Token.KEYWORD3);
        tsqlKeywords.add("sp_manage_jobs_by_login", Token.KEYWORD3);
        tsqlKeywords.add("sp_mergedummyupdate", Token.KEYWORD3);
        tsqlKeywords.add("sp_mergesubscription_cleanup", Token.KEYWORD3);
        tsqlKeywords.add("sp_monitor", Token.KEYWORD3);
        tsqlKeywords.add("sp_msx_defect", Token.KEYWORD3);
        tsqlKeywords.add("sp_msx_enlist", Token.KEYWORD3);
        tsqlKeywords.add("sp_OACreate", Token.KEYWORD3);
        tsqlKeywords.add("sp_OADestroy", Token.KEYWORD3);
        tsqlKeywords.add("sp_OAGetErrorInfo", Token.KEYWORD3);
        tsqlKeywords.add("sp_OAGetProperty", Token.KEYWORD3);
        tsqlKeywords.add("sp_OAMethod", Token.KEYWORD3);
        tsqlKeywords.add("sp_OASetProperty", Token.KEYWORD3);
        tsqlKeywords.add("sp_OAStop", Token.KEYWORD3);
        tsqlKeywords.add("sp_password", Token.KEYWORD3);
        tsqlKeywords.add("sp_pkeys", Token.KEYWORD3);
        tsqlKeywords.add("sp_post_msx_operation", Token.KEYWORD3);
        tsqlKeywords.add("sp_prepare", Token.KEYWORD3);
        tsqlKeywords.add("sp_primarykeys", Token.KEYWORD3);
        tsqlKeywords.add("sp_processmail", Token.KEYWORD3);
        tsqlKeywords.add("sp_procoption", Token.KEYWORD3);
        tsqlKeywords.add("sp_publication_validation", Token.KEYWORD3);
        tsqlKeywords.add("sp_purge_jobhistory", Token.KEYWORD3);
        tsqlKeywords.add("sp_purgehistory", Token.KEYWORD3);
        tsqlKeywords.add("sp_reassigntask", Token.KEYWORD3);
        tsqlKeywords.add("sp_recompile", Token.KEYWORD3);
        tsqlKeywords.add("sp_refreshsubscriptions", Token.KEYWORD3);
        tsqlKeywords.add("sp_refreshview", Token.KEYWORD3);
        tsqlKeywords.add("sp_reinitmergepullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_reinitmergesubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_reinitpullsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_reinitsubscription", Token.KEYWORD3);
        tsqlKeywords.add("sp_remoteoption", Token.KEYWORD3);
        tsqlKeywords.add("sp_remove_job_from_targets", Token.KEYWORD3);
        tsqlKeywords.add("sp_removedbreplication", Token.KEYWORD3);
        tsqlKeywords.add("sp_rename", Token.KEYWORD3);
        tsqlKeywords.add("sp_renamedb", Token.KEYWORD3);
        tsqlKeywords.add("sp_replcmds", Token.KEYWORD3);
        tsqlKeywords.add("sp_replcounters", Token.KEYWORD3);
        tsqlKeywords.add("sp_repldone", Token.KEYWORD3);
        tsqlKeywords.add("sp_replflush", Token.KEYWORD3);
        tsqlKeywords.add("sp_replication_agent_checkup", Token.KEYWORD3);
        tsqlKeywords.add("sp_replicationdboption", Token.KEYWORD3);
        tsqlKeywords.add("sp_replsetoriginator", Token.KEYWORD3);
        tsqlKeywords.add("sp_replshowcmds", Token.KEYWORD3);
        tsqlKeywords.add("sp_repltrans", Token.KEYWORD3);
        tsqlKeywords.add("sp_reset_connection", Token.KEYWORD3);
        tsqlKeywords.add("sp_resync_targetserver", Token.KEYWORD3);
        tsqlKeywords.add("sp_revoke_publication_access", Token.KEYWORD3);
        tsqlKeywords.add("sp_revokedbaccess", Token.KEYWORD3);
        tsqlKeywords.add("sp_revokelogin", Token.KEYWORD3);
        tsqlKeywords.add("sp_runwebtask", Token.KEYWORD3);
        tsqlKeywords.add("sp_script_synctran_commands", Token.KEYWORD3);
        tsqlKeywords.add("sp_scriptdelproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_scriptinsproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_scriptmappedupdproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_scriptupdproc", Token.KEYWORD3);
        tsqlKeywords.add("sp_sdidebug", Token.KEYWORD3);
        tsqlKeywords.add("sp_server_info", Token.KEYWORD3);
        tsqlKeywords.add("sp_serveroption", Token.KEYWORD3);
        tsqlKeywords.add("sp_serveroption", Token.KEYWORD3);
        tsqlKeywords.add("sp_setapprole", Token.KEYWORD3);
        tsqlKeywords.add("sp_setnetname", Token.KEYWORD3);
        tsqlKeywords.add("sp_spaceused", Token.KEYWORD3);
        tsqlKeywords.add("sp_special_columns", Token.KEYWORD3);
        tsqlKeywords.add("sp_sproc_columns", Token.KEYWORD3);
        tsqlKeywords.add("sp_srvrolepermission", Token.KEYWORD3);
        tsqlKeywords.add("sp_start_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_statistics", Token.KEYWORD3);
        tsqlKeywords.add("sp_stop_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_stored_procedures", Token.KEYWORD3);
        tsqlKeywords.add("sp_subscription_cleanup", Token.KEYWORD3);
        tsqlKeywords.add("sp_table_privileges", Token.KEYWORD3);
        tsqlKeywords.add("sp_table_privileges_ex", Token.KEYWORD3);
        tsqlKeywords.add("sp_table_validation", Token.KEYWORD3);
        tsqlKeywords.add("sp_tableoption", Token.KEYWORD3);
        tsqlKeywords.add("sp_tables", Token.KEYWORD3);
        tsqlKeywords.add("sp_tables_ex", Token.KEYWORD3);
        tsqlKeywords.add("sp_unbindefault", Token.KEYWORD3);
        tsqlKeywords.add("sp_unbindrule", Token.KEYWORD3);
        tsqlKeywords.add("sp_unprepare", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_agent_profile", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_alert", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_category", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_job", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_jobschedule", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_jobstep", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_notification", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_operator", Token.KEYWORD3);
        tsqlKeywords.add("sp_update_targetservergroup", Token.KEYWORD3);
        tsqlKeywords.add("sp_updatestats", Token.KEYWORD3);
        tsqlKeywords.add("sp_updatetask", Token.KEYWORD3);
        tsqlKeywords.add("sp_validatelogins", Token.KEYWORD3);
        tsqlKeywords.add("sp_validname", Token.KEYWORD3);
        tsqlKeywords.add("sp_who", Token.KEYWORD3);
        tsqlKeywords.add("xp_cmdshell", Token.KEYWORD3);
        tsqlKeywords.add("xp_deletemail", Token.KEYWORD3);
        tsqlKeywords.add("xp_enumgroups", Token.KEYWORD3);
        tsqlKeywords.add("xp_findnextmsg", Token.KEYWORD3);
        tsqlKeywords.add("xp_findnextmsg", Token.KEYWORD3);
        tsqlKeywords.add("xp_grantlogin", Token.KEYWORD3);
        tsqlKeywords.add("xp_logevent", Token.KEYWORD3);
        tsqlKeywords.add("xp_loginconfig", Token.KEYWORD3);
        tsqlKeywords.add("xp_logininfo", Token.KEYWORD3);
        tsqlKeywords.add("xp_msver", Token.KEYWORD3);
        tsqlKeywords.add("xp_readmail", Token.KEYWORD3);
        tsqlKeywords.add("xp_revokelogin", Token.KEYWORD3);
        tsqlKeywords.add("xp_sendmail", Token.KEYWORD3);
        tsqlKeywords.add("xp_sprintf", Token.KEYWORD3);
        tsqlKeywords.add("xp_sqlinventory", Token.KEYWORD3);
        tsqlKeywords.add("xp_sqlmaint", Token.KEYWORD3);
        tsqlKeywords.add("xp_sqltrace", Token.KEYWORD3);
        tsqlKeywords.add("xp_sscanf", Token.KEYWORD3);
        tsqlKeywords.add("xp_startmail", Token.KEYWORD3);
        tsqlKeywords.add("xp_stopmail", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_addnewqueue", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_deletequeuedefinition", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_destroyqueue", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_enumqueuedefname", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_enumqueuehandles", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_eventclassrequired", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_flushqueryhistory", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_generate_event", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getappfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getconnectionidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getcpufilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getdbidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getdurationfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_geteventfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_geteventnames", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getevents", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_gethostfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_gethpidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getindidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getntdmfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getntnmfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getobjidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getqueueautostart", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getqueuedestination", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getqueueproperties", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getreadfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getserverfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getseverityfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getspidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getsysobjectsfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_gettextfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getuserfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_getwritefilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_loadqueuedefinition", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_pausequeue", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_restartqueue", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_savequeuedefinition", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setappfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setconnectionidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setcpufilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setdbidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setdurationfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_seteventclassrequired", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_seteventfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_sethostfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_sethpidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setindidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setntdmfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setntnmfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setobjidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setqueryhistory", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setqueueautostart", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setqueuecreateinfo", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setqueuedestination", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setreadfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setserverfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setseverityfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setspidfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setsysobjectsfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_settextfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setuserfilter", Token.KEYWORD3);
        tsqlKeywords.add("xp_trace_setwritefilter", Token.KEYWORD3);
    }

    private static void addSystemTables() {
        tsqlKeywords.add("backupfile", Token.KEYWORD3);
        tsqlKeywords.add("backupmediafamily", Token.KEYWORD3);
        tsqlKeywords.add("backupmediaset", Token.KEYWORD3);
        tsqlKeywords.add("backupset", Token.KEYWORD3);
        tsqlKeywords.add("MSagent_parameters", Token.KEYWORD3);
        tsqlKeywords.add("MSagent_profiles", Token.KEYWORD3);
        tsqlKeywords.add("MSarticles", Token.KEYWORD3);
        tsqlKeywords.add("MSdistpublishers", Token.KEYWORD3);
        tsqlKeywords.add("MSdistribution_agents", Token.KEYWORD3);
        tsqlKeywords.add("MSdistribution_history", Token.KEYWORD3);
        tsqlKeywords.add("MSdistributiondbs", Token.KEYWORD3);
        tsqlKeywords.add("MSdistributor", Token.KEYWORD3);
        tsqlKeywords.add("MSlogreader_agents", Token.KEYWORD3);
        tsqlKeywords.add("MSlogreader_history", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_agents", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_contents", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_delete_conflicts", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_genhistory", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_history", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_replinfo", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_subscriptions", Token.KEYWORD3);
        tsqlKeywords.add("MSmerge_tombstone", Token.KEYWORD3);
        tsqlKeywords.add("MSpublication_access", Token.KEYWORD3);
        tsqlKeywords.add("Mspublications", Token.KEYWORD3);
        tsqlKeywords.add("Mspublisher_databases", Token.KEYWORD3);
        tsqlKeywords.add("MSrepl_commands", Token.KEYWORD3);
        tsqlKeywords.add("MSrepl_errors", Token.KEYWORD3);
        tsqlKeywords.add("Msrepl_originators", Token.KEYWORD3);
        tsqlKeywords.add("MSrepl_transactions", Token.KEYWORD3);
        tsqlKeywords.add("MSrepl_version", Token.KEYWORD3);
        tsqlKeywords.add("MSreplication_objects", Token.KEYWORD3);
        tsqlKeywords.add("MSreplication_subscriptions", Token.KEYWORD3);
        tsqlKeywords.add("MSsnapshot_agents", Token.KEYWORD3);
        tsqlKeywords.add("MSsnapshot_history", Token.KEYWORD3);
        tsqlKeywords.add("MSsubscriber_info", Token.KEYWORD3);
        tsqlKeywords.add("MSsubscriber_schedule", Token.KEYWORD3);
        tsqlKeywords.add("MSsubscription_properties", Token.KEYWORD3);
        tsqlKeywords.add("MSsubscriptions", Token.KEYWORD3);
        tsqlKeywords.add("restorefile", Token.KEYWORD3);
        tsqlKeywords.add("restorefilegroup", Token.KEYWORD3);
        tsqlKeywords.add("restorehistory", Token.KEYWORD3);
        tsqlKeywords.add("sysalerts", Token.KEYWORD3);
        tsqlKeywords.add("sysallocations", Token.KEYWORD3);
        tsqlKeywords.add("sysaltfiles", Token.KEYWORD3);
        tsqlKeywords.add("sysarticles", Token.KEYWORD3);
        tsqlKeywords.add("sysarticleupdates", Token.KEYWORD3);
        tsqlKeywords.add("syscacheobjects", Token.KEYWORD3);
        tsqlKeywords.add("syscategories", Token.KEYWORD3);
        tsqlKeywords.add("syscharsets", Token.KEYWORD3);
        tsqlKeywords.add("syscolumns", Token.KEYWORD3);
        tsqlKeywords.add("syscomments", Token.KEYWORD3);
        tsqlKeywords.add("sysconfigures", Token.KEYWORD3);
        tsqlKeywords.add("sysconstraints", Token.KEYWORD3);
        tsqlKeywords.add("syscurconfigs", Token.KEYWORD3);
        tsqlKeywords.add("sysdatabases", Token.KEYWORD3);
        tsqlKeywords.add("sysdatabases", Token.KEYWORD3);
        tsqlKeywords.add("sysdepends", Token.KEYWORD3);
        tsqlKeywords.add("sysdevices", Token.KEYWORD3);
        tsqlKeywords.add("sysdownloadlist", Token.KEYWORD3);
        tsqlKeywords.add("sysfilegroups", Token.KEYWORD3);
        tsqlKeywords.add("sysfiles", Token.KEYWORD3);
        tsqlKeywords.add("sysforeignkeys", Token.KEYWORD3);
        tsqlKeywords.add("sysfulltextcatalogs", Token.KEYWORD3);
        tsqlKeywords.add("sysindexes", Token.KEYWORD3);
        tsqlKeywords.add("sysindexkeys", Token.KEYWORD3);
        tsqlKeywords.add("sysjobhistory", Token.KEYWORD3);
        tsqlKeywords.add("sysjobs", Token.KEYWORD3);
        tsqlKeywords.add("sysjobschedules", Token.KEYWORD3);
        tsqlKeywords.add("sysjobservers", Token.KEYWORD3);
        tsqlKeywords.add("sysjobsteps", Token.KEYWORD3);
        tsqlKeywords.add("syslanguages", Token.KEYWORD3);
        tsqlKeywords.add("syslockinfo", Token.KEYWORD3);
        tsqlKeywords.add("syslogins", Token.KEYWORD3);
        tsqlKeywords.add("sysmembers", Token.KEYWORD3);
        tsqlKeywords.add("sysmergearticles", Token.KEYWORD3);
        tsqlKeywords.add("sysmergepublications", Token.KEYWORD3);
        tsqlKeywords.add("sysmergeschemachange", Token.KEYWORD3);
        tsqlKeywords.add("sysmergesubscriptions", Token.KEYWORD3);
        tsqlKeywords.add("sysmergesubsetfilters", Token.KEYWORD3);
        tsqlKeywords.add("sysmessages", Token.KEYWORD3);
        tsqlKeywords.add("sysnotifications", Token.KEYWORD3);
        tsqlKeywords.add("sysobjects", Token.KEYWORD3);
        tsqlKeywords.add("sysobjects", Token.KEYWORD3);
        tsqlKeywords.add("sysoledbusers", Token.KEYWORD3);
        tsqlKeywords.add("sysoperators", Token.KEYWORD3);
        tsqlKeywords.add("sysperfinfo", Token.KEYWORD3);
        tsqlKeywords.add("syspermissions", Token.KEYWORD3);
        tsqlKeywords.add("sysprocesses", Token.KEYWORD3);
        tsqlKeywords.add("sysprotects", Token.KEYWORD3);
        tsqlKeywords.add("syspublications", Token.KEYWORD3);
        tsqlKeywords.add("sysreferences", Token.KEYWORD3);
        tsqlKeywords.add("sysremotelogins", Token.KEYWORD3);
        tsqlKeywords.add("sysreplicationalerts", Token.KEYWORD3);
        tsqlKeywords.add("sysservers", Token.KEYWORD3);
        tsqlKeywords.add("sysservers", Token.KEYWORD3);
        tsqlKeywords.add("syssubscriptions", Token.KEYWORD3);
        tsqlKeywords.add("systargetservergroupmembers", Token.KEYWORD3);
        tsqlKeywords.add("systargetservergroups", Token.KEYWORD3);
        tsqlKeywords.add("systargetservers", Token.KEYWORD3);
        tsqlKeywords.add("systaskids", Token.KEYWORD3);
        tsqlKeywords.add("systypes", Token.KEYWORD3);
        tsqlKeywords.add("sysusers", Token.KEYWORD3);
    }

    private static KeywordMap tsqlKeywords;
}
