/* 
 * Copyright 2003,2004 Colin Crist
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package hermes.ext.sap;

import hermes.Hermes;
import hermes.HermesAdmin;
import hermes.HermesAdminFactory;
import hermes.HermesException;
import hermes.JNDIConnectionFactory;

import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.NamingException;

/**
 * @author michael.koegel@sap.com last changed by: $Author: $
 * @version $Id: $
 */
public class SAPJMSAdminFactory implements HermesAdminFactory {
    
    private String virtualProvider = "default";

    public HermesAdmin createSession(Hermes hermes, ConnectionFactory connectionFactory) throws JMSException,
            NamingException {
        if (connectionFactory instanceof JNDIConnectionFactory) {
            return new SAPJMSAdmin(hermes, this, (JNDIConnectionFactory)connectionFactory);
        }
        throw new HermesException("Incompatible ConnectionFactory");
    }

    public String getVirtualProvider() {
        return virtualProvider;
    }

    public void setVirtualProvider(String virtualProvider) {
        this.virtualProvider = virtualProvider;
    }

}