/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.form.support;

import com.eviware.x.form.XFormOptionsField;
import com.eviware.x.impl.swing.AbstractSwingXFormField;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class XFormRadioGroup
extends AbstractSwingXFormField<JPanel>
implements XFormOptionsField {
    protected ButtonGroup buttonGroup;
    protected Map<String, ButtonModel> models = new HashMap<String, ButtonModel>();
    protected List<Object> items = new ArrayList<Object>();

    public XFormRadioGroup(String[] values) {
        super(new JPanel());
        this.buttonGroup = new ButtonGroup();
        ((JPanel)this.getComponent()).setLayout(new BoxLayout((Container)this.getComponent(), 1));
        for (String value : values) {
            this.addItem(value);
        }
    }

    @Override
    public String getValue() {
        ButtonModel selection = this.buttonGroup.getSelection();
        return selection == null ? null : selection.getActionCommand();
    }

    @Override
    public void setValue(String value) {
        this.buttonGroup.setSelected(this.models.get(value), true);
    }

    @Override
    public void addItem(Object value) {
        JRadioButton button;
        if (value instanceof Enum) {
            button = new JRadioButton(value.toString());
            button.setActionCommand(((Enum)value).name());
            this.models.put(((Enum)value).name(), button.getModel());
        } else {
            button = new JRadioButton(String.valueOf(value));
            button.setActionCommand(String.valueOf(value));
            this.models.put(String.valueOf(value), button.getModel());
        }
        button.setName(String.valueOf(value));
        button.setFocusPainted(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XFormRadioGroup.this.fireValueChanged(e.getActionCommand(), null);
            }
        });
        ((JPanel)this.getComponent()).add(button);
        this.buttonGroup.add(button);
        this.items.add(value);
    }

    @Override
    public Object[] getOptions() {
        return this.items.toArray();
    }

    @Override
    public Object[] getSelectedOptions() {
        return new String[]{this.getValue()};
    }

    @Override
    public void setOptions(Object[] values) {
        while (this.buttonGroup.getButtonCount() > 0) {
            this.buttonGroup.remove(this.buttonGroup.getElements().nextElement());
        }
        this.models.clear();
        this.items.clear();
        ((JPanel)this.getComponent()).removeAll();
        for (Object value : values) {
            this.addItem(value);
        }
    }

    @Override
    public void setSelectedOptions(Object[] options) {
    }

    @Override
    public int[] getSelectedIndexes() {
        return new int[]{this.items.indexOf(this.getValue())};
    }

    public void setDisabled() {
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            buttons.nextElement().setEnabled(false);
        }
    }
}

