/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.RegistryEntryConfig;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.registry.RegistryEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRegistry<T1 extends RegistryEntry<T2, T3>, T2 extends RegistryEntryConfig, T3> {
    private Map<String, Class<? extends T1>> registry = new HashMap<String, Class<? extends T1>>();

    public void mapType(String type, Class<? extends T1> clazz) {
        this.registry.put(type, clazz);
    }

    public T1 create(String type, T3 parent) {
        if (this.registry.containsKey(type)) {
            T2 config = this.addNewConfig(parent);
            config.setType(type);
            return this.build(config, parent);
        }
        throw new RuntimeException("Invalid type [" + type + "]");
    }

    protected abstract T2 addNewConfig(T3 var1);

    public T1 build(T2 config, T3 parent) {
        try {
            Class<T1> clazz = this.registry.get(config.getType());
            if (clazz == null) {
                return null;
            }
            RegistryEntry entry = (RegistryEntry)clazz.newInstance();
            entry.init(config, parent);
            return (T1)entry;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public String[] getTypes() {
        return StringUtils.sortNames(this.registry.keySet().toArray(new String[this.registry.size()]));
    }

    public String[] getTypesWithInterface(Class<?> clazz) {
        ArrayList<String> result = new ArrayList<String>();
        for (String type : this.registry.keySet()) {
            if (!Arrays.asList(this.registry.get(type).getInterfaces()).contains(clazz)) continue;
            result.add(type);
        }
        return result.toArray(new String[result.size()]);
    }
}

