/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.propertyexpansion;

import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.propertyexpansion.AbstractPropertyExpansionTarget;
import java.awt.Point;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class GroovyEditorPropertyExpansionTarget
extends AbstractPropertyExpansionTarget {
    private final RSyntaxTextArea textField;

    public GroovyEditorPropertyExpansionTarget(GroovyEditor textField, ModelItem modelItem) {
        super(modelItem);
        this.textField = textField.getEditArea();
    }

    @Override
    public void insertPropertyExpansion(PropertyExpansion expansion, Point pt) {
        int pos;
        int n = pos = pt == null ? -1 : this.textField.viewToModel(pt);
        if (pos == -1) {
            pos = this.textField.getCaretPosition();
        }
        String name = expansion.getProperty().getName();
        String javaName = this.createJavaName(name);
        if ((javaName = UISupport.prompt("Specify name of variable for property", "Get Property", javaName)) == null) {
            return;
        }
        String txt = this.createContextExpansion(javaName, expansion);
        try {
            int line = this.textField.getLineOfOffset(pos);
            pos = this.textField.getLineStartOffset(line);
            this.textField.setCaretPosition(pos);
            this.textField.insert(txt, pos);
            this.textField.setSelectionStart(pos);
            this.textField.setSelectionEnd(pos + txt.length());
            this.textField.requestFocusInWindow();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String createJavaName(String name) {
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < name.length(); ++c) {
            char ch;
            char c2 = ch = c == 0 ? name.toLowerCase().charAt(c) : name.charAt(c);
            if (buf.length() == 0 && Character.isJavaIdentifierStart(ch)) {
                buf.append(ch);
                continue;
            }
            if (buf.length() <= 0 || !Character.isJavaIdentifierPart(ch)) continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    @Override
    public String getValueForCreation() {
        return this.textField.getSelectedText();
    }

    @Override
    public String getNameForCreation() {
        return null;
    }
}

