/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.wss;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.editor.EditorView;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.xml.XmlDocument;
import com.eviware.soapui.support.editor.xml.XmlLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractWssInspector
extends AbstractXmlInspector {
    private JPanel mainPanel;
    private JList resultList;

    protected AbstractWssInspector() {
        super("WSS", "Displays WS-Security information for this response", true, "WSS");
    }

    @Override
    public void release() {
        super.release();
    }

    public void locationChanged(XmlLocation location) {
    }

    @Override
    public JComponent getComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add(this.buildContent(), "Center");
            UISupport.addTitledBorder(this.mainPanel, "WS-Security processing results");
            this.update();
        }
        return this.mainPanel;
    }

    private Component buildContent() {
        this.resultList = new JList(new ResultVectorListModel(this.getWssResults()));
        return new JScrollPane(this.resultList);
    }

    public abstract Vector<?> getWssResults();

    public void update() {
        this.resultList.setModel(new ResultVectorListModel(this.getWssResults()));
        int size = this.resultList.getModel().getSize();
        this.setTitle("WSS (" + size + ")");
        this.setEnabled(size > 0);
    }

    @Override
    public boolean isEnabledFor(EditorView<XmlDocument> view) {
        return true;
    }

    private static class ResultVectorListModel
    extends AbstractListModel {
        private final Vector<?> result;

        public ResultVectorListModel(Vector<?> result) {
            this.result = result;
        }

        @Override
        public Object getElementAt(int index) {
            return this.result == null ? null : this.result.get(index);
        }

        @Override
        public int getSize() {
            return this.result == null ? 0 : this.result.size();
        }
    }
}

