/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.property;

import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.support.editor.inspectors.jms.property.JMSPropertyInspector;
import com.eviware.soapui.support.types.StringToStringMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.commons.lang.NotImplementedException;

public interface JMSPropertyInspectorModel {
    public StringToStringMap getJMSProperties();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public void setJMSProperties(StringToStringMap var1);

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public boolean isReadOnly();

    public void release();

    public void setInspector(JMSPropertyInspector var1);

    public static abstract class AbstractJMSPropertyModel<T extends ModelItem>
    implements JMSPropertyInspectorModel,
    PropertyChangeListener {
        private boolean readOnly;
        private PropertyChangeSupport propertyChangeSupport;
        private final T modelItem;
        private final String propertyName;

        protected AbstractJMSPropertyModel(boolean readOnly, T modelItem, String propertyName) {
            this.readOnly = readOnly;
            this.modelItem = modelItem;
            this.propertyName = propertyName;
            this.propertyChangeSupport = new PropertyChangeSupport(this);
            modelItem.addPropertyChangeListener(propertyName, this);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.propertyChangeSupport.firePropertyChange(evt);
        }

        @Override
        public void release() {
            this.modelItem.removePropertyChangeListener(this.propertyName, this);
        }

        public T getModelItem() {
            return this.modelItem;
        }

        @Override
        public void setJMSProperties(StringToStringMap jmsPorperties) {
            if (!this.readOnly) {
                throw new NotImplementedException();
            }
        }
    }
}

