/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.httpheaders;

import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.jms.util.JMSUtils;
import com.eviware.soapui.impl.wsdl.support.MessageExchangeModelItem;
import com.eviware.soapui.impl.wsdl.teststeps.AMFRequestTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.AMFTestStepResult;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.support.editor.Editor;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.httpheaders.HttpHeadersInspector;
import com.eviware.soapui.support.editor.inspectors.httpheaders.HttpHeadersInspectorModel;
import com.eviware.soapui.support.editor.registry.RequestInspectorFactory;
import com.eviware.soapui.support.editor.registry.ResponseInspectorFactory;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;

public class HttpHeadersInspectorFactory
implements RequestInspectorFactory,
ResponseInspectorFactory {
    public static final String INSPECTOR_ID = "HTTP Headers";

    @Override
    public String getInspectorId() {
        return INSPECTOR_ID;
    }

    @Override
    public EditorInspector<?> createRequestInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequestInterface) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new WsdlRequestHeadersModel((AbstractHttpRequest)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof WsdlMockResponse) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new WsdlMockResponseRequestHeadersModel((WsdlMockResponse)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            if (((MessageExchangeModelItem)modelItem).getMessageExchange() instanceof AMFTestStepResult) {
                HttpHeadersInspector inspector = new HttpHeadersInspector(new AMFMessageExchangeRequestHTTPHeadersModel((MessageExchangeModelItem)modelItem));
                inspector.setEnabled(true);
                return inspector;
            }
            HttpHeadersInspector inspector = new HttpHeadersInspector(new WsdlMessageExchangeRequestHeadersModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof AMFRequestTestStep) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new AMFRequestHeadersModel((AMFRequestTestStep)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        return null;
    }

    @Override
    public EditorInspector<?> createResponseInspector(Editor<?> editor, ModelItem modelItem) {
        if (modelItem instanceof AbstractHttpRequestInterface) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new WsdlRequestResponseHeadersModel((AbstractHttpRequest)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof WsdlMockResponse) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new MockResponseHeadersModel((WsdlMockResponse)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof MessageExchangeModelItem) {
            if (((MessageExchangeModelItem)modelItem).getMessageExchange() instanceof AMFTestStepResult) {
                HttpHeadersInspector inspector = new HttpHeadersInspector(new AMFMessageExchangeResponseHTTPHeadersModel((MessageExchangeModelItem)modelItem));
                inspector.setEnabled(true);
                return inspector;
            }
            HttpHeadersInspector inspector = new HttpHeadersInspector(new WsdlMessageExchangeResponseHeadersModel((MessageExchangeModelItem)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        if (modelItem instanceof AMFRequestTestStep) {
            HttpHeadersInspector inspector = new HttpHeadersInspector(new AMFResponseHeadersModel((AMFRequestTestStep)modelItem));
            inspector.setEnabled(!JMSUtils.checkIfJMS(modelItem));
            return inspector;
        }
        return null;
    }

    private class WsdlMockResponseRequestHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<WsdlMockResponse> {
        public WsdlMockResponseRequestHeadersModel(WsdlMockResponse request) {
            super(true, request, WsdlMockResponse.MOCKRESULT_PROPERTY);
        }

        @Override
        public StringToStringsMap getHeaders() {
            WsdlMockResponse request = (WsdlMockResponse)this.getModelItem();
            return request.getMockResult() == null ? new StringToStringsMap() : request.getMockResult().getMockRequest().getRequestHeaders();
        }
    }

    private class WsdlRequestResponseHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<AbstractHttpRequest<?>> {
        AbstractHttpRequest<?> request;
        AbstractXmlInspector inspector;

        public WsdlRequestResponseHeadersModel(AbstractHttpRequest<?> request) {
            super(true, request, WsdlRequest.RESPONSE_PROPERTY);
            this.request = request;
            this.request.addPropertyChangeListener(this);
        }

        @Override
        public StringToStringsMap getHeaders() {
            AbstractHttpRequestInterface request = (AbstractHttpRequestInterface)this.getModelItem();
            return request.getResponse() == null ? new StringToStringsMap() : request.getResponse().getResponseHeaders();
        }

        @Override
        public void setInspector(AbstractXmlInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.request.getEndpoint() != null && evt.getPropertyName().equals("endpoint")) {
                this.inspector.setEnabled(!this.request.getEndpoint().startsWith("jms://"));
            }
            super.propertyChange(evt);
        }

        @Override
        public void release() {
            super.release();
            this.request.removePropertyChangeListener(this);
        }
    }

    private class MockResponseHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<MockResponse> {
        public MockResponseHeadersModel(MockResponse mockResponse) {
            super(false, mockResponse, WsdlMockResponse.HEADERS_PROPERTY);
        }

        @Override
        public StringToStringsMap getHeaders() {
            return ((MockResponse)this.getModelItem()).getResponseHeaders();
        }

        @Override
        public void setHeaders(StringToStringsMap headers) {
            ((MockResponse)this.getModelItem()).setResponseHeaders(headers);
        }
    }

    private class AMFResponseHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<AMFRequestTestStep> {
        AMFRequestTestStep testStep;

        public AMFResponseHeadersModel(AMFRequestTestStep testStep) {
            super(true, testStep, "responseHeaders");
            this.testStep = testStep;
            this.testStep.getAMFRequest().addPropertyChangeListener("response", this);
        }

        @Override
        public StringToStringsMap getHeaders() {
            if (this.testStep.getAMFRequest().getResponse() != null) {
                AMFResponse response = this.testStep.getAMFRequest().getResponse();
                return response.getResponseHeaders();
            }
            return new StringToStringsMap();
        }

        @Override
        public void release() {
            super.release();
            this.testStep.getAMFRequest().removePropertyChangeListener("response", this);
        }
    }

    private class AMFRequestHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<AMFRequestTestStep> {
        public AMFRequestHeadersModel(AMFRequestTestStep testStep) {
            super(false, testStep, "AMF_REQUEST");
        }

        @Override
        public StringToStringsMap getHeaders() {
            return ((AMFRequestTestStep)this.getModelItem()).getHttpHeaders();
        }

        @Override
        public void setHeaders(StringToStringsMap headers) {
            ((AMFRequestTestStep)this.getModelItem()).setHttpHeaders(headers);
        }

        @Override
        public void release() {
            super.release();
        }
    }

    private class WsdlRequestHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<AbstractHttpRequest<?>> {
        AbstractHttpRequest<?> request;
        AbstractXmlInspector inspector;

        public WsdlRequestHeadersModel(AbstractHttpRequest<?> abstractHttpRequest) {
            super(false, abstractHttpRequest, AbstractHttpRequestInterface.REQUEST_HEADERS_PROPERTY);
            this.request = abstractHttpRequest;
            this.request.addPropertyChangeListener(this);
        }

        @Override
        public StringToStringsMap getHeaders() {
            return ((AbstractHttpRequest)this.getModelItem()).getRequestHeaders();
        }

        @Override
        public void setHeaders(StringToStringsMap headers) {
            ((AbstractHttpRequest)this.getModelItem()).setRequestHeaders(headers);
        }

        @Override
        public void setInspector(AbstractXmlInspector inspector) {
            this.inspector = inspector;
        }

        @Override
        public void release() {
            super.release();
            this.request.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("endpoint") && this.inspector != null && this.request.getEndpoint() != null) {
                this.inspector.setEnabled(!this.request.getEndpoint().startsWith("jms://"));
            }
            super.propertyChange(evt);
        }
    }

    private class WsdlMessageExchangeResponseHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public WsdlMessageExchangeResponseHeadersModel(MessageExchangeModelItem response) {
            super(true, response, "messageExchange");
        }

        @Override
        public StringToStringsMap getHeaders() {
            MessageExchange messageExchange = ((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
            return messageExchange == null ? new StringToStringsMap() : messageExchange.getResponseHeaders();
        }
    }

    private class AMFMessageExchangeResponseHTTPHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public AMFMessageExchangeResponseHTTPHeadersModel(MessageExchangeModelItem modelItem) {
            super(true, modelItem, "messageExchange");
        }

        @Override
        public StringToStringsMap getHeaders() {
            if (((MessageExchangeModelItem)this.getModelItem()).getMessageExchange() instanceof AMFTestStepResult) {
                AMFTestStepResult messageExchange = (AMFTestStepResult)((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
                return messageExchange.getResponse().getResponseHeaders();
            }
            return new StringToStringsMap();
        }
    }

    private class AMFMessageExchangeRequestHTTPHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public AMFMessageExchangeRequestHTTPHeadersModel(MessageExchangeModelItem request) {
            super(true, request, "messageExchange");
        }

        @Override
        public StringToStringsMap getHeaders() {
            if (((MessageExchangeModelItem)this.getModelItem()).getMessageExchange() instanceof AMFTestStepResult) {
                AMFTestStepResult messageExchange = (AMFTestStepResult)((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
                return ((AMFRequestTestStep)messageExchange.getTestStep()).getHttpHeaders();
            }
            return new StringToStringsMap();
        }
    }

    private class WsdlMessageExchangeRequestHeadersModel
    extends HttpHeadersInspectorModel.AbstractHeadersModel<MessageExchangeModelItem> {
        public WsdlMessageExchangeRequestHeadersModel(MessageExchangeModelItem request) {
            super(true, request, "messageExchange");
        }

        @Override
        public StringToStringsMap getHeaders() {
            MessageExchange messageExchange = ((MessageExchangeModelItem)this.getModelItem()).getMessageExchange();
            return messageExchange == null ? new StringToStringsMap() : messageExchange.getRequestHeaders();
        }
    }
}

