/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.impl.rest.OAuth2Profile;
import com.eviware.soapui.impl.rest.actions.oauth.BrowserListenerAdapter;
import com.eviware.soapui.impl.rest.actions.oauth.JavaScriptValidationError;
import com.eviware.soapui.impl.rest.actions.oauth.JavaScriptValidator;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2Parameters;
import com.eviware.soapui.impl.rest.actions.oauth.OAuth2TokenExtractor;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class OAuth2ScriptsEditor
extends JPanel {
    static final String TEST_SCRIPTS_BUTTON_NAME = "testScriptsButton";
    static final String ADD_SCRIPT_BUTTON_NAME = "addScriptButton";
    static final String REMOVE_SCRIPT_BUTTON_NAME = "removeScriptButton";
    static final String[] DEFAULT_SCRIPT_NAMES = new String[]{"Page 1 (e.g. login screen)", "Page 2 (e.g. consent screen)"};
    private static final String HELP_LINK_TEXT = "How to automate the process of getting an access token";
    private List<InputPanel> inputPanels = new ArrayList<InputPanel>();
    private InputPanel selectedInputField = null;
    private List<RSyntaxTextArea> scriptFields = new ArrayList<RSyntaxTextArea>();
    private JavaScriptValidator javaScriptValidator = new JavaScriptValidator();
    private JPanel scriptsPanel;
    private JButton removeScriptButton;
    private OAuth2Profile profile;
    private DocumentListener scriptUpdater;

    public OAuth2ScriptsEditor(OAuth2Profile profile) {
        super(new BorderLayout());
        this.profile = profile;
        this.add((Component)this.buildToolbar(profile), "North");
        this.makeScriptsPanel(profile);
        this.add((Component)new JScrollPane(this.scriptsPanel), "Center");
        JPanel linkPanel = new JPanel(new FlowLayout(0));
        linkPanel.add(UISupport.createLabelLink("/OAuth/automating-access-token-retrieval.html", HELP_LINK_TEXT));
        this.add((Component)linkPanel, "South");
    }

    private JXToolBar buildToolbar(OAuth2Profile profile) {
        JXToolBar toolbar = UISupport.createToolbar();
        JButton testScriptsButton = UISupport.createToolbarButton(new TestScriptsAction(profile));
        testScriptsButton.setName(TEST_SCRIPTS_BUTTON_NAME);
        toolbar.addFixed(testScriptsButton);
        JButton addScriptButton = UISupport.createToolbarButton(new AddScriptAction());
        addScriptButton.setName(ADD_SCRIPT_BUTTON_NAME);
        toolbar.addFixed(addScriptButton);
        this.removeScriptButton = UISupport.createToolbarButton(new RemoveScriptAction());
        this.removeScriptButton.setName(REMOVE_SCRIPT_BUTTON_NAME);
        toolbar.addFixed(this.removeScriptButton);
        toolbar.addGlue();
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction("/OAuth/automated-token-profile-editor.html")));
        return toolbar;
    }

    public List<String> getJavaScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        for (RSyntaxTextArea scriptField : this.scriptFields) {
            scripts.add(scriptField.getText());
        }
        return scripts;
    }

    protected OAuth2TokenExtractor getExtractor() {
        return new OAuth2TokenExtractor();
    }

    void selectField(InputPanel field) {
        this.selectedInputField = field;
        for (InputPanel inputPanel : this.inputPanels) {
            if (inputPanel == field) {
                inputPanel.highlight();
                continue;
            }
            inputPanel.removeHighlight();
        }
        this.removeScriptButton.setEnabled(this.selectedInputField != null);
    }

    private JPanel makeScriptsPanel(OAuth2Profile profile) {
        this.scriptUpdater = new ScriptUpdater(profile);
        List<String> currentScripts = profile.getAutomationJavaScripts();
        this.scriptsPanel = new JPanel();
        this.scriptsPanel.setLayout(new BoxLayout(this.scriptsPanel, 1));
        this.scriptsPanel.setBackground(Color.WHITE);
        int numberOfFields = Math.max(2, currentScripts.size());
        for (int index = 0; index < numberOfFields; ++index) {
            RSyntaxTextArea scriptField = SyntaxEditorUtil.createDefaultJavaScriptSyntaxTextArea();
            String scriptName = index < DEFAULT_SCRIPT_NAMES.length ? DEFAULT_SCRIPT_NAMES[index] : "Page " + (index + 1);
            scriptField.setName(scriptName);
            if (currentScripts.size() > index) {
                scriptField.setText(currentScripts.get(index));
            }
            scriptField.getDocument().addDocumentListener(this.scriptUpdater);
            this.scriptFields.add(scriptField);
            InputPanel inputPanel = new InputPanel(scriptName, scriptField);
            inputPanel.setName("Input panel " + (index + 1));
            this.inputPanels.add(inputPanel);
            this.scriptsPanel.add(inputPanel);
        }
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.setBorder(new CompoundBorder(new LineBorder(Color.BLACK), new EmptyBorder(15, 15, 15, 15)));
        parentPanel.add((Component)this.scriptsPanel, "Center");
        return parentPanel;
    }

    private void showErrorMessage(String message) {
        if (message.length() > 120) {
            UISupport.showErrorMessage(message.replaceAll("\r\n", "<br/>"));
        } else {
            UISupport.showErrorMessage(message);
        }
    }

    private class ScriptUpdater
    extends DocumentListenerAdapter {
        private final OAuth2Profile profile;

        public ScriptUpdater(OAuth2Profile profile) {
            this.profile = profile;
        }

        @Override
        public void update(Document document) {
            this.profile.setAutomationJavaScripts(OAuth2ScriptsEditor.this.getJavaScripts());
        }
    }

    private class JavaScriptErrorReporter
    extends BrowserListenerAdapter {
        private final List<String> expectedScripts;
        private boolean hasErrors = false;
        private List<String> executedScripts = new ArrayList<String>();

        public JavaScriptErrorReporter(List<String> automationJavaScripts) {
            this.expectedScripts = this.nonEmptyScriptsIn(automationJavaScripts);
        }

        private List<String> nonEmptyScriptsIn(List<String> scriptList) {
            ArrayList<String> filteredList = new ArrayList<String>();
            for (String script : scriptList) {
                if (!StringUtils.hasContent(script)) continue;
                filteredList.add(script);
            }
            return filteredList;
        }

        @Override
        public void javaScriptExecuted(final String script, final String errorLocation, final Exception error) {
            this.executedScripts.add(script);
            if (error != null) {
                this.hasErrors = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OAuth2ScriptsEditor.this.showErrorMessage("The following script failed:\r\n" + script + "\r\nPage URL: " + errorLocation + "\r\nError:\r\n" + error.getMessage() + "]");
                    }
                });
            }
        }

        @Override
        public void browserClosed() {
            if (!this.hasErrors) {
                if (this.executedScripts.containsAll(this.expectedScripts)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UISupport.showInfoMessage("All scripts executed correctly.");
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UISupport.showInfoMessage("The scripts could only be partially validated, because all scripts weren't executed in the OAuth 2 flow.\nMaybe you already have an active session in the authorization server?", "Scripts not fully validated");
                        }
                    });
                }
            }
        }
    }

    class InputPanel
    extends JPanel {
        private RSyntaxTextArea scriptField;
        private final Color originalBackground;

        public InputPanel(String scriptName, RSyntaxTextArea scriptField) {
            super(new BorderLayout(20, 20));
            this.scriptField = scriptField;
            this.add((Component)new JLabel(scriptName), "North");
            this.add((Component)new JScrollPane((Component)scriptField), "Center");
            MouseAdapter selectionHandler = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (OAuth2ScriptsEditor.this.selectedInputField == InputPanel.this) {
                        if (e.getSource() == InputPanel.this) {
                            OAuth2ScriptsEditor.this.selectField(null);
                        }
                    } else {
                        OAuth2ScriptsEditor.this.selectField(InputPanel.this);
                    }
                }
            };
            this.addMouseListener(selectionHandler);
            this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            this.originalBackground = this.getBackground();
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension size = super.getMaximumSize();
            size.height = 300;
            return size;
        }

        public void highlight() {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.setBackground(this.aDarkerShadeThan(this.originalBackground));
        }

        private Color aDarkerShadeThan(Color color) {
            return new Color((int)((double)color.getRed() * 0.9), (int)((double)color.getBlue() * 0.9), (int)((double)color.getGreen() * 0.9));
        }

        public void removeHighlight() {
            this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            this.setBackground(this.originalBackground);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(new CompoundBorder(border, new EmptyBorder(20, 20, 20, 20)));
        }
    }

    private class TestScriptsAction
    extends AbstractAction {
        private OAuth2Profile profile;

        private TestScriptsAction(OAuth2Profile profile) {
            this.profile = profile;
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Test scripts");
            this.putValue("LongDescription", "Validates the scripts and tries to execute them in a browser");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean errorsFound = false;
            for (RSyntaxTextArea scriptField : OAuth2ScriptsEditor.this.scriptFields) {
                String script = scriptField.getText();
                JavaScriptValidationError validate = OAuth2ScriptsEditor.this.javaScriptValidator.validate(script);
                if (validate == null) continue;
                OAuth2ScriptsEditor.this.showErrorMessage("The following script is invalid:\r\n" + script + "\r\n\r\nError:<br/>" + validate.getErrorMessage());
                errorsFound = true;
            }
            if (!errorsFound) {
                OAuth2TokenExtractor extractor = OAuth2ScriptsEditor.this.getExtractor();
                extractor.addBrowserListener(new JavaScriptErrorReporter(this.profile.getAutomationJavaScripts()));
                OAuth2Parameters parameters = new OAuth2Parameters(this.profile);
                try {
                    extractor.extractAccessToken(parameters);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }
    }

    private class RemoveScriptAction
    extends AbstractAction {
        private RemoveScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/delete.png"));
            this.putValue("ShortDescription", "Remove script field");
            this.putValue("LongDescription", "Removes the last script input field");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UISupport.confirm("Do you really want to remove the script '" + OAuth2ScriptsEditor.this.selectedInputField.scriptField.getName() + "'", "Remove script", OAuth2ScriptsEditor.this)) {
                OAuth2ScriptsEditor.this.scriptFields.remove(OAuth2ScriptsEditor.this.selectedInputField.scriptField);
                OAuth2ScriptsEditor.this.inputPanels.remove(OAuth2ScriptsEditor.this.selectedInputField);
                OAuth2ScriptsEditor.this.scriptsPanel.remove(OAuth2ScriptsEditor.this.selectedInputField);
                OAuth2ScriptsEditor.this.selectedInputField = null;
                OAuth2ScriptsEditor.this.scriptsPanel.revalidate();
                OAuth2ScriptsEditor.this.scriptsPanel.repaint();
                OAuth2ScriptsEditor.this.selectField(null);
                OAuth2ScriptsEditor.this.profile.setAutomationJavaScripts(OAuth2ScriptsEditor.this.getJavaScripts());
            }
        }

        @Override
        public boolean isEnabled() {
            return OAuth2ScriptsEditor.this.selectedInputField != null;
        }
    }

    private class AddScriptAction
    extends AbstractAction {
        private AddScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Add script field");
            this.putValue("LongDescription", "Adds a new script input field");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RSyntaxTextArea scriptField = SyntaxEditorUtil.createDefaultJavaScriptSyntaxTextArea();
            int index = OAuth2ScriptsEditor.this.scriptFields.size() + 1;
            String fieldName = "Page " + index;
            scriptField.setName(fieldName);
            scriptField.getDocument().addDocumentListener(OAuth2ScriptsEditor.this.scriptUpdater);
            OAuth2ScriptsEditor.this.scriptFields.add(scriptField);
            InputPanel inputPanel = new InputPanel(fieldName, scriptField);
            inputPanel.setName("Input panel " + index);
            OAuth2ScriptsEditor.this.inputPanels.add(inputPanel);
            OAuth2ScriptsEditor.this.scriptsPanel.add((Component)inputPanel, -1);
            OAuth2ScriptsEditor.this.scriptsPanel.revalidate();
            OAuth2ScriptsEditor.this.scriptsPanel.repaint();
        }
    }
}

