/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.auth;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.AccessTokenStatusConfig;
import com.eviware.soapui.impl.rest.OAuth1Profile;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.AbstractXmlInspector;
import com.eviware.soapui.support.editor.inspectors.auth.AbstractAuthenticationForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1AdvancedOptionsDialog;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1GetTokenForm;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1TokenStatusChangeListener;
import com.eviware.soapui.support.editor.inspectors.auth.OAuth1TokenStatusChangeManager;
import com.eviware.soapui.support.editor.inspectors.auth.ProfileSelectionForm;
import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.value.ValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OAuth1Form
extends AbstractAuthenticationForm
implements OAuth1TokenStatusChangeListener {
    public static final String ADVANCED_OPTIONS_BUTTON_NAME = "Advanced...";
    static final ImageIcon SUCCESS_ICON = UISupport.createImageIcon("/check.png");
    static final ImageIcon FAIL_ICON = UISupport.createImageIcon("/alert.png");
    private static final MessageSupport messages = MessageSupport.getMessages(OAuth1Form.class);
    private static final int ACCESS_TOKEN_DIALOG_HORIZONTAL_OFFSET = 120;
    private static final Dimension HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW = new Dimension(5, 0);
    private static final String ACCESS_TOKEN_LABEL = "Access Token";
    private static final String TOKEN_SECRET_LABEL = "Token Secret";
    private static final Insets TOKEN_FIELD_INSETS = new Insets(5, 5, 5, 5);
    private static final float TOKEN_STATUS_TEXT_FONT_SCALE = 0.95f;
    private static final String GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL = "Get Token";
    private final Color DEFAULT_COLOR = Color.WHITE;
    private final Color SUCCESS_COLOR = new Color(0xCCFFCB);
    private final Color FAIL_COLOR = new Color(0xFFCCCC);
    private final AbstractXmlInspector inspector;
    private final OAuth1TokenStatusChangeManager statusChangeManager;
    private OAuth1Profile profile;
    private JPanel formPanel;
    private boolean disclosureButtonDisabled;
    private boolean isMouseOnDisclosureLabel;
    private SimpleBindingForm oAuth1Form;
    private JTextField accessTokenField;
    private JLabel accessTokenStatusIcon;
    private JLabel accessTokenStatusText;
    private JTextField secretTokenField;
    private JLabel secretTokenStatusIcon;
    private JLabel secretTokenStatusText;
    private JLabel disclosureButton;
    private OAuth1GetTokenForm accessTokenForm;
    private SoapUIMainWindowFocusListener mainWindowFocusListener;

    public OAuth1Form(OAuth1Profile profile, AbstractXmlInspector inspector) {
        this.profile = profile;
        this.inspector = inspector;
        this.statusChangeManager = new OAuth1TokenStatusChangeManager(this);
        this.statusChangeManager.register();
    }

    void release() {
        SoapUI.getFrame().removeWindowFocusListener(this.mainWindowFocusListener);
        this.accessTokenForm.release();
        this.oAuth1Form.getPresentationModel().release();
        this.statusChangeManager.unregister();
    }

    @Override
    public void onAccessTokenStatusChanged(@Nonnull AccessTokenStatusConfig.Enum status) {
        this.setAccessTokenStatusFeedback(status);
    }

    @Override
    public void onTokenSecretStatusChanged(@Nonnull AccessTokenStatusConfig.Enum status) {
        this.setSecretTokenStatusFeedback(status);
    }

    @Override
    @Nonnull
    public OAuth1Profile getProfile() {
        return this.profile;
    }

    @Override
    protected JPanel buildUI() {
        this.oAuth1Form = new SimpleBindingForm(new PresentationModel((Object)this.profile));
        this.addOAuth2Panel(this.oAuth1Form);
        if (this.profile.getAccessTokenStatus() != AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.profile.resetAccessTokenStatusToStartingStatus();
        }
        this.setAccessTokenStatusFeedback(this.profile.getAccessTokenStatus());
        this.setSecretTokenStatusFeedback(this.profile.getTokenSecretStatus());
        return this.formPanel;
    }

    private void addOAuth2Panel(SimpleBindingForm oAuth2Form) {
        this.populateOAuth1Form(oAuth2Form);
        this.formPanel = new JPanel(new BorderLayout());
        JPanel centerPanel = oAuth2Form.getPanel();
        this.setBackgroundColorOnPanel(centerPanel);
        JPanel southPanel = new JPanel(new FlowLayout(0));
        this.setBackgroundColorOnPanel(southPanel);
        this.formPanel.add((Component)centerPanel, "Center");
        this.formPanel.add((Component)southPanel, "South");
        this.setBorderOnPanel(this.formPanel);
    }

    private void populateOAuth1Form(SimpleBindingForm oAuth1Form) {
        this.initForm(oAuth1Form);
        oAuth1Form.addSpace(10);
        this.accessTokenField = this.createTokenField("accessToken");
        this.accessTokenStatusIcon = this.createTokenStatusIcon();
        this.accessTokenStatusText = this.createAccessTokenStatusText();
        JPanel accessTokenRowPanel = this.createAccessTokenRowPanel(this.accessTokenField, this.accessTokenStatusIcon, this.accessTokenStatusText);
        oAuth1Form.append(ACCESS_TOKEN_LABEL, accessTokenRowPanel);
        oAuth1Form.addInputFieldHintText(messages.get("OAuth1Form.AccessTokenField.Hint"));
        this.disclosureButton = new JLabel(GET_ACCESS_TOKEN_BUTTON_DEFAULT_LABEL);
        this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-open.png"));
        this.disclosureButton.setName("oAuth2DisclosureButton");
        oAuth1Form.addComponentWithoutLabel(this.disclosureButton);
        this.secretTokenField = this.createTokenField("tokenSecret");
        this.secretTokenStatusIcon = this.createTokenStatusIcon();
        this.secretTokenStatusText = this.createAccessTokenStatusText();
        JPanel secretTokenRowPanel = this.createAccessTokenRowPanel(this.secretTokenField, this.secretTokenStatusIcon, this.secretTokenStatusText);
        oAuth1Form.append(TOKEN_SECRET_LABEL, secretTokenRowPanel);
        oAuth1Form.addInputFieldHintText(messages.get("OAuth1Form.SecretTokenField.Hint"));
        JButton advancedOptionsButton = new JButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OAuth1AdvancedOptionsDialog(OAuth1Form.this.profile);
            }
        });
        advancedOptionsButton.setText(ADVANCED_OPTIONS_BUTTON_NAME);
        oAuth1Form.addLeftComponent(advancedOptionsButton);
        this.accessTokenForm = new OAuth1GetTokenForm(this.profile);
        JDialog accessTokenFormDialog = this.accessTokenForm.getComponent();
        this.disclosureButton.addMouseListener(new DisclosureButtonMouseListener(accessTokenFormDialog, this.disclosureButton));
        accessTokenFormDialog.addWindowFocusListener(new AccessTokenFormDialogWindowListener(accessTokenFormDialog));
        this.mainWindowFocusListener = new SoapUIMainWindowFocusListener(accessTokenFormDialog);
        SoapUI.getFrame().addWindowFocusListener(this.mainWindowFocusListener);
    }

    private JTextField createTokenField(String fieldName) {
        JTextField tokenField = new JTextField();
        tokenField.setName(fieldName);
        tokenField.setColumns(30);
        tokenField.setMargin(TOKEN_FIELD_INSETS);
        Bindings.bind((JTextField)tokenField, (ValueModel)this.oAuth1Form.getPresentationModel().getModel(fieldName));
        return tokenField;
    }

    private JLabel createTokenStatusIcon() {
        JLabel tokenStatusIcon = new JLabel();
        tokenStatusIcon.setVisible(false);
        return tokenStatusIcon;
    }

    private JLabel createAccessTokenStatusText() {
        JLabel tokenStatusText = new JLabel();
        tokenStatusText.setFont(this.scaledFont(tokenStatusText, 0.95f));
        tokenStatusText.setVisible(false);
        tokenStatusText.setAlignmentX(0.5f);
        return tokenStatusText;
    }

    private JPanel createAccessTokenRowPanel(JTextField accessTokenField, JLabel accessTokenStatusIcon, JLabel accessTokenStatusText) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBackground(CARD_BACKGROUND_COLOR);
        panel.add(accessTokenField);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        panel.add(accessTokenStatusIcon);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        panel.add(accessTokenStatusText);
        panel.add(Box.createRigidArea(HORIZONTAL_SPACING_IN_ACCESS_TOKEN_ROW));
        return panel;
    }

    private Font scaledFont(JComponent component, float scale) {
        Font currentFont = component.getFont();
        return currentFont.deriveFont((float)currentFont.getSize() * scale);
    }

    private void setAccessTokenFormDialogBoundsBelowTheButton(Point disclosureButtonLocation, JDialog accessTokenFormDialog, int disclosureButtonHeight) {
        accessTokenFormDialog.setLocation((int)disclosureButtonLocation.getX() - 120, (int)disclosureButtonLocation.getY() + disclosureButtonHeight);
    }

    private void setAccessTokenFormDialogBoundsAboveTheButton(Point disclosureButtonLocation, JDialog accessTokenFormDialog) {
        accessTokenFormDialog.setLocation((int)disclosureButtonLocation.getX() - 120, (int)disclosureButtonLocation.getY() - accessTokenFormDialog.getHeight());
    }

    private void setAccessTokenStatusFeedback(AccessTokenStatusConfig.Enum status) {
        if (status == AccessTokenStatusConfig.UNKNOWN) {
            this.setAccessTokenDefaultFeedback();
        } else if (status == AccessTokenStatusConfig.ENTERED_MANUALLY) {
            this.setAccessTokenEnteredManuallyFeedback();
        } else if (status == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER) {
            this.setAccessTokenSuccessfulFeedback();
        } else if (status == AccessTokenStatusConfig.EXPIRED || status == AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.setAccessTokenFailedFeedback();
        } else {
            this.setAccessTokenDefaultFeedback();
        }
    }

    private void setSecretTokenStatusFeedback(AccessTokenStatusConfig.Enum status) {
        if (status == AccessTokenStatusConfig.UNKNOWN) {
            this.setSecretTokenDefaultFeedback();
        } else if (status == AccessTokenStatusConfig.ENTERED_MANUALLY) {
            this.setSecretTokenEnteredManuallyFeedback();
        } else if (status == AccessTokenStatusConfig.RETRIEVED_FROM_SERVER) {
            this.setSecretTokenSuccessfulFeedback();
        } else if (status == AccessTokenStatusConfig.EXPIRED || status == AccessTokenStatusConfig.RETRIEVAL_CANCELED) {
            this.setSecretTokenFailedFeedback();
        } else {
            this.setSecretTokenDefaultFeedback();
        }
    }

    private void setSecretTokenEnteredManuallyFeedback() {
        this.secretTokenField.setBackground(this.DEFAULT_COLOR);
        this.secretTokenStatusIcon.setIcon(null);
        this.secretTokenStatusIcon.setVisible(false);
        this.secretTokenStatusText.setText(messages.get("OAuth1Form.EnteredManually"));
        this.secretTokenStatusText.setVisible(true);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setSecretTokenSuccessfulFeedback() {
        this.secretTokenField.setBackground(this.SUCCESS_COLOR);
        this.secretTokenStatusIcon.setIcon(SUCCESS_ICON);
        this.secretTokenStatusIcon.setVisible(true);
        this.secretTokenStatusText.setText(messages.get("OAuth1Form.Retrieved"));
        this.secretTokenStatusText.setVisible(true);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setSecretTokenFailedFeedback() {
        this.secretTokenField.setBackground(this.FAIL_COLOR);
        this.secretTokenStatusIcon.setIcon(FAIL_ICON);
        this.secretTokenStatusIcon.setVisible(true);
        this.secretTokenStatusText.setText(messages.get("OAuth1Form.FailedFeedback"));
        this.secretTokenStatusText.setVisible(true);
        this.inspector.setIcon(FAIL_ICON);
    }

    private void setSecretTokenDefaultFeedback() {
        this.secretTokenField.setBackground(this.DEFAULT_COLOR);
        this.secretTokenStatusIcon.setIcon(null);
        this.secretTokenStatusIcon.setVisible(false);
        this.secretTokenStatusText.setText("");
        this.secretTokenStatusText.setVisible(false);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setAccessTokenEnteredManuallyFeedback() {
        this.accessTokenField.setBackground(this.DEFAULT_COLOR);
        this.accessTokenStatusIcon.setIcon(null);
        this.accessTokenStatusIcon.setVisible(false);
        this.accessTokenStatusText.setText(messages.get("OAuth1Form.EnteredManually"));
        this.accessTokenStatusText.setVisible(true);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setAccessTokenSuccessfulFeedback() {
        this.accessTokenField.setBackground(this.SUCCESS_COLOR);
        this.accessTokenStatusIcon.setIcon(SUCCESS_ICON);
        this.accessTokenStatusIcon.setVisible(true);
        this.accessTokenStatusText.setText(messages.get("OAuth1Form.Retrieved"));
        this.accessTokenStatusText.setVisible(true);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void setAccessTokenFailedFeedback() {
        this.accessTokenField.setBackground(this.FAIL_COLOR);
        this.accessTokenStatusIcon.setIcon(FAIL_ICON);
        this.accessTokenStatusIcon.setVisible(true);
        this.accessTokenStatusText.setText(messages.get("OAuth1Form.FailedFeedback"));
        this.accessTokenStatusText.setVisible(true);
        this.inspector.setIcon(FAIL_ICON);
    }

    private void setAccessTokenDefaultFeedback() {
        this.accessTokenField.setBackground(this.DEFAULT_COLOR);
        this.accessTokenStatusIcon.setIcon(null);
        this.accessTokenStatusIcon.setVisible(false);
        this.accessTokenStatusText.setText("");
        this.accessTokenStatusText.setVisible(false);
        this.inspector.setIcon(ProfileSelectionForm.AUTH_ENABLED_ICON);
    }

    private void hideAccessTokenFormDialogAndEnableDisclosureButton(JDialog accessTokenFormDialog) {
        accessTokenFormDialog.setVisible(false);
        this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-open.png"));
        if (!this.isMouseOnDisclosureLabel) {
            this.disclosureButtonDisabled = false;
        }
    }

    private class SoapUIMainWindowFocusListener
    extends WindowAdapter {
        private final JDialog accessTokenFormDialog;

        public SoapUIMainWindowFocusListener(JDialog accessTokenFormDialog) {
            this.accessTokenFormDialog = accessTokenFormDialog;
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            if (this.accessTokenFormDialog.isVisible()) {
                OAuth1Form.this.hideAccessTokenFormDialogAndEnableDisclosureButton(this.accessTokenFormDialog);
            }
        }
    }

    private class AccessTokenFormDialogWindowListener
    implements WindowFocusListener {
        private final JDialog accessTokenFormDialog;

        public AccessTokenFormDialogWindowListener(JDialog accessTokenFormDialog) {
            this.accessTokenFormDialog = accessTokenFormDialog;
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            OAuth1Form.this.disclosureButtonDisabled = true;
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            if (this.isMouseOnComponent(SoapUI.getFrame()) && !this.isMouseOnComponent(this.accessTokenFormDialog)) {
                OAuth1Form.this.hideAccessTokenFormDialogAndEnableDisclosureButton(this.accessTokenFormDialog);
            }
        }

        private boolean isMouseOnComponent(Component component) {
            if (!component.isShowing()) {
                return false;
            }
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            Point componentLocationOnScreen = component.getLocationOnScreen();
            return component.contains(mouseLocation.x - componentLocationOnScreen.x, mouseLocation.y - componentLocationOnScreen.y);
        }
    }

    private class DisclosureButtonMouseListener
    extends MouseAdapter {
        private final JDialog accessTokenFormDialog;
        private final JLabel disclosureButton;

        public DisclosureButtonMouseListener(JDialog accessTokenFormDialog, JLabel disclosureButton) {
            this.accessTokenFormDialog = accessTokenFormDialog;
            this.disclosureButton = disclosureButton;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OAuth1Form.this.disclosureButtonDisabled) {
                OAuth1Form.this.disclosureButtonDisabled = false;
                return;
            }
            JLabel source = (JLabel)e.getSource();
            Point disclosureButtonLocation = source.getLocationOnScreen();
            this.accessTokenFormDialog.pack();
            this.accessTokenFormDialog.setVisible(true);
            this.disclosureButton.setIcon(UISupport.createImageIcon("/pop-down-close.png"));
            if (UISupport.isEnoughSpaceAvailableBelowComponent(disclosureButtonLocation, this.accessTokenFormDialog.getHeight(), source.getHeight())) {
                OAuth1Form.this.setAccessTokenFormDialogBoundsBelowTheButton(disclosureButtonLocation, this.accessTokenFormDialog, source.getHeight());
            } else {
                OAuth1Form.this.setAccessTokenFormDialogBoundsAboveTheButton(disclosureButtonLocation, this.accessTokenFormDialog);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            OAuth1Form.this.isMouseOnDisclosureLabel = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            OAuth1Form.this.isMouseOnDisclosureLabel = false;
        }
    }
}

