/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.Inspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.VTextIcon;
import com.eviware.soapui.support.components.VerticalMetalTabbedPaneUI;
import com.eviware.soapui.support.components.VerticalWindowsTabbedPaneUI;
import com.eviware.soapui.support.editor.EditorDocument;
import com.eviware.soapui.support.editor.EditorInspector;
import com.eviware.soapui.support.editor.EditorLocation;
import com.eviware.soapui.support.editor.EditorLocationListener;
import com.eviware.soapui.support.editor.EditorView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

public class Editor<T extends EditorDocument>
extends JPanel
implements PropertyChangeListener,
EditorLocationListener<T> {
    public static final String OUTLINE_TABLE_PROPERTY = Editor.class.getSimpleName() + "@outlineTable";
    private JTabbedPane inputTabs;
    private List<EditorView<T>> views = new ArrayList<EditorView<T>>();
    private EditorView<T> currentView;
    private T document;
    private JInspectorPanel inspectorPanel;
    private InputTabsChangeListener inputTabsChangeListener;

    public Editor(T document) {
        super(new BorderLayout());
        this.document = document;
        document.addPropertyChangeListener(EditorDocument.DOCUMENT_PROPERTY, this);
        this.setBackground(Color.WHITE);
        this.inputTabs = new JTabbedPane(2, 1);
        this.prettifyTabbedPaneUI();
        this.inputTabs.setFont(this.inputTabs.getFont().deriveFont(8));
        this.inputTabsChangeListener = new InputTabsChangeListener();
        this.inputTabs.addChangeListener(this.inputTabsChangeListener);
        this.inspectorPanel = JInspectorPanelFactory.build(this.inputTabs);
        this.add((Component)this.inspectorPanel.getComponent(), "Center");
    }

    private void prettifyTabbedPaneUI() {
        if (!UISupport.isMac()) {
            if (this.inputTabs.getUI().getClass().getSimpleName().equals("WindowsTabbedPaneUI")) {
                this.inputTabs.setUI((TabbedPaneUI)((Object)new VerticalWindowsTabbedPaneUI()));
            } else {
                this.inputTabs.setUI(new VerticalMetalTabbedPaneUI());
            }
        }
    }

    public void addEditorView(EditorView<T> editorView) {
        this.views.add(editorView);
        if (UISupport.isMac()) {
            this.inputTabs.addTab(editorView.getTitle(), editorView.getComponent());
        } else {
            this.inputTabs.addTab(null, new VTextIcon(this.inputTabs, editorView.getTitle(), 2), editorView.getComponent());
        }
        editorView.addPropertyChangeListener(this);
        editorView.addLocationListener(this);
        editorView.setDocument(this.document);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(EditorView.TITLE_PROPERTY)) {
            int ix = this.views.indexOf(evt.getSource());
            if (ix == -1) {
                return;
            }
            this.inputTabs.setTitleAt(ix, (String)evt.getNewValue());
        }
        if (evt.getPropertyName().equals(EditorDocument.DOCUMENT_PROPERTY)) {
            this.inputTabsChangeListener.refreshVisibleInspectors();
        }
    }

    public void selectView(int viewIndex) {
        this.inputTabs.setSelectedIndex(viewIndex);
    }

    public void selectView(String viewId) {
        for (int c = 0; c < this.views.size(); ++c) {
            if (!this.views.get(c).getViewId().equals(viewId)) continue;
            this.inputTabs.setSelectedIndex(c);
            return;
        }
    }

    @Override
    public void locationChanged(EditorLocation<T> location) {
        if (location != null) {
            for (Inspector inspector : this.inspectorPanel.getInspectors()) {
                ((EditorInspector)inspector).locationChanged(location);
            }
        }
    }

    @Override
    public void requestFocus() {
        if (this.currentView != null) {
            this.currentView.getComponent().requestFocus();
        }
    }

    public T getDocument() {
        return this.document;
    }

    @Override
    public boolean hasFocus() {
        return this.currentView == null ? false : this.currentView.getComponent().hasFocus();
    }

    public final void setDocument(T document) {
        if (this.document != null) {
            this.document.release();
            this.document.removePropertyChangeListener(EditorDocument.DOCUMENT_PROPERTY, this);
        }
        this.document = document;
        this.document.addPropertyChangeListener(EditorDocument.DOCUMENT_PROPERTY, this);
        for (EditorView<T> view : this.views) {
            view.setDocument(document);
        }
        this.inputTabsChangeListener.refreshVisibleInspectors();
    }

    public final EditorView<T> getCurrentView() {
        return this.currentView;
    }

    public final JTabbedPane getInputTabs() {
        return this.inputTabs;
    }

    public final List<EditorView<T>> getViews() {
        return this.views;
    }

    public EditorView<T> getView(String viewId) {
        for (EditorView<T> view : this.views) {
            if (!view.getViewId().equals(viewId)) continue;
            return view;
        }
        return null;
    }

    public Inspector getInspector(String inspectorId) {
        return this.inspectorPanel.getInspector(inspectorId);
    }

    public void setEditable(boolean enabled) {
        for (EditorView<T> view : this.views) {
            view.setEditable(enabled);
        }
    }

    public void addInspector(EditorInspector<T> inspector) {
        this.inspectorPanel.addInspector(inspector);
        inspector.init(this);
        this.inspectorPanel.setInspectorVisible(inspector, this.currentView == null ? true : inspector.isEnabledFor(this.currentView));
    }

    public void release() {
        for (EditorView<T> view : this.views) {
            view.release();
            view.removePropertyChangeListener(this);
        }
        this.views.clear();
        this.inputTabs.removeChangeListener(this.inputTabsChangeListener);
        this.inputTabs.removeAll();
        this.inspectorPanel.release();
        this.document.release();
    }

    private final class InputTabsChangeListener
    implements ChangeListener {
        private int lastDividerLocation;

        private InputTabsChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            int currentViewIndex = Editor.this.views.indexOf(Editor.this.currentView);
            if (Editor.this.currentView != null) {
                if (Editor.this.inputTabs.getSelectedIndex() == currentViewIndex) {
                    return;
                }
                if (!Editor.this.currentView.deactivate()) {
                    Editor.this.inputTabs.setSelectedIndex(currentViewIndex);
                    return;
                }
            }
            EditorView previousView = Editor.this.currentView;
            int selectedIndex = Editor.this.inputTabs.getSelectedIndex();
            if (selectedIndex == -1) {
                Editor.this.currentView = null;
                return;
            }
            Editor.this.currentView = (EditorView)Editor.this.views.get(selectedIndex);
            if (Editor.this.currentView != null && !Editor.this.currentView.activate(previousView == null ? null : previousView.getEditorLocation())) {
                Editor.this.inputTabs.setSelectedIndex(currentViewIndex);
                if (currentViewIndex == -1) {
                    return;
                }
            }
            this.refreshVisibleInspectors();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Editor.this.currentView != null) {
                        Editor.this.currentView.getComponent().requestFocus();
                    }
                }
            });
        }

        private void refreshVisibleInspectors() {
            EditorInspector currentInspector = (EditorInspector)Editor.this.inspectorPanel.getCurrentInspector();
            if (currentInspector != null) {
                this.lastDividerLocation = Editor.this.inspectorPanel.getDividerLocation();
            }
            for (Inspector inspector : Editor.this.inspectorPanel.getInspectors()) {
                Editor.this.inspectorPanel.setInspectorVisible(inspector, ((EditorInspector)inspector).isEnabledFor(Editor.this.currentView));
            }
            if (currentInspector != null && currentInspector.isEnabledFor(Editor.this.currentView)) {
                if (this.lastDividerLocation == 0) {
                    Editor.this.inspectorPanel.setResetDividerLocation();
                } else {
                    Editor.this.inspectorPanel.setDividerLocation(this.lastDividerLocation);
                }
            } else {
                currentInspector = null;
            }
        }
    }
}

