/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd.handlers;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.WsdlTestSuite;
import com.eviware.soapui.impl.wsdl.actions.testsuite.CloneTestSuiteAction;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.dnd.handlers.AbstractAfterModelItemDropHandler;

public class TestSuiteToProjectDropHandler
extends AbstractAfterModelItemDropHandler<WsdlTestSuite, WsdlProject> {
    public TestSuiteToProjectDropHandler() {
        super(WsdlTestSuite.class, WsdlProject.class);
    }

    @Override
    boolean canCopyAfter(WsdlTestSuite source, WsdlProject target) {
        return true;
    }

    @Override
    boolean canMoveAfter(WsdlTestSuite source, WsdlProject target) {
        return source.getProject() != target;
    }

    @Override
    boolean copyAfter(WsdlTestSuite source, WsdlProject target) {
        String name = UISupport.prompt("Specify name for copied TestSuite", "Copy TestSuite", "Copy of " + source.getName());
        if (name == null) {
            return false;
        }
        if (source.getProject() == target) {
            return CloneTestSuiteAction.cloneTestSuiteWithinProject(source, name, target, source.getDescription()) != null;
        }
        return CloneTestSuiteAction.cloneToAnotherProject(source, target.getName(), name, false, source.getDescription()) != null;
    }

    @Override
    boolean moveAfter(WsdlTestSuite source, WsdlProject target) {
        String name = UISupport.prompt("Specify name for moved TestSuite", "Move TestSuite", source.getName());
        if (name == null) {
            return false;
        }
        WsdlTestSuite testSuite = CloneTestSuiteAction.cloneToAnotherProject(source, target.getName(), name, true, source.getDescription());
        if (testSuite != null) {
            source.getProject().removeTestSuite(source);
            return true;
        }
        return false;
    }

    @Override
    String getCopyAfterInfo(WsdlTestSuite source, WsdlProject target) {
        return source.getProject() == target ? "Copy TestSuite [" + source.getName() + "] within Project [" + target.getName() + "]" : "Copy TestSuite [" + source.getName() + "] to Project [" + target.getName() + "]";
    }

    @Override
    String getMoveAfterInfo(WsdlTestSuite source, WsdlProject target) {
        return "Move TestSuite [" + source.getName() + "] to Project [" + target.getName() + "]";
    }
}

