/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.dnd;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.support.dnd.JTreeDragAndDropable;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class NavigatorDragAndDropable
extends JTreeDragAndDropable<ModelItem> {
    public NavigatorDragAndDropable(JTree tree) {
        super(tree);
    }

    @Override
    public ModelItem getModelItemAtRow(int row) {
        TreePath pathForRow = this.getTree().getPathForRow(row);
        return pathForRow == null ? null : ((SoapUITreeNode)pathForRow.getLastPathComponent()).getModelItem();
    }

    @Override
    public int getRowForModelItem(ModelItem modelItem) {
        if (modelItem == null) {
            return -1;
        }
        TreePath treePath = SoapUI.getNavigator().getTreePath(modelItem);
        return this.getTree().getRowForPath(treePath);
    }

    @Override
    public Component getRenderer(ModelItem modelItem) {
        TreePath treePath = SoapUI.getNavigator().getTreePath(modelItem);
        int row = this.getTree().getRowForPath(treePath);
        SoapUITreeNode treeNode = (SoapUITreeNode)treePath.getLastPathComponent();
        return this.getTree().getCellRenderer().getTreeCellRendererComponent(this.getTree(), treeNode, true, this.getTree().isExpanded(row), treeNode.isLeaf(), row, true);
    }

    @Override
    public void toggleExpansion(ModelItem last) {
        if (last == SoapUI.getWorkspace()) {
            return;
        }
        super.toggleExpansion(last);
    }
}

