/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.scan;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.config.StrategyTypeConfig;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlSubmitContext;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertableConfig;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertionsSupport;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.SamplerTestStep;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.ExecutionStrategyHolder;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.SecurityTestRunnerImpl;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanRequestResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.support.FailedSecurityMessageExchange;
import com.eviware.soapui.security.support.SecurityTestRunListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public abstract class AbstractSecurityScan
extends AbstractWsdlModelItem<SecurityScanConfig>
implements ResponseAssertion,
SecurityScan {
    private SecurityScanResult securityScanResult;
    private SecurityScanRequestResult securityScanRequestResult;
    private TestStep testStep;
    protected AssertionsSupport assertionsSupport;
    private Assertable.AssertionStatus currentStatus;
    private ExecutionStrategyHolder executionStrategy;
    private TestStep originalTestStepClone;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean skipFurtherRunning;

    public AbstractSecurityScan(TestStep testStep, SecurityScanConfig config, ModelItem parent, String icon) {
        super(config, parent, icon);
        if (config == null) {
            config = SecurityScanConfig.Factory.newInstance();
            this.setConfig(config);
        }
        this.testStep = testStep;
        if (config.getExecutionStrategy() == null) {
            config.addNewExecutionStrategy();
            config.getExecutionStrategy().setStrategy(StrategyTypeConfig.ONE_BY_ONE);
            config.getExecutionStrategy().setDelay(100);
        } else if (config.getExecutionStrategy().getStrategy() == null) {
            config.getExecutionStrategy().setStrategy(StrategyTypeConfig.ONE_BY_ONE);
            config.getExecutionStrategy().setDelay(100);
        }
        this.setExecutionStrategy(new ExecutionStrategyHolder(config.getExecutionStrategy()));
        if (config.getCheckedParameters() == null) {
            config.addNewCheckedParameters();
        }
        this.initAssertions();
        this.setApplyForFailedTestStep(config.getApplyForFailedStep());
        if (!config.isSetDisabled()) {
            this.setDisabled(false);
        }
    }

    @Override
    public void copyConfig(SecurityScanConfig config) {
        super.setConfig(config);
        ((SecurityScanConfig)this.getConfig()).setType(config.getType());
        ((SecurityScanConfig)this.getConfig()).setName(config.getName());
        ((SecurityScanConfig)this.getConfig()).setConfig(config.getConfig());
        ((SecurityScanConfig)this.getConfig()).setTestStep(config.getTestStep());
        TestAssertionConfig[] assertions = config.getAssertionList().toArray(new TestAssertionConfig[0]);
        ((SecurityScanConfig)this.getConfig()).setAssertionArray(assertions);
        this.initAssertions();
        ((SecurityScanConfig)this.getConfig()).setExecutionStrategy(config.getExecutionStrategy());
        this.setExecutionStrategy(new ExecutionStrategyHolder(config.getExecutionStrategy()));
    }

    @Override
    public void updateSecurityConfig(SecurityScanConfig config) {
        this.setConfig(config);
        this.assertionsSupport.refresh();
        if (this.executionStrategy != null && config.getExecutionStrategy() != null) {
            this.executionStrategy.updateConfig(config.getExecutionStrategy());
        }
    }

    protected void initAssertions() {
        this.assertionsSupport = new AssertionsSupport(this, new AssertableConfig(){

            @Override
            public TestAssertionConfig addNewAssertion() {
                return ((SecurityScanConfig)AbstractSecurityScan.this.getConfig()).addNewAssertion();
            }

            @Override
            public List<TestAssertionConfig> getAssertionList() {
                return ((SecurityScanConfig)AbstractSecurityScan.this.getConfig()).getAssertionList();
            }

            @Override
            public void removeAssertion(int ix) {
                ((SecurityScanConfig)AbstractSecurityScan.this.getConfig()).removeAssertion(ix);
            }

            @Override
            public TestAssertionConfig insertAssertion(TestAssertionConfig source, int ix) {
                TestAssertionConfig conf = ((SecurityScanConfig)AbstractSecurityScan.this.getConfig()).insertNewAssertion(ix);
                conf.set(source);
                return conf;
            }
        });
    }

    @Override
    public SecurityScanResult run(TestStep testStep, SecurityTestRunContext context, SecurityTestRunner securityTestRunner) {
        this.securityScanResult = new SecurityScanResult(this);
        SecurityTestRunListener[] securityTestListeners = ((SecurityTest)this.getParent()).getSecurityTestRunListeners();
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        boolean noMutations = true;
        while (this.hasNext(testStep, context)) {
            noMutations = false;
            if (((SecurityTestRunnerImpl)securityTestRunner).isCanceled()) {
                this.securityScanResult.setStatus(SecurityResult.ResultStatus.CANCELED);
                this.clear();
                return this.securityScanResult;
            }
            this.securityScanRequestResult = new SecurityScanRequestResult(this);
            this.securityScanRequestResult.startTimer();
            this.originalTestStepClone = ((SecurityTestRunnerImpl)securityTestRunner).cloneForSecurityScan((WsdlTestStep)this.testStep);
            this.execute(securityTestRunner, this.originalTestStepClone, context);
            notifier.notifyChange();
            this.securityScanRequestResult.stopTimer();
            this.assertResponse(this.getSecurityScanRequestResult().getMessageExchange(), context);
            this.securityScanResult.addSecurityRequestResult(this.getSecurityScanRequestResult());
            for (int i = 0; i < securityTestListeners.length; ++i) {
                if (!Arrays.asList(((SecurityTest)this.getParent()).getSecurityTestRunListeners()).contains(securityTestListeners[i])) continue;
                securityTestListeners[i].afterSecurityScanRequest((SecurityTestRunnerImpl)securityTestRunner, context, this.securityScanRequestResult);
            }
            try {
                Thread.sleep(this.getExecutionStrategy().getDelay());
            }
            catch (InterruptedException e) {
                SoapUI.logError(e, "Security Scan Request Delay Interrupted!");
            }
        }
        if (noMutations) {
            this.securityScanResult.setStatus(SecurityResult.ResultStatus.SKIPPED);
        }
        return this.securityScanResult;
    }

    protected void clear() {
    }

    protected abstract void execute(SecurityTestRunner var1, TestStep var2, SecurityTestRunContext var3);

    protected abstract boolean hasNext(TestStep var1, SecurityTestRunContext var2);

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public JComponent getComponent() {
        return null;
    }

    @Override
    public abstract String getType();

    @Override
    public TestStep getTestStep() {
        return this.testStep;
    }

    @Override
    public void setTestStep(TestStep step) {
        this.testStep = step;
    }

    @Override
    public boolean isDisabled() {
        return ((SecurityScanConfig)this.getConfig()).getDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        boolean oldValue = this.isDisabled();
        ((SecurityScanConfig)this.getConfig()).setDisabled(disabled);
        this.pcs.firePropertyChange("disabled", oldValue, disabled);
    }

    public static boolean isSecurable(TestStep testStep) {
        return testStep != null && testStep instanceof Securable;
    }

    @Override
    public ExecutionStrategyHolder getExecutionStrategy() {
        return this.executionStrategy;
    }

    @Override
    public void setExecutionStrategy(ExecutionStrategyHolder executionStrategy) {
        ExecutionStrategyHolder oldValue = this.getExecutionStrategy();
        this.executionStrategy = executionStrategy;
        this.pcs.firePropertyChange("executionStrategy", oldValue, executionStrategy);
    }

    protected TestRequest getOriginalResult(SecurityTestRunnerImpl securityRunner, TestStep testStep) {
        testStep.run(securityRunner, (TestCaseRunContext)securityRunner.getRunContext());
        return this.getRequest(testStep);
    }

    protected TestRequest getRequest(TestStep testStep) {
        if (testStep instanceof SamplerTestStep) {
            return ((SamplerTestStep)testStep).getTestRequest();
        }
        return null;
    }

    @Override
    public TestAssertion addAssertion(String label) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion assertion = this.assertionsSupport.addWsdlAssertion(label);
            if (assertion == null) {
                return null;
            }
            if (this.getAssertableContentAsXml() != null) {
                this.assertRequests(assertion);
                this.assertResponses(assertion);
                notifier.notifyChange();
            }
            return assertion;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return null;
        }
    }

    private void assertResponses(WsdlMessageAssertion assertion) {
        if (this.securityScanResult != null) {
            for (SecurityScanRequestResult result : this.securityScanResult.getSecurityRequestResultList()) {
                if (result.getMessageExchange() == null) {
                    return;
                }
                assertion.assertResponse(result.getMessageExchange(), new WsdlSubmitContext(this.testStep));
            }
        }
    }

    private void assertRequests(WsdlMessageAssertion assertion) {
        if (this.securityScanResult != null) {
            for (SecurityScanRequestResult result : this.securityScanResult.getSecurityRequestResultList()) {
                if (result.getMessageExchange() == null) {
                    return;
                }
                assertion.assertRequest(result.getMessageExchange(), new WsdlSubmitContext(this.testStep));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAssertion(TestAssertion assertion) {
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            this.assertionsSupport.removeAssertion((WsdlMessageAssertion)assertion);
        }
        finally {
            ((WsdlMessageAssertion)assertion).release();
            notifier.notifyChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        WsdlMessageAssertion assertion = this.getAssertionAt(ix);
        PropertyChangeNotifier notifier = new PropertyChangeNotifier();
        try {
            WsdlMessageAssertion wsdlMessageAssertion = this.assertionsSupport.moveAssertion(ix, offset);
            return wsdlMessageAssertion;
        }
        finally {
            assertion.release();
            notifier.notifyChange();
        }
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int c) {
        return this.assertionsSupport.getAssertionAt(c);
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.addAssertionsListener(listener);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.assertionsSupport.removeAssertionsListener(listener);
    }

    @Override
    public int getAssertionCount() {
        return this.assertionsSupport.getAssertionCount();
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        int cnt = this.getAssertionCount();
        if (cnt == 0) {
            return this.currentStatus;
        }
        this.currentStatus = this.securityScanResult != null && this.securityScanResult.getStatus() == SecurityResult.ResultStatus.OK ? Assertable.AssertionStatus.VALID : Assertable.AssertionStatus.FAILED;
        return this.currentStatus;
    }

    public SecurityResult.ResultStatus getSecurityStatus() {
        return this.securityScanResult != null ? this.securityScanResult.getStatus() : SecurityResult.ResultStatus.UNKNOWN;
    }

    @Override
    public String getAssertableContentAsXml() {
        if (this.testStep instanceof Assertable) {
            return ((Assertable)((Object)this.testStep)).getAssertableContentAsXml();
        }
        return null;
    }

    @Override
    public String getAssertableContent() {
        if (this.testStep instanceof Assertable) {
            return ((Assertable)((Object)this.testStep)).getAssertableContent();
        }
        return null;
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return TestAssertionRegistry.AssertableType.BOTH;
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.assertionsSupport.getAssertionByName(name);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return new ArrayList<TestAssertion>(this.assertionsSupport.getAssertionList());
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.assertionsSupport.getAssertions();
    }

    public AssertionsSupport getAssertionsSupport() {
        return this.assertionsSupport;
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.assertionsSupport.cloneAssertion(source, name);
    }

    @Override
    public String getDefaultAssertableContent() {
        if (this.testStep instanceof Assertable) {
            return ((Assertable)((Object)this.testStep)).getDefaultAssertableContent();
        }
        return null;
    }

    @Override
    public Interface getInterface() {
        if (this.testStep instanceof WsdlTestRequestStep) {
            return ((WsdlTestRequestStep)this.testStep).getInterface();
        }
        return null;
    }

    @Override
    public ModelItem getModelItem() {
        return this;
    }

    @Override
    public Assertable.AssertionStatus assertResponse(MessageExchange messageExchange, SubmitContext context) {
        Assertable.AssertionStatus finalResult = null;
        try {
            PropertyChangeNotifier notifier = new PropertyChangeNotifier();
            if (messageExchange != null) {
                context.setProperty("SecurityScanRequestResult", this.getSecurityScanRequestResult());
                for (WsdlMessageAssertion assertion : this.assertionsSupport.getAssertionList()) {
                    Assertable.AssertionStatus currentResult = assertion.assertResponse(messageExchange, context);
                    this.updateMessages(currentResult, assertion);
                    if (finalResult != null && finalResult == Assertable.AssertionStatus.FAILED) continue;
                    finalResult = currentResult;
                }
                this.setStatus(finalResult);
                notifier.notifyChange();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalResult;
    }

    private void setStatus(Assertable.AssertionStatus result) {
        if (result == Assertable.AssertionStatus.FAILED) {
            this.getSecurityScanRequestResult().setStatus(SecurityResult.ResultStatus.FAILED);
        } else if (result == Assertable.AssertionStatus.VALID) {
            this.getSecurityScanRequestResult().setStatus(SecurityResult.ResultStatus.OK);
        } else if (result == Assertable.AssertionStatus.UNKNOWN) {
            this.getSecurityScanRequestResult().setStatus(SecurityResult.ResultStatus.UNKNOWN);
        }
    }

    private void updateMessages(Assertable.AssertionStatus result, WsdlMessageAssertion assertion) {
        if (result == Assertable.AssertionStatus.FAILED) {
            for (AssertionError error : assertion.getErrors()) {
                this.getSecurityScanRequestResult().addMessage(error.getMessage());
            }
        }
    }

    @Override
    public abstract String getConfigName();

    @Override
    public abstract String getConfigDescription();

    @Override
    public abstract String getHelpURL();

    protected void setSecurityScanRequestResult(SecurityScanRequestResult securityScanRequestResult) {
        this.securityScanRequestResult = securityScanRequestResult;
    }

    protected SecurityScanRequestResult getSecurityScanRequestResult() {
        return this.securityScanRequestResult;
    }

    @Override
    public JComponent getAdvancedSettingsPanel() {
        return null;
    }

    @Override
    public SecurityScanResult getSecurityScanResult() {
        return this.securityScanResult;
    }

    protected void reportSecurityScanException(String message) {
        this.getSecurityScanRequestResult().setMessageExchange(new FailedSecurityMessageExchange());
        this.getSecurityScanRequestResult().setStatus(SecurityResult.ResultStatus.FAILED);
        this.getSecurityScanRequestResult().addMessage(message);
    }

    @Override
    public void addWsdlAssertion(String assertionLabel) {
        this.assertionsSupport.addWsdlAssertion(assertionLabel);
    }

    @Override
    public boolean isApplyForFailedStep() {
        return ((SecurityScanConfig)this.getConfig()).getApplyForFailedStep();
    }

    @Override
    public void setApplyForFailedTestStep(boolean apply) {
        ((SecurityScanConfig)this.getConfig()).setApplyForFailedStep(apply);
    }

    @Override
    public boolean isRunOnlyOnce() {
        return ((SecurityScanConfig)this.getConfig()).getRunOnlyOnce();
    }

    @Override
    public void setRunOnlyOnce(boolean runOnlyOnce) {
        ((SecurityScanConfig)this.getConfig()).setRunOnlyOnce(runOnlyOnce);
    }

    @Override
    public void release() {
        if (this.assertionsSupport != null) {
            this.assertionsSupport.release();
        }
        if (this.securityScanResult != null) {
            this.securityScanResult.release();
        }
        if (this.securityScanRequestResult != null) {
            this.securityScanRequestResult.release();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Override
    public boolean isSkipFurtherRunning() {
        return this.skipFurtherRunning;
    }

    @Override
    public void setSkipFurtherRunning(boolean skipFurtherRunning) {
        this.skipFurtherRunning = skipFurtherRunning;
    }

    private class PropertyChangeNotifier {
        private SecurityResult.ResultStatus oldStatus;

        public PropertyChangeNotifier() {
            this.oldStatus = AbstractSecurityScan.this.getSecurityStatus();
        }

        public void notifyChange() {
            SecurityResult.ResultStatus newStatus = AbstractSecurityScan.this.getSecurityStatus();
            if (this.oldStatus != newStatus) {
                AbstractSecurityScan.this.notifyPropertyChanged(SecurityScan.STATUS_PROPERTY, (Object)this.oldStatus, (Object)newStatus);
            }
            this.oldStatus = newStatus;
        }
    }
}

