/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.registry;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.SecurityScanConfig;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.security.registry.BoundarySecurityScanFactory;
import com.eviware.soapui.security.registry.CrossSiteScriptingScanFactory;
import com.eviware.soapui.security.registry.FuzzerSecurityScanFactory;
import com.eviware.soapui.security.registry.GroovySecurityScanFactory;
import com.eviware.soapui.security.registry.InvalidTypesSecurityScanFactory;
import com.eviware.soapui.security.registry.MalformedXmlSecurityScanFactory;
import com.eviware.soapui.security.registry.MaliciousAttachmentSecurityScanFactory;
import com.eviware.soapui.security.registry.SQLInjectionScanFactory;
import com.eviware.soapui.security.registry.SecurityScanFactory;
import com.eviware.soapui.security.registry.XPathInjectionSecurityScanFactory;
import com.eviware.soapui.security.registry.XmlBombSecurityScanFactory;
import com.eviware.soapui.security.ui.SecurityConfigurationDialogBuilder;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SecurityScanRegistry {
    protected static SecurityScanRegistry instance;
    private Map<String, SecurityScanFactory> availableSecurityChecks = new HashMap<String, SecurityScanFactory>();
    private StringToStringMap securityCheckNames = new StringToStringMap();

    public SecurityScanRegistry() {
        this.addFactory(new GroovySecurityScanFactory());
        this.addFactory(new CrossSiteScriptingScanFactory());
        this.addFactory(new XmlBombSecurityScanFactory());
        this.addFactory(new MaliciousAttachmentSecurityScanFactory());
        this.addFactory(new XPathInjectionSecurityScanFactory());
        this.addFactory(new InvalidTypesSecurityScanFactory());
        this.addFactory(new BoundarySecurityScanFactory());
        this.addFactory(new SQLInjectionScanFactory());
        this.addFactory(new MalformedXmlSecurityScanFactory());
        this.addFactory(new FuzzerSecurityScanFactory());
        for (SecurityScanFactory factory : SoapUI.getFactoryRegistry().getFactories(SecurityScanFactory.class)) {
            this.addFactory(factory);
        }
    }

    public SecurityScanFactory getFactory(String type) {
        for (String cc : this.availableSecurityChecks.keySet()) {
            SecurityScanFactory scf = this.availableSecurityChecks.get(cc);
            if (!scf.getSecurityScanType().equals(type)) continue;
            return scf;
        }
        return null;
    }

    public SecurityScanFactory getFactoryByName(String name) {
        String type = this.getSecurityScanTypeForName(name);
        if (type != null) {
            return this.getFactory(type);
        }
        return null;
    }

    public void addFactory(SecurityScanFactory factory) {
        this.removeFactory(factory.getSecurityScanType());
        this.availableSecurityChecks.put(factory.getSecurityScanName(), factory);
        this.securityCheckNames.put(factory.getSecurityScanName(), factory.getSecurityScanType());
    }

    public void removeFactory(String type) {
        for (String scfName : this.availableSecurityChecks.keySet()) {
            SecurityScanFactory csf = this.availableSecurityChecks.get(scfName);
            if (!csf.getSecurityScanType().equals(type)) continue;
            this.availableSecurityChecks.remove(scfName);
            this.securityCheckNames.remove(scfName);
            break;
        }
    }

    public static synchronized SecurityScanRegistry getInstance() {
        if (instance == null) {
            instance = new SecurityScanRegistry();
        }
        return instance;
    }

    public boolean hasFactory(SecurityScanConfig config) {
        return this.getFactory(config.getType()) != null;
    }

    public String[] getAvailableSecurityScansNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (SecurityScanFactory securityCheck : this.availableSecurityChecks.values()) {
            result.add(securityCheck.getSecurityScanName());
        }
        Object[] sortedResult = result.toArray(new String[result.size()]);
        Arrays.sort(sortedResult);
        return sortedResult;
    }

    public String[] getAvailableSecurityScansNames(TestStep testStep) {
        ArrayList<String> result = new ArrayList<String>();
        for (SecurityScanFactory securityCheck : this.availableSecurityChecks.values()) {
            if (!securityCheck.canCreate(testStep)) continue;
            result.add(securityCheck.getSecurityScanName());
        }
        Object[] sortedResult = result.toArray(new String[result.size()]);
        Arrays.sort(sortedResult);
        return sortedResult;
    }

    public SecurityConfigurationDialogBuilder getUIBuilder() {
        return new SecurityConfigurationDialogBuilder();
    }

    public String getSecurityScanTypeForName(String name) {
        return (String)this.securityCheckNames.get(name);
    }
}

