/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.boundary;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.security.boundary.BoundaryUtils;
import com.eviware.soapui.support.xml.XmlObjectTreeModel;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlException;

public class EnumerationValuesExtractor {
    private WsdlRequest request;
    private List<String> selectedEnumerationParameters = new ArrayList<String>();
    private XmlObjectTreeModel model;

    public EnumerationValuesExtractor(WsdlTestRequest request) {
        this.request = request;
        try {
            this.model = new XmlObjectTreeModel(request.getOperation().getInterface().getDefinitionContext().getSchemaTypeSystem(), XmlUtils.createXmlObject(request.getRequestContent()));
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public String extract() throws XmlException, Exception {
        this.getNextChild(this.model.getRootNode());
        return this.model.getXmlObject().toString();
    }

    private void getNextChild(XmlObjectTreeModel.XmlTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            XmlObjectTreeModel.XmlTreeNode mynode = node.getChild(i);
            if (mynode.getSchemaType() != null && mynode.getSchemaType().getEnumerationValues() != null && mynode.getSchemaType().getEnumerationValues().length > 0) {
                EnumerationValues nodeInfo = new EnumerationValues(mynode.getSchemaType().getBaseType().getShortJavaName());
                for (XmlAnySimpleType s : mynode.getSchemaType().getEnumerationValues()) {
                    nodeInfo.addValue(s.getStringValue());
                }
                this.updateNodeValue(mynode, nodeInfo);
            }
            this.getNextChild(mynode);
        }
    }

    private void updateNodeValue(XmlObjectTreeModel.XmlTreeNode mynode, EnumerationValues enumerationValues) {
        if (!this.selectedEnumerationParameters.contains(mynode.getDomNode().getLocalName())) {
            return;
        }
        int size = this.maxLengthStringSize(enumerationValues.getValuesList());
        String value = this.createOutOfBoundaryValue(enumerationValues, size);
        if (value != null) {
            mynode.setValue(1, value);
        }
    }

    private String createOutOfBoundaryValue(EnumerationValues enumValues, int size) {
        if ("XmlString".equals(enumValues.getType())) {
            String value = null;
            do {
                value = BoundaryUtils.createCharacterArray(" abcdefghijklmnopqrstuvwxyz\n\t\r", size);
            } while (enumValues.getValuesList().contains(value));
            return value;
        }
        return null;
    }

    private int maxLengthStringSize(Collection<String> values) {
        int max = 0;
        for (String str : values) {
            if (max >= str.length()) continue;
            max = str.length();
        }
        return max;
    }

    public void setSelectedEnumerationParameters(List<String> selectedEnumerationParameters) {
        this.selectedEnumerationParameters = selectedEnumerationParameters;
    }

    public List<String> getSelectedEnumerationParameters() {
        return this.selectedEnumerationParameters;
    }

    class EnumerationValues {
        private String type;
        private List<String> valuesList = new ArrayList<String>();

        public EnumerationValues(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void addValue(String value) {
            this.valuesList.add(value);
        }

        public List<String> getValuesList() {
            return this.valuesList;
        }
    }
}

