/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.report;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestCaseRunLogDocumentConfig;
import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TestCaseRunLogReport
extends TestRunListenerAdapter {
    private static final String TEST_CASE_RUN_WAS_TERMINATED_UNEXPECTEDLY_MESSAGE = "TestCase run was terminated unexpectedly";
    private static final String TIMEOUT_STATUS = "TIMEOUT";
    private static final String TIMEOUT_MESSAGE = "The TestStep was interrupted due to a timeout";
    private static final String REPORT_FILE_NAME = "test_case_run_log_report.xml";
    private TestCaseRunLogDocumentConfig testCaseRunLogDocumentConfig;
    private TestCaseRunLogDocumentConfig.TestCaseRunLog testCaseRunLog;
    private final String outputFolder;
    private long startTime;
    private static final Logger log = Logger.getLogger(TestCaseRunLogReport.class);
    private boolean testRunHasFinished = false;
    private TestStep currentTestStep;
    private TestCaseRunLogDocumentConfig.TestCaseRunLog.TestCaseRunLogTestStep currentTestCaseRunLogTestStepConfig;

    public TestCaseRunLogReport(String outputFolder) {
        this.outputFolder = outputFolder;
        this.testCaseRunLogDocumentConfig = TestCaseRunLogDocumentConfig.Factory.newInstance();
        this.testCaseRunLog = this.testCaseRunLogDocumentConfig.addNewTestCaseRunLog();
        this.initShutDownHook();
    }

    @Override
    public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
        this.currentTestStep = testStep;
        this.currentTestCaseRunLogTestStepConfig = this.testCaseRunLog.addNewTestCaseRunLogTestStep();
    }

    @Override
    public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
        Throwable error;
        this.currentTestCaseRunLogTestStepConfig.setName(result.getTestStep().getName());
        this.currentTestCaseRunLogTestStepConfig.setTimeTaken(Long.toString(result.getTimeTaken()));
        this.currentTestCaseRunLogTestStepConfig.setStatus(result.getStatus().toString());
        this.currentTestCaseRunLogTestStepConfig.setMessageArray(result.getMessages());
        this.currentTestCaseRunLogTestStepConfig.setTimestamp(SoapUIMetrics.formatTimestamp(result.getTimeStamp()));
        ExtendedHttpMethod httpMethod = (ExtendedHttpMethod)runContext.getProperty("httpMethod");
        if (httpMethod != null && result.getTestStep() instanceof HttpRequestTestStep) {
            this.currentTestCaseRunLogTestStepConfig.setEndpoint(httpMethod.getURI().toString());
            SoapUIMetrics metrics = httpMethod.getMetrics();
            this.currentTestCaseRunLogTestStepConfig.setTimestamp(metrics.getFormattedTimeStamp());
            this.currentTestCaseRunLogTestStepConfig.setHttpStatus(String.valueOf(metrics.getHttpStatus()));
            this.currentTestCaseRunLogTestStepConfig.setContentLength(String.valueOf(metrics.getContentLength()));
            this.currentTestCaseRunLogTestStepConfig.setReadTime(String.valueOf(metrics.getReadTimer().getDuration()));
            this.currentTestCaseRunLogTestStepConfig.setTotalTime(String.valueOf(metrics.getTotalTimer().getDuration()));
            this.currentTestCaseRunLogTestStepConfig.setDnsTime(String.valueOf(metrics.getDNSTimer().getDuration()));
            this.currentTestCaseRunLogTestStepConfig.setConnectTime(String.valueOf(metrics.getConnectTimer().getDuration()));
            this.currentTestCaseRunLogTestStepConfig.setTimeToFirstByte(String.valueOf(metrics.getTimeToFirstByteTimer().getDuration()));
            this.currentTestCaseRunLogTestStepConfig.setHttpMethod(metrics.getHttpMethod());
            this.currentTestCaseRunLogTestStepConfig.setIpAddress(metrics.getIpAddress());
        }
        if ((error = result.getError()) != null) {
            this.currentTestCaseRunLogTestStepConfig.setErrorMessage(error.getMessage());
        }
    }

    @Override
    public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        this.testCaseRunLog.setTestCase(testRunner.getTestCase().getName());
        this.testCaseRunLog.setTimeTaken(Long.toString(testRunner.getTimeTaken()));
        this.testCaseRunLog.setStatus(testRunner.getStatus().toString());
        this.testCaseRunLog.setTimeStamp(SoapUIMetrics.formatTimestamp(this.startTime));
        this.testRunHasFinished = true;
        this.saveReportToFile();
    }

    @Override
    public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
        super.beforeRun(testRunner, runContext);
        this.startTime = System.currentTimeMillis();
    }

    private void initShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!TestCaseRunLogReport.this.testRunHasFinished) {
                    if (TestCaseRunLogReport.this.currentTestCaseRunLogTestStepConfig != null) {
                        log.warn((Object)("Step [" + TestCaseRunLogReport.this.currentTestStep.getName() + "] was interrupted due to a timeout"));
                        TestCaseRunLogReport.this.currentTestCaseRunLogTestStepConfig.setName(TestCaseRunLogReport.this.currentTestStep.getName());
                        TestCaseRunLogReport.this.currentTestCaseRunLogTestStepConfig.setStatus(TestCaseRunLogReport.TIMEOUT_STATUS);
                        TestCaseRunLogReport.this.currentTestCaseRunLogTestStepConfig.setMessageArray(new String[]{TestCaseRunLogReport.TIMEOUT_MESSAGE});
                    }
                    log.warn((Object)TestCaseRunLogReport.TEST_CASE_RUN_WAS_TERMINATED_UNEXPECTEDLY_MESSAGE);
                    TestCaseRunLogReport.this.saveReportToFile();
                }
            }
        });
    }

    private void saveReportToFile() {
        File newFile = new File(this.outputFolder, REPORT_FILE_NAME);
        try {
            this.testCaseRunLogDocumentConfig.save(newFile);
        }
        catch (IOException e) {
            log.error((Object)"Could not write test_case_run_log_report.xml to disk");
            SoapUI.logError(e);
        }
    }
}

