/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.plugins;

import com.eviware.soapui.plugins.PluginId;
import com.eviware.soapui.plugins.PluginInfo;
import com.eviware.soapui.plugins.PluginLoader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PluginDependencyResolver {
    private final Map<PluginInfo, File> infoToFileMap = new HashMap<PluginInfo, File>();

    public PluginDependencyResolver(PluginLoader pluginLoader, Iterable<File> pluginFiles) throws IOException {
        for (File pluginFile : pluginFiles) {
            this.infoToFileMap.put(pluginLoader.loadPluginInfoFrom(pluginFile, Collections.emptySet()), pluginFile);
        }
    }

    public List<File> determineLoadOrder() throws IOException {
        ArrayList<PluginInfo> infoList = new ArrayList<PluginInfo>(this.infoToFileMap.keySet());
        Collections.sort(infoList, new PluginDependencyComparator());
        ArrayList<File> resultList = new ArrayList<File>();
        for (PluginInfo pluginInfo : infoList) {
            resultList.add(this.infoToFileMap.get(pluginInfo));
        }
        return resultList;
    }

    public Collection<PluginInfo> findAllDependencies(PluginInfo plugin) {
        HashSet<PluginInfo> allDependencies = new HashSet<PluginInfo>();
        for (PluginInfo dependency : plugin.getDependencies()) {
            PluginInfo realDependency = this.findDependency(dependency.getId());
            if (realDependency == null) continue;
            allDependencies.add(realDependency);
            allDependencies.addAll(this.findAllDependencies(realDependency));
        }
        return allDependencies;
    }

    private PluginInfo findDependency(PluginId id) {
        for (PluginInfo plugin : this.infoToFileMap.keySet()) {
            if (!plugin.getId().equals(id)) continue;
            return plugin;
        }
        return null;
    }

    public Collection<PluginInfo> findAllDependencies(File pluginFile) {
        for (Map.Entry<PluginInfo, File> entry : this.infoToFileMap.entrySet()) {
            if (!entry.getValue().equals(pluginFile)) continue;
            return this.findAllDependencies(entry.getKey());
        }
        return Collections.emptySet();
    }

    public void addPlugin(PluginInfo rootPlugin, File readytest) {
        this.infoToFileMap.put(rootPlugin, readytest);
    }

    public void removePlugin(PluginInfo pluginId) {
        this.infoToFileMap.remove(pluginId);
    }

    public List<PluginInfo> getPluginInfoListFromFiles(List<File> files) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        block0: for (File file : files) {
            for (Map.Entry<PluginInfo, File> entry : this.infoToFileMap.entrySet()) {
                if (!entry.getValue().equals(file)) continue;
                result.add(entry.getKey());
                continue block0;
            }
        }
        return result;
    }

    private class PluginDependencyComparator
    implements Comparator<PluginInfo> {
        private PluginDependencyComparator() {
        }

        @Override
        public int compare(PluginInfo first, PluginInfo second) {
            if (first.getDependencies().isEmpty()) {
                return -1;
            }
            if (second.getDependencies().isEmpty()) {
                return 1;
            }
            if (this.dependsOn(first, second)) {
                return 1;
            }
            if (this.dependsOn(second, first)) {
                return -1;
            }
            return 0;
        }

        private boolean dependsOn(PluginInfo first, PluginInfo second) {
            return PluginDependencyResolver.this.findAllDependencies(first).contains(second);
        }
    }
}

