/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.impl.wsdl.MutableTestPropertyHolder;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.TestModelItem;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.PropertyTreeNode;
import com.eviware.soapui.model.tree.nodes.support.EmptyModelItem;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

public class PropertiesTreeNode<T extends ModelItem>
extends AbstractModelItemTreeNode<T> {
    private List<PropertyTreeNode> propertyNodes = new ArrayList<PropertyTreeNode>();
    private Map<String, PropertyTreeNode> propertyMap = new HashMap<String, PropertyTreeNode>();
    private InternalTestPropertyListener testPropertyListener;
    private final TestPropertyHolder holder;

    public PropertiesTreeNode(T modelItem, ModelItem parentItem, TestPropertyHolder holder, SoapUITreeModel treeModel) {
        super(modelItem, parentItem, treeModel);
        this.holder = holder;
        for (String name : holder.getPropertyNames()) {
            PropertyTreeNode propertyTreeNode = new PropertyTreeNode(holder.getProperty(name), (ModelItem)this.getModelItem(), holder, treeModel);
            this.propertyNodes.add(propertyTreeNode);
            this.propertyMap.put(name, propertyTreeNode);
            this.getTreeModel().mapModelItem(propertyTreeNode);
        }
        this.testPropertyListener = new InternalTestPropertyListener();
        holder.addTestPropertyListener(this.testPropertyListener);
    }

    public static PropertiesTreeNode<?> createDefaultPropertiesNode(TestModelItem modelItem, SoapUITreeModel treeModel) {
        return new PropertiesTreeNode<PropertiesModelItem>(new PropertiesModelItem(modelItem), modelItem, modelItem, treeModel);
    }

    @Override
    public int getChildCount() {
        return this.getTreeModel().isShowProperties() ? this.propertyNodes.size() : 0;
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.propertyNodes.get(index);
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.propertyNodes.indexOf(child);
    }

    @Override
    public void release() {
        super.release();
        this.holder.removeTestPropertyListener(this.testPropertyListener);
        for (PropertyTreeNode node : this.propertyNodes) {
            this.getTreeModel().unmapModelItem((ModelItem)node.getModelItem());
        }
        this.propertyNodes.clear();
        this.propertyMap.clear();
    }

    @Override
    public ActionList getActions() {
        if (this.getModelItem() instanceof PropertiesModelItem && this.holder instanceof MutableTestPropertyHolder) {
            DefaultActionList actions = new DefaultActionList();
            actions.addAction(new AddPropertyAction());
            return actions;
        }
        return super.getActions();
    }

    private class AddPropertyAction
    extends AbstractAction {
        public AddPropertyAction() {
            super("Add Property");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add.png"));
            this.putValue("ShortDescription", "Adds a property to the property list");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify unique property name", "Add Property", "");
            if (StringUtils.hasContent(name)) {
                if (PropertiesTreeNode.this.holder.hasProperty(name)) {
                    UISupport.showErrorMessage("Property name [" + name + "] already exists..");
                    return;
                }
                ((MutableTestPropertyHolder)PropertiesTreeNode.this.holder).addProperty(name);
            }
        }
    }

    public static class PropertiesModelItem
    extends EmptyModelItem {
        private final TestPropertyHolder holder;

        public PropertiesModelItem(TestPropertyHolder holder) {
            super("Properties (" + holder.getPropertyNames().length + ")", UISupport.createImageIcon("/properties_step.png"));
            this.holder = holder;
        }

        public void updateName() {
            this.setName("Properties (" + this.holder.getPropertyNames().length + ")");
        }
    }

    private class InternalTestPropertyListener
    implements TestPropertyListener {
        private InternalTestPropertyListener() {
        }

        @Override
        public void propertyAdded(String name) {
            PropertyTreeNode propertyTreeNode = new PropertyTreeNode(PropertiesTreeNode.this.holder.getProperty(name), (ModelItem)PropertiesTreeNode.this.getModelItem(), PropertiesTreeNode.this.holder, PropertiesTreeNode.this.getTreeModel());
            PropertiesTreeNode.this.propertyNodes.add(propertyTreeNode);
            PropertiesTreeNode.this.propertyMap.put(name, propertyTreeNode);
            PropertiesTreeNode.this.getTreeModel().notifyNodeInserted(propertyTreeNode);
            if (PropertiesTreeNode.this.getModelItem() instanceof PropertiesModelItem) {
                ((PropertiesModelItem)PropertiesTreeNode.this.getModelItem()).updateName();
            }
        }

        @Override
        public void propertyRemoved(String name) {
            SoapUITreeNode treeNode = PropertiesTreeNode.this.getTreeModel().getTreeNode((ModelItem)((PropertyTreeNode)PropertiesTreeNode.this.propertyMap.get(name)).getModelItem());
            if (PropertiesTreeNode.this.propertyNodes.contains(treeNode)) {
                PropertiesTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
                PropertiesTreeNode.this.propertyNodes.remove(treeNode);
                PropertiesTreeNode.this.propertyMap.remove(name);
                if (PropertiesTreeNode.this.getModelItem() instanceof PropertiesModelItem) {
                    ((PropertiesModelItem)PropertiesTreeNode.this.getModelItem()).updateName();
                }
            } else {
                throw new RuntimeException("Removing unkown property");
            }
        }

        @Override
        public void propertyRenamed(String oldName, String newName) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)PropertiesTreeNode.this.propertyMap.remove(oldName);
            PropertiesTreeNode.this.propertyMap.put(newName, propertyTreeNode);
            ((PropertyTreeNode.PropertyModelItem)propertyTreeNode.getModelItem()).setName(PropertyTreeNode.buildName(PropertiesTreeNode.this.holder.getProperty(newName)));
        }

        @Override
        public void propertyValueChanged(String name, String oldValue, String newValue) {
            PropertyTreeNode propertyTreeNode = (PropertyTreeNode)PropertiesTreeNode.this.propertyMap.get(name);
            if (propertyTreeNode != null) {
                ((PropertyTreeNode.PropertyModelItem)propertyTreeNode.getModelItem()).setName(PropertyTreeNode.buildName(PropertiesTreeNode.this.holder.getProperty(name)));
            }
        }

        @Override
        public void propertyMoved(String name, int oldIndex, int newIndex) {
            PropertyTreeNode node = (PropertyTreeNode)PropertiesTreeNode.this.propertyNodes.get(oldIndex);
            PropertiesTreeNode.this.getTreeModel().notifyNodeRemoved(node, false);
            PropertiesTreeNode.this.propertyNodes.remove(oldIndex);
            if (newIndex >= PropertiesTreeNode.this.propertyNodes.size()) {
                PropertiesTreeNode.this.propertyNodes.add(node);
            } else {
                PropertiesTreeNode.this.propertyNodes.add(newIndex, node);
            }
            PropertiesTreeNode.this.getTreeModel().notifyNodeInserted(node);
        }
    }
}

