/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.support.MessageSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import org.apache.xmlbeans.XmlObject;

public class ResponseSLAAssertion
extends WsdlMessageAssertion
implements ResponseAssertion {
    public static final MessageSupport messages = MessageSupport.getMessages(ResponseSLAAssertion.class);
    public static final String ID = "Response SLA Assertion";
    public static final String LABEL = "Response SLA";
    public static final String DESCRIPTION = "Validates that the last received response time was within the defined limit. Applicable to Script TestSteps and TestSteps that send requests and receive responses.";
    private String SLA;
    private static final String SLA_VALUE_IS_NOT_NUMBER = messages.get("ResponseSLAAssertion.InfoNotNumber");
    private static final String SLA_VALUE_IS_EMPTY = messages.get("ResponseSLAAssertion.InfoEmptyValue");
    private static final String FORM_TITLE = messages.get("ResponseSLAAssertion.Form.Title");
    private static final String FORM_DESCRIPTION = messages.get("ResponseSLAAssertion.Form.Description");

    public ResponseSLAAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, false, true, false, false);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.SLA = reader.readString("SLA", "200");
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        Long timeExecuted;
        Response response = messageExchange.getResponse();
        long timeTaken = response == null ? messageExchange.getTimeTaken() : response.getTimeTaken();
        String propertyValue = null;
        try {
            propertyValue = PropertyExpander.expandProperties(context, this.SLA.trim());
            timeExecuted = Long.parseLong(propertyValue);
        }
        catch (NumberFormatException exp) {
            if (!StringUtils.isNullOrEmpty(this.SLA)) {
                if (!StringUtils.isNullOrEmpty(propertyValue)) {
                    throw new AssertionException(new AssertionError(String.format(SLA_VALUE_IS_NOT_NUMBER, propertyValue)));
                }
                throw new AssertionException(new AssertionError(String.format(SLA_VALUE_IS_NOT_NUMBER, this.SLA)));
            }
            throw new AssertionException(new AssertionError(SLA_VALUE_IS_EMPTY));
        }
        if (timeTaken > timeExecuted) {
            throw new AssertionException(new AssertionError("Response did not meet SLA " + timeTaken + "/" + timeExecuted));
        }
        return "Response meets SLA";
    }

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    @Override
    public boolean configure() {
        String sla;
        String value = this.getSLA();
        if (StringUtils.isNullOrEmpty(value)) {
            value = "200";
        }
        if ((sla = UISupport.prompt(messages.get(FORM_DESCRIPTION), messages.get(FORM_TITLE), value)) == null) {
            return false;
        }
        this.setSLA(sla);
        return true;
    }

    public String getSLA() {
        return this.SLA;
    }

    public void setSLA(String sla) {
        this.SLA = sla;
        this.setConfiguration(this.createConfiguration());
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        return builder.add("SLA", this.SLA).finish();
    }

    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(ResponseSLAAssertion.ID, ResponseSLAAssertion.LABEL, ResponseSLAAssertion.class);
        }

        @Override
        public String getCategory() {
            return "SLA";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return ResponseSLAAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(ResponseSLAAssertion.ID, ResponseSLAAssertion.LABEL, ResponseSLAAssertion.DESCRIPTION);
        }
    }
}

