/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.basic.AssertionConfigurationDialog;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.support.XPathReferenceContainer;
import com.eviware.soapui.model.support.XPathReferenceImpl;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.types.StringList;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.ArrayList;
import javax.swing.JTextArea;
import org.apache.xmlbeans.XmlObject;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceEngine;
import org.custommonkey.xmlunit.DifferenceListener;
import org.w3c.dom.Node;

public abstract class AbstractXmlContainsAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion,
XPathReferenceContainer {
    protected String expectedContent;
    protected String path;
    protected boolean allowWildcards;
    protected boolean ignoreNamespaceDifferences;
    protected boolean ignoreComments;
    protected AssertionConfigurationDialog configurationDialog;

    protected AbstractXmlContainsAssertion(TestAssertionConfig assertionConfig, Assertable modelItem, boolean cloneable, boolean configurable, boolean multiple, boolean requiresResponseContent) {
        super(assertionConfig, modelItem, cloneable, configurable, multiple, requiresResponseContent);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.path = reader.readString("path", null);
        this.expectedContent = reader.readString("content", null);
        this.allowWildcards = reader.readBoolean("allowWildcards", false);
        this.ignoreNamespaceDifferences = reader.readBoolean("ignoreNamspaceDifferences", false);
        this.ignoreComments = reader.readBoolean("ignoreComments", false);
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.setExpectedContent(expectedContent, true);
    }

    protected void setExpectedContent(String expectedContent, boolean save) {
        this.expectedContent = expectedContent;
        if (save) {
            this.setConfiguration(this.createConfiguration());
        }
    }

    @Deprecated
    public void setContent(String content) {
        this.setExpectedContent(content);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isAllowWildcards() {
        return this.allowWildcards;
    }

    public void setAllowWildcards(boolean allowWildcards) {
        this.allowWildcards = allowWildcards;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreNamespaceDifferences() {
        return this.ignoreNamespaceDifferences;
    }

    public void setIgnoreNamespaceDifferences(boolean ignoreNamespaceDifferences) {
        this.ignoreNamespaceDifferences = ignoreNamespaceDifferences;
        this.setConfiguration(this.createConfiguration());
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
        this.setConfiguration(this.createConfiguration());
    }

    public XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        this.addConfigurationValues(builder);
        return builder.finish();
    }

    protected void addConfigurationValues(XmlObjectConfigurationBuilder builder) {
        builder.add("path", this.path);
        builder.add("content", this.expectedContent);
        builder.add("allowWildcards", this.allowWildcards);
        builder.add("ignoreNamspaceDifferences", this.ignoreNamespaceDifferences);
        builder.add("ignoreComments", this.ignoreComments);
    }

    protected JTextArea getPathArea() {
        return this.configurationDialog == null ? null : this.configurationDialog.getPathArea();
    }

    protected JTextArea getContentArea() {
        return this.configurationDialog == null ? null : this.configurationDialog.getContentArea();
    }

    @Override
    public boolean configure() {
        if (this.configurationDialog == null) {
            this.configurationDialog = new AssertionConfigurationDialog(this.getAssertion());
        }
        return this.configurationDialog.configure();
    }

    protected AbstractXmlContainsAssertion getAssertion() {
        return this;
    }

    @Override
    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasResponse()) {
            return "Missing Response";
        }
        return this.assertContent(messageExchange.getResponseContentAsXml(), context, "Response");
    }

    public abstract String assertContent(String var1, SubmitContext var2, String var3) throws AssertionException;

    @Override
    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!XmlUtils.seemsToBeXml(source.getPropertyValue(propertyName))) {
            throw new AssertionException(new AssertionError("Property '" + propertyName + "' has value which is not xml!"));
        }
        return this.assertContent(source.getPropertyValue(propertyName), context, propertyName);
    }

    @Override
    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        if (!messageExchange.hasRequest(true)) {
            return "Missing Request";
        }
        return this.assertContent(messageExchange.getRequestContent(), context, "Request");
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        ArrayList<PropertyExpansion> result = new ArrayList<PropertyExpansion>();
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "expectedContent"));
        result.addAll(PropertyExpansionUtils.extractPropertyExpansions(this.getAssertable().getModelItem(), this, "path"));
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    public String getPathAreaTitle() {
        return "Specify " + this.getQueryType() + " expression and expected result";
    }

    public String getPathAreaDescription() {
        return "declare namespaces with <code>declare namespace &lt;prefix&gt;='&lt;namespace&gt;';</code>";
    }

    public String getPathAreaToolTipText() {
        return "Specifies the " + this.getQueryType() + " expression to select from the message for validation";
    }

    public String getPathAreaBorderTitle() {
        return this.getQueryType() + " Expression";
    }

    public String getContentAreaToolTipText() {
        return "Specifies the expected result of the " + this.getQueryType() + " expression";
    }

    public String getConfigurationDialogTitle() {
        return this.getQueryType() + " Match Configuration";
    }

    public String getContentAreaBorderTitle() {
        return "Expected Result";
    }

    public boolean canAssertXmlContent() {
        return true;
    }

    protected void addMatchEditorActions(JXToolBar toolbar) {
        this.configurationDialog.addMatchEditorActions(toolbar);
    }

    protected void addPathEditorActions(JXToolBar toolbar) {
        this.configurationDialog.addDeclareNamespaceButton(toolbar);
    }

    public abstract void selectFromCurrent();

    protected abstract String getQueryType();

    @Override
    public XPathReference[] getXPathReferences() {
        ArrayList<XPathReferenceImpl> result = new ArrayList<XPathReferenceImpl>();
        if (StringUtils.hasContent(this.getPath())) {
            TestStep testStep = this.getAssertable().getTestStep();
            TestProperty property = testStep instanceof WsdlTestRequestStep ? testStep.getProperty("Response") : testStep.getProperty("Request");
            result.add(new XPathReferenceImpl(this.getQueryType() + " for " + this.getName() + " " + this.getQueryType() + "ContainsAssertion in " + testStep.getName(), property, this, "path"));
        }
        return result.toArray(new XPathReference[result.size()]);
    }

    protected final class InternalDifferenceListener
    implements DifferenceListener {
        private StringList nodesToRemove = new StringList();

        protected InternalDifferenceListener() {
        }

        public int differenceFound(Difference diff) {
            if (AbstractXmlContainsAssertion.this.allowWildcards && (diff.getId() == DifferenceEngine.TEXT_VALUE.getId() || diff.getId() == DifferenceEngine.ATTR_VALUE.getId())) {
                if (Tools.isSimilar(diff.getControlNodeDetail().getValue(), diff.getTestNodeDetail().getValue(), '*')) {
                    this.addToNodesToRemove(diff);
                    return 1;
                }
            } else if (AbstractXmlContainsAssertion.this.allowWildcards && diff.getId() == DifferenceEngine.NODE_TYPE.getId()) {
                if (Tools.isSimilar(diff.getControlNodeDetail().getNode().getNodeValue(), diff.getTestNodeDetail().getNode().getNodeValue(), '*')) {
                    this.addToNodesToRemove(diff);
                    return 1;
                }
            } else if (AbstractXmlContainsAssertion.this.ignoreNamespaceDifferences && diff.getId() == 15) {
                return 1;
            }
            return 0;
        }

        private void addToNodesToRemove(Difference diff) {
            Node node = diff.getTestNodeDetail().getNode();
            String xp = XmlUtils.createAbsoluteXPath(node.getNodeType() == 2 ? node : node.getParentNode());
            this.nodesToRemove.add(xp);
        }

        public void skippedComparison(Node arg0, Node arg1) {
        }

        public StringList getNodesToRemove() {
            return this.nodesToRemove;
        }
    }
}

