/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.submit.WsdlMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowMessageExchangeAction;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.testsuite.AssertedXPath;
import com.eviware.soapui.model.testsuite.MessageExchangeTestStepResult;
import com.eviware.soapui.model.testsuite.ResponseAssertedMessageExchange;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class WsdlTestRequestStepResult
extends WsdlTestStepResult
implements ResponseAssertedMessageExchange,
AssertedXPathsContainer,
MessageExchangeTestStepResult,
WsdlMessageExchange {
    private SoftReference<String> softRequestContent;
    private SoftReference<WsdlResponse> softResponse;
    private String domain;
    private String username;
    private String endpoint;
    private String encoding;
    private String password;
    private StringToStringMap properties;
    private boolean addedAction;
    private List<AssertedXPath> assertedXPaths;
    private WsdlResponse response;
    private String requestContent;
    private WsdlOperation operation;

    public WsdlTestRequestStepResult(WsdlTestRequestStep step) {
        super(step);
        this.operation = step.getOperation();
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public SoapVersion getSoapVersion() {
        return this.getOperation().getInterface().getSoapVersion();
    }

    @Override
    public ModelItem getModelItem() {
        return this.getResponse() == null ? null : this.getResponse().getRequest();
    }

    @Override
    public String getRequestContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        return this.requestContent != null ? this.requestContent : (this.softRequestContent == null ? null : this.softRequestContent.get());
    }

    public void setRequestContent(String requestContent, boolean useSoftReference) {
        if (useSoftReference) {
            this.softRequestContent = new SoftReference<String>(requestContent);
        } else {
            this.requestContent = requestContent;
        }
    }

    @Override
    public WsdlResponse getResponse() {
        return this.response != null ? this.response : (this.softResponse == null ? null : this.softResponse.get());
    }

    @Override
    public ActionList getActions() {
        if (!this.addedAction) {
            this.addAction(new ShowMessageExchangeAction(this, "TestStep"), true);
            this.addedAction = true;
        }
        return super.getActions();
    }

    public void setResponse(WsdlResponse response, boolean useSoftReference) {
        if (useSoftReference) {
            this.softResponse = new SoftReference<WsdlResponse>(response);
        } else {
            this.response = response;
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.addProperty("domain", domain);
    }

    private void addProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(key, value);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.addProperty("Encoding", encoding);
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        this.addProperty("Endpoint", endpoint);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.addProperty("Password", password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.addProperty("Username", username);
    }

    @Override
    public void discard() {
        super.discard();
        this.softRequestContent = null;
        this.softResponse = null;
        this.properties = null;
        this.assertedXPaths = null;
        this.response = null;
    }

    @Override
    public void writeTo(PrintWriter writer) {
        super.writeTo(writer);
        writer.println("\r\n----------------- Properties ------------------------------");
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                if (this.properties.get(key) == null) continue;
                writer.println(key + ": " + (String)this.properties.get(key));
            }
        }
        writer.println("\r\n---------------- Request ---------------------------");
        WsdlResponse resp = this.getResponse();
        if (resp != null) {
            writer.println("Request Headers: " + resp.getRequestHeaders().toString() + "\r\n");
        }
        if (this.getRequestContent() != null) {
            writer.println(XmlUtils.prettyPrintXml(this.getRequestContent()));
        } else {
            writer.println("- missing request / garbage collected -");
        }
        writer.println("\r\n---------------- Response --------------------------");
        if (resp != null) {
            writer.println("Response Headers: " + resp.getResponseHeaders().toString() + "\r\n");
            String respContent = resp.getContentAsString();
            if (respContent != null) {
                writer.println(XmlUtils.prettyPrintXml(respContent));
            }
        } else {
            writer.println("- missing response / garbage collected -");
        }
    }

    @Override
    public StringToStringMap getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    @Override
    public Attachment[] getRequestAttachments() {
        if (this.getResponse() == null || this.getResponse().getRequest() == null) {
            return new Attachment[0];
        }
        return this.getResponse().getRequest().getAttachments();
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.getResponse() == null ? null : this.getResponse().getRequestHeaders();
    }

    @Override
    public Attachment[] getResponseAttachments() {
        return this.getResponse() == null ? null : this.getResponse().getAttachments();
    }

    @Override
    public String getResponseContent() {
        if (this.isDiscarded()) {
            return "<discarded>";
        }
        if (this.getResponse() == null) {
            return "<missing response>";
        }
        return this.getResponse().getContentAsString();
    }

    @Override
    public String getRequestContentAsXml() {
        return XmlUtils.seemsToBeXml(this.getRequestContent()) ? this.getRequestContent() : "<not-xml/>";
    }

    @Override
    public String getResponseContentAsXml() {
        String responseContent = this.getResponseContent();
        return XmlUtils.seemsToBeXml(responseContent) ? responseContent : null;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.getResponse() == null ? new StringToStringsMap() : this.getResponse().getResponseHeaders();
    }

    @Override
    public long getTimestamp() {
        WsdlResponse resp = this.getResponse();
        return resp == null ? 0L : resp.getTimestamp();
    }

    @Override
    public AssertedXPath[] getAssertedXPathsForResponse() {
        return this.assertedXPaths == null ? new AssertedXPath[]{} : this.assertedXPaths.toArray(new AssertedXPath[this.assertedXPaths.size()]);
    }

    @Override
    public void addAssertedXPath(AssertedXPath assertedXPath) {
        if (this.assertedXPaths == null) {
            this.assertedXPaths = new ArrayList<AssertedXPath>();
        }
        this.assertedXPaths.add(assertedXPath);
    }

    @Override
    public MessageExchange[] getMessageExchanges() {
        return new MessageExchange[]{this};
    }

    @Override
    public byte[] getRawRequestData() {
        return this.getResponse() == null ? null : this.getResponse().getRawRequestData();
    }

    @Override
    public byte[] getRawResponseData() {
        return this.getResponse() == null ? null : this.getResponse().getRawResponseData();
    }

    @Override
    public Attachment[] getRequestAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public Attachment[] getResponseAttachmentsForPart(String partName) {
        return null;
    }

    @Override
    public boolean hasRawData() {
        return false;
    }

    @Override
    public boolean hasRequest(boolean b) {
        return true;
    }

    @Override
    public boolean hasResponse() {
        return this.getResponse() != null;
    }

    @Override
    public Vector<?> getRequestWssResult() {
        return null;
    }

    @Override
    public Vector<?> getResponseWssResult() {
        return this.getResponse() == null ? null : this.getResponse().getWssResult();
    }

    @Override
    public int getResponseStatusCode() {
        WsdlResponse resp = this.getResponse();
        return resp == null ? 0 : resp.getStatusCode();
    }

    @Override
    public String getResponseContentType() {
        return this.getResponse() == null ? null : this.getResponse().getContentType();
    }
}

