/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.support;

import com.eviware.soapui.impl.wsdl.support.wss.IncomingWss;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainer;
import com.eviware.soapui.impl.wsdl.support.wss.WssContainerListener;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.WssEntry;
import com.eviware.soapui.impl.wsdl.support.wss.crypto.CryptoType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class KeystoresComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
WssContainerListener {
    private List<WssCrypto> cryptos = new ArrayList<WssCrypto>();
    private WssCrypto selectedCrypto;
    private final WssContainer container;
    private final boolean outgoingConfig;

    public KeystoresComboBoxModel(WssContainer container, WssCrypto selectedCrypto, boolean outgoingWSSConfig) {
        this.container = container;
        this.selectedCrypto = selectedCrypto;
        this.outgoingConfig = outgoingWSSConfig;
        List<WssCrypto> currentCryptos = container.getCryptoList();
        if (outgoingWSSConfig) {
            for (WssCrypto currentCrypto : currentCryptos) {
                if (currentCrypto.getType() != CryptoType.KEYSTORE) continue;
                this.cryptos.add(currentCrypto);
            }
        } else {
            this.cryptos.addAll(currentCryptos);
        }
        container.addWssContainerListener(this);
    }

    @Override
    public String getSelectedItem() {
        return this.selectedCrypto == null ? null : this.selectedCrypto.getLabel();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedCrypto = null;
        for (WssCrypto crypto : this.cryptos) {
            if (!crypto.getLabel().equals(anItem)) continue;
            this.selectedCrypto = crypto;
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.cryptos.get(index).getLabel();
    }

    @Override
    public int getSize() {
        return this.cryptos == null ? 0 : this.cryptos.size();
    }

    public void release() {
        this.container.removeWssContainerListener(this);
        this.cryptos = null;
        this.selectedCrypto = null;
    }

    @Override
    public void cryptoAdded(WssCrypto crypto) {
        if (!this.outgoingConfig || this.outgoingConfig && crypto.getType() == CryptoType.KEYSTORE) {
            this.cryptos.add(crypto);
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        }
    }

    @Override
    public void cryptoRemoved(WssCrypto crypto) {
        if (!this.outgoingConfig || this.outgoingConfig && crypto.getType() == CryptoType.KEYSTORE) {
            int index = this.cryptos.indexOf(crypto);
            this.cryptos.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    @Override
    public void outgoingWssAdded(OutgoingWss outgoingWss) {
    }

    @Override
    public void outgoingWssRemoved(OutgoingWss outgoingWss) {
    }

    @Override
    public void outgoingWssEntryAdded(WssEntry entry) {
    }

    @Override
    public void outgoingWssEntryMoved(WssEntry entry, int offset) {
    }

    @Override
    public void outgoingWssEntryRemoved(WssEntry entry) {
    }

    @Override
    public void incomingWssAdded(IncomingWss incomingWss) {
    }

    @Override
    public void incomingWssRemoved(IncomingWss incomingWss) {
    }

    @Override
    public void cryptoUpdated(WssCrypto crypto) {
    }
}

