/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.SyntaxEditorUtil;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSAMLToken;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.w3c.dom.Element;

public class ManualSAMLEntry
extends WssEntryBase {
    public static final String TYPE = "SAML (XML)";
    private String samlAssertion;
    private RSyntaxTextArea editor;

    @Override
    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    @Override
    protected JComponent buildUI() {
        JPanel panel = new JPanel(new BorderLayout());
        this.editor = SyntaxEditorUtil.createDefaultXmlSyntaxTextArea();
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.editor);
        scrollPane.setFoldIndicatorEnabled(true);
        scrollPane.setLineNumbersEnabled(true);
        this.editor = SyntaxEditorUtil.addDefaultActions(this.editor, scrollPane, false);
        this.editor.setText(this.samlAssertion == null ? "" : this.samlAssertion);
        this.editor.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ManualSAMLEntry.this.samlAssertion = ManualSAMLEntry.this.editor.getText();
                ManualSAMLEntry.this.saveConfig();
            }
        });
        panel.add((Component)scrollPane, "Center");
        return UISupport.addTitledBorder(panel, "Enter SAML Assertion");
    }

    @Override
    protected void load(XmlObjectConfigurationReader reader) {
        this.samlAssertion = reader.readString("samlAssertion", null);
    }

    @Override
    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("samlAssertion", this.samlAssertion);
    }

    @Override
    public void process(WSSecHeader secHeader, org.w3c.dom.Document doc, PropertyExpansionContext context) {
        if (StringUtils.isNullOrEmpty(this.samlAssertion)) {
            return;
        }
        try {
            String samlAssertionValue = context.expand(this.samlAssertion);
            if (samlAssertionValue == null || !samlAssertionValue.contains("http://www.w3.org/2000/09/xmldsig#") || !samlAssertionValue.contains("SignatureValue")) {
                samlAssertionValue = XmlUtils.stripWhitespaces(samlAssertionValue);
            }
            org.w3c.dom.Document samlAssertionDOM = XmlUtils.parseXml(samlAssertionValue);
            Element samlAssertionRootElement = samlAssertionDOM.getDocumentElement();
            AssertionWrapper assertion = new AssertionWrapper(samlAssertionRootElement);
            WSSecSAMLToken wsSign = new WSSecSAMLToken();
            wsSign.build(doc, assertion, secHeader);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public String getSamlAssertion() {
        return this.samlAssertion;
    }

    public void setSamlAssertion(String samlAssertion) {
        this.samlAssertion = samlAssertion;
        this.saveConfig();
        if (this.editor != null) {
            this.editor.setText(samlAssertion);
        }
    }

    @Override
    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
        result.extractAndAddAll("samlAssertion");
    }
}

