/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssContainerListenerAdapter;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.impl.wsdl.support.wss.support.WSPartsTable;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecHeader;
import org.w3c.dom.Document;

public class EncryptionEntry
extends WssEntryBase {
    private static final String DEFAULT_OPTION = "<default>";
    public static final String TYPE = "Encryption";
    private String crypto;
    private int keyIdentifierType;
    private String symmetricEncAlgorithm;
    private String encKeyTransport;
    private List<StringToStringMap> parts;
    private String embeddedKeyName;
    private String embeddedKeyPassword;
    private String encryptionCanonicalization;
    private JTextField embeddedKeyNameTextField;
    private JTextField embeddedKeyNamePassword;
    private boolean encryptSymmetricKey;
    private WssEntryBase.KeyAliasComboBoxModel keyAliasComboBoxModel;
    private InternalWssContainerListener wssContainerListener;

    @Override
    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    @Override
    protected JComponent buildUI() {
        SimpleBindingForm form = new SimpleBindingForm(new PresentationModel((Object)this));
        form.addSpace(5);
        this.wssContainerListener = new InternalWssContainerListener();
        this.getWssContainer().addWssContainerListener(this.wssContainerListener);
        KeystoresComboBoxModel keystoresComboBoxModel = new KeystoresComboBoxModel(this.getWssContainer(), this.getWssContainer().getCryptoByName(this.crypto), true);
        form.appendComboBox("crypto", "Keystore", keystoresComboBoxModel, "Selects the Keystore containing the key to use for signing").addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EncryptionEntry.this.keyAliasComboBoxModel.update(EncryptionEntry.this.getWssContainer().getCryptoByName(EncryptionEntry.this.crypto));
            }
        });
        this.keyAliasComboBoxModel = new WssEntryBase.KeyAliasComboBoxModel(this, this.getWssContainer().getCryptoByName(this.crypto));
        form.appendComboBox("username", "Alias", this.keyAliasComboBoxModel, "The alias for the key to use for encryption");
        form.appendPasswordField("password", "Password", "The password for the key to use for encryption (if it is private)");
        form.appendComboBox("keyIdentifierType", "Key Identifier Type", new Integer[]{1, 2, 3, 4, 5, 6, 8}, "Sets which key identifier to use").setRenderer(new WssEntryBase.KeyIdentifierTypeRenderer(this));
        this.embeddedKeyNameTextField = form.appendTextField("embeddedKeyName", "Embedded Key Name", "The embedded key name");
        this.embeddedKeyNameTextField.setEnabled(this.keyIdentifierType == 5);
        this.embeddedKeyNamePassword = form.appendPasswordField("embeddedKeyPassword", "Embedded Key Password", "The embedded key password");
        this.embeddedKeyNamePassword.setEnabled(this.keyIdentifierType == 5);
        form.appendComboBox("symmetricEncAlgorithm", "Symmetric Encoding Algorithm", new String[]{DEFAULT_OPTION, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc"}, "Set the name of the symmetric encryption algorithm to use");
        form.appendComboBox("encKeyTransport", "Key Encryption Algorithm", new String[]{DEFAULT_OPTION, "http://www.w3.org/2001/04/xmlenc#rsa-1_5", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p"}, "Sets the algorithm to encode the symmetric key");
        form.appendCheckBox("encryptSymmetricKey", "Create Encrypted Key", "Indicates whether to encrypt the symmetric key into an EncryptedKey or not");
        form.append("Parts", new WSPartsTable(this.parts, this));
        return new JScrollPane(form.getPanel());
    }

    @Override
    public void release() {
        if (this.wssContainerListener != null) {
            this.getWssContainer().removeWssContainerListener(this.wssContainerListener);
        }
    }

    @Override
    protected void load(XmlObjectConfigurationReader reader) {
        this.crypto = reader.readString("crypto", null);
        this.keyIdentifierType = this.readKeyIdentifierType(reader);
        this.symmetricEncAlgorithm = reader.readString("symmetricEncAlgorithm", null);
        this.encKeyTransport = reader.readString("encKeyTransport", null);
        this.embeddedKeyName = reader.readString("embeddedKeyName", null);
        this.embeddedKeyPassword = reader.readString("embeddedKeyPassword", null);
        this.encryptionCanonicalization = reader.readString("encryptionCanonicalization", null);
        this.encryptSymmetricKey = reader.readBoolean("encryptSymmetricKey", true);
        this.parts = this.readTableValues(reader, "encryptionPart");
    }

    @Override
    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("crypto", this.crypto);
        builder.add("keyIdentifierType", this.keyIdentifierType);
        builder.add("symmetricEncAlgorithm", this.symmetricEncAlgorithm);
        builder.add("encKeyTransport", this.encKeyTransport);
        builder.add("embeddedKeyName", this.embeddedKeyName);
        builder.add("embeddedKeyPassword", this.embeddedKeyPassword);
        builder.add("encryptionCanonicalization", this.encryptionCanonicalization);
        builder.add("encryptSymmetricKey", this.encryptSymmetricKey);
        this.saveTableValues(builder, this.parts, "encryptionPart");
    }

    public String getEmbeddedKeyName() {
        return this.embeddedKeyName;
    }

    public void setEmbeddedKeyName(String embeddedKeyName) {
        this.embeddedKeyName = embeddedKeyName;
        this.saveConfig();
    }

    public String getEmbeddedKeyPassword() {
        return this.embeddedKeyPassword;
    }

    public void setEmbeddedKeyPassword(String embeddedKeyPassword) {
        this.embeddedKeyPassword = embeddedKeyPassword;
        this.saveConfig();
    }

    public String getEncKeyTransport() {
        return StringUtils.isNullOrEmpty(this.encKeyTransport) ? DEFAULT_OPTION : this.encKeyTransport;
    }

    public void setEncKeyTransport(String encKeyTransport) {
        if (DEFAULT_OPTION.equals(encKeyTransport)) {
            encKeyTransport = null;
        }
        this.encKeyTransport = encKeyTransport;
        this.saveConfig();
    }

    public String getEncryptionCanonicalization() {
        return StringUtils.isNullOrEmpty(this.encryptionCanonicalization) ? DEFAULT_OPTION : this.encryptionCanonicalization;
    }

    public void setEncryptionCanonicalization(String encryptionCanonicalization) {
        if (DEFAULT_OPTION.equals(encryptionCanonicalization)) {
            encryptionCanonicalization = null;
        }
        this.encryptionCanonicalization = encryptionCanonicalization;
        this.saveConfig();
    }

    public boolean isEncryptSymmetricKey() {
        return this.encryptSymmetricKey;
    }

    public void setEncryptSymmetricKey(boolean encryptSymmetricKey) {
        this.encryptSymmetricKey = encryptSymmetricKey;
        this.saveConfig();
    }

    public int getKeyIdentifierType() {
        return this.keyIdentifierType;
    }

    public void setKeyIdentifierType(int keyIdentifierType) {
        this.keyIdentifierType = keyIdentifierType;
        if (this.embeddedKeyNameTextField != null) {
            this.embeddedKeyNameTextField.setEnabled(keyIdentifierType == 5);
            this.embeddedKeyNamePassword.setEnabled(keyIdentifierType == 5);
        }
        this.saveConfig();
    }

    public String getSymmetricEncAlgorithm() {
        return StringUtils.isNullOrEmpty(this.symmetricEncAlgorithm) ? DEFAULT_OPTION : this.symmetricEncAlgorithm;
    }

    public void setSymmetricEncAlgorithm(String symmetricEncAlgorithm) {
        if (DEFAULT_OPTION.equals(symmetricEncAlgorithm)) {
            symmetricEncAlgorithm = null;
        }
        this.symmetricEncAlgorithm = symmetricEncAlgorithm;
        this.saveConfig();
    }

    @Override
    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        block10: {
            StringWriter writer = null;
            try {
                Vector<WSEncryptionPart> wsParts;
                WssCrypto wssCrypto = this.getWssContainer().getCryptoByName(this.crypto);
                if (wssCrypto == null) {
                    throw new Exception("Missing crypto [" + this.crypto + "] for encryption entry");
                }
                Crypto crypto = wssCrypto.getCrypto();
                WSSecEncrypt wsEncrypt = new WSSecEncrypt();
                WSSConfig wssConfig = WSSConfig.getNewInstance();
                wsEncrypt.setWsConfig(wssConfig);
                wsEncrypt.setUserInfo(context.expand(this.getUsername()));
                if (this.getKeyIdentifierType() != 0) {
                    wsEncrypt.setKeyIdentifierType(this.getKeyIdentifierType());
                }
                if (this.getKeyIdentifierType() == 5) {
                    wsEncrypt.setEmbeddedKeyName(this.getEmbeddedKeyName());
                    wsEncrypt.setKey(crypto.getPrivateKey(this.getEmbeddedKeyName(), this.getEmbeddedKeyPassword()).getEncoded());
                }
                if (!this.getSymmetricEncAlgorithm().equals(DEFAULT_OPTION)) {
                    wsEncrypt.setSymmetricEncAlgorithm(this.getSymmetricEncAlgorithm());
                }
                if (!this.getEncKeyTransport().equals(DEFAULT_OPTION)) {
                    wsEncrypt.setKeyEnc(this.getEncKeyTransport());
                }
                wsEncrypt.setEncryptSymmKey(this.isEncryptSymmetricKey());
                if (this.parts.size() > 0 && !(wsParts = this.createWSParts(this.parts)).isEmpty()) {
                    wsEncrypt.setParts(wsParts);
                }
                writer = new StringWriter();
                XmlUtils.serialize(doc, (Writer)writer);
                wsEncrypt.build(doc, crypto, secHeader);
            }
            catch (Exception e) {
                SoapUI.logError(e);
                if (writer == null || writer.getBuffer().length() <= 0) break block10;
                try {
                    doc.replaceChild(doc.importNode(XmlUtils.parseXml(writer.toString()).getDocumentElement(), true), doc.getDocumentElement());
                }
                catch (Exception e1) {
                    SoapUI.logError(e1);
                }
            }
        }
    }

    @Override
    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
    }

    public String getCrypto() {
        return this.crypto;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
        this.saveConfig();
    }

    private final class InternalWssContainerListener
    extends WssContainerListenerAdapter {
        private InternalWssContainerListener() {
        }

        @Override
        public void cryptoUpdated(WssCrypto crypto) {
            if (crypto.getLabel().equals(EncryptionEntry.this.getCrypto())) {
                EncryptionEntry.this.keyAliasComboBoxModel.update(crypto);
            }
        }
    }
}

