/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class SoapUISSLSocketFactory
extends SSLSocketFactory {
    private static final Map<String, SSLSocketFactory> factoryMap = new ConcurrentHashMap<String, SSLSocketFactory>();
    private final String sslContextAlgorithm = System.getProperty("soapui.sslcontext.algorithm", "TLS");
    private final SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
    private static final Logger log = Logger.getLogger(SoapUISSLSocketFactory.class);

    public SoapUISSLSocketFactory(KeyStore keyStore, String keystorePassword) throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        super(keyStore);
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        };
        if (keyStore != null) {
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keyStore, keystorePassword != null ? keystorePassword.toCharArray() : null);
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            this.sslContext.init(keymanagers, new TrustManager[]{tm}, null);
        } else {
            this.sslContext.init(null, new TrustManager[]{tm}, null);
        }
        this.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    private static SSLSocket enableSocket(SSLSocket socket) {
        String invalidateSession = System.getProperty("soapui.https.session.invalidate");
        String protocols = System.getProperty("soapui.https.protocols");
        String ciphers = System.getProperty("soapui.https.ciphers");
        if (StringUtils.hasContent(invalidateSession)) {
            socket.getSession().invalidate();
        }
        if (StringUtils.hasContent(protocols)) {
            socket.setEnabledProtocols(protocols.split(","));
        }
        if (StringUtils.hasContent(ciphers)) {
            socket.setEnabledCipherSuites(ciphers.split(","));
        }
        return socket;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        String sslConfig = (String)params.getParameter("soapui.sslConfig");
        if (StringUtils.isNullOrEmpty(sslConfig)) {
            return SoapUISSLSocketFactory.enableSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket());
        }
        SSLSocketFactory factory = factoryMap.get(sslConfig);
        if (factory != null) {
            if (factory == this) {
                return SoapUISSLSocketFactory.enableSocket((SSLSocket)this.sslContext.getSocketFactory().createSocket());
            }
            return SoapUISSLSocketFactory.enableSocket((SSLSocket)factory.createSocket(params));
        }
        try {
            File f;
            int ix = sslConfig.lastIndexOf(32);
            String keyStore = sslConfig.substring(0, ix);
            String pwd = sslConfig.substring(ix + 1);
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            if (keyStore.trim().length() > 0 && (f = new File(keyStore)).exists()) {
                log.info((Object)("Initializing Keystore from [" + keyStore + "]"));
                try {
                    KeyMaterial km = new KeyMaterial(f, pwd.toCharArray());
                    ks = km.getKeyStore();
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                    pwd = null;
                }
            }
            factory = new SoapUISSLSocketFactory(ks, pwd);
            factoryMap.put(sslConfig, factory);
            return SoapUISSLSocketFactory.enableSocket((SSLSocket)factory.createSocket(params));
        }
        catch (Exception gse) {
            SoapUI.logError(gse);
            return SoapUISSLSocketFactory.enableSocket((SSLSocket)super.createSocket(params));
        }
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslsock;
        Socket sock;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Socket socket2 = sock = socket != null ? socket : new Socket();
        if (localAddress != null) {
            sock.setReuseAddress(HttpConnectionParams.getSoReuseaddr((HttpParams)params));
            sock.bind(localAddress);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
        try {
            sock.setSoTimeout(soTimeout);
            sock.connect(remoteAddress, connTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress.getHostName() + "/" + remoteAddress.getAddress() + " timed out");
        }
        if (sock instanceof SSLSocket) {
            sslsock = (SSLSocket)sock;
        } else {
            sslsock = (SSLSocket)this.sslContext.getSocketFactory().createSocket(sock, remoteAddress.getHostName(), remoteAddress.getPort(), true);
            sslsock = SoapUISSLSocketFactory.enableSocket(sslsock);
        }
        return sslsock;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        sslSocket = SoapUISSLSocketFactory.enableSocket(sslSocket);
        return sslSocket;
    }
}

