/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import java.security.Principal;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public class SSLInfo {
    private String cipherSuite;
    private Principal localPrincipal;
    private Certificate[] localCertificates;
    private Principal peerPrincipal;
    private Certificate[] peerCertificates;
    private boolean peerUnverified;

    public SSLInfo(SSLSession session) {
        this.cipherSuite = session.getCipherSuite();
        this.localPrincipal = session.getLocalPrincipal();
        this.localCertificates = session.getLocalCertificates();
        try {
            this.peerPrincipal = session.getPeerPrincipal();
            this.peerCertificates = session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            this.peerUnverified = true;
        }
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public Certificate[] getLocalCertificates() {
        return this.localCertificates;
    }

    public Principal getLocalPrincipal() {
        return this.localPrincipal;
    }

    public Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    public Principal getPeerPrincipal() {
        return this.peerPrincipal;
    }

    public boolean isPeerUnverified() {
        return this.peerUnverified;
    }
}

