/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.rest.support.RestUtils;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.submit.filters.AbstractRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.RestRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments.RestRequestMimeMessageRequestEntity;
import com.eviware.soapui.impl.wsdl.support.FileAttachment;
import com.eviware.soapui.impl.wsdl.support.PathUtils;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.apache.commons.httpclient.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.xmlbeans.XmlBoolean;

public class HttpRequestFilter
extends AbstractRequestFilter {
    @Override
    public void filterHttpRequest(SubmitContext context, HttpRequestInterface<?> request) {
        HttpRequestBase httpMethod = (HttpRequestBase)context.getProperty("httpMethod");
        String path = PropertyExpander.expandProperties(context, request.getPath());
        StringBuilder query = new StringBuilder();
        String encoding = System.getProperty("soapui.request.encoding", StringUtils.unquote(request.getEncoding()));
        StringToStringMap responseProperties = (StringToStringMap)context.getProperty("httpResponseProperties");
        MimeMultipart formMp = ("multipart/form-data".equals(request.getMediaType()) || "multipart/mixed".equals(request.getMediaType())) && httpMethod instanceof HttpEntityEnclosingRequestBase ? new MimeMultipart() : null;
        RestParamsPropertyHolder params = request.getParams();
        block28: for (int c = 0; c < params.getPropertyCount(); ++c) {
            List<String> valueParts;
            RestParamProperty param = params.getPropertyAt(c);
            String value = PropertyExpander.expandProperties(context, param.getValue());
            responseProperties.put(param.getName(), value);
            List<String> list = valueParts = this.sendEmptyParameters(request) || !StringUtils.hasContent(value) && param.getRequired() ? RestUtils.splitMultipleParametersEmptyIncluded(value, request.getMultiValueDelimiter()) : RestUtils.splitMultipleParameters(value, request.getMultiValueDelimiter());
            if (value != null && param.getStyle() != RestParamsPropertyHolder.ParameterStyle.HEADER && param.getStyle() != RestParamsPropertyHolder.ParameterStyle.TEMPLATE && !param.isDisableUrlEncoding()) {
                try {
                    int i;
                    if (StringUtils.hasContent(encoding)) {
                        value = URLEncoder.encode(value, encoding);
                        for (i = 0; i < valueParts.size(); ++i) {
                            valueParts.set(i, URLEncoder.encode(valueParts.get(i), encoding));
                        }
                    } else {
                        value = HttpUtils.urlEncodeWithUtf8(value);
                        for (i = 0; i < valueParts.size(); ++i) {
                            valueParts.set(i, HttpUtils.urlEncodeWithUtf8(valueParts.get(i)));
                        }
                    }
                }
                catch (UnsupportedEncodingException e1) {
                    SoapUI.logError(e1);
                    value = HttpUtils.urlEncodeWithUtf8(value);
                    for (int i = 0; i < valueParts.size(); ++i) {
                        valueParts.set(i, HttpUtils.urlEncodeWithUtf8(valueParts.get(i)));
                    }
                }
                value = value.replaceAll("\\+", "%20");
                for (int i = 0; i < valueParts.size(); ++i) {
                    valueParts.set(i, valueParts.get(i).replaceAll("\\+", "%20"));
                }
            }
            if (param.getStyle() == RestParamsPropertyHolder.ParameterStyle.QUERY && !this.sendEmptyParameters(request) && !StringUtils.hasContent(value) && !param.getRequired()) continue;
            switch (param.getStyle()) {
                case HEADER: {
                    for (String valuePart : valueParts) {
                        httpMethod.addHeader(param.getName(), valuePart);
                    }
                    continue block28;
                }
                case QUERY: {
                    if (formMp == null || !request.isPostQueryString()) {
                        for (String valuePart : valueParts) {
                            if (query.length() > 0) {
                                query.append('&');
                            }
                            query.append(HttpUtils.urlEncodeWithUtf8(param.getName()));
                            query.append('=');
                            if (!StringUtils.hasContent(valuePart)) continue;
                            query.append(valuePart);
                        }
                        continue block28;
                    }
                    try {
                        this.addFormMultipart(request, formMp, param.getName(), (String)responseProperties.get(param.getName()));
                    }
                    catch (MessagingException e) {
                        SoapUI.logError(e);
                    }
                }
                case TEMPLATE: {
                    try {
                        value = this.getEncodedValue(value, encoding, param.isDisableUrlEncoding(), request.getSettings().getBoolean(HttpSettings.ENCODED_URLS));
                        path = path.replaceAll("\\{" + param.getName() + "\\}", value == null ? "" : value);
                    }
                    catch (UnsupportedEncodingException e) {
                        SoapUI.logError(e);
                    }
                    continue block28;
                }
                case MATRIX: {
                    try {
                        value = this.getEncodedValue(value, encoding, param.isDisableUrlEncoding(), request.getSettings().getBoolean(HttpSettings.ENCODED_URLS));
                    }
                    catch (UnsupportedEncodingException e) {
                        SoapUI.logError(e);
                    }
                    if (param.getType().equals(XmlBoolean.type.getName())) {
                        if (!value.toUpperCase().equals("TRUE") && !value.equals("1")) continue block28;
                        path = path + ";" + param.getName();
                        continue block28;
                    }
                    path = path + ";" + param.getName();
                    if (!StringUtils.hasContent(value)) continue block28;
                    path = path + "=" + value;
                    continue block28;
                }
            }
        }
        if (request.getSettings().getBoolean(HttpSettings.FORWARD_SLASHES)) {
            path = PathUtils.fixForwardSlashesInPath(path);
        }
        if (PathUtils.isHttpPath(path)) {
            try {
                URI uri = new URI(path, request.getSettings().getBoolean(HttpSettings.ENCODED_URLS));
                context.setProperty("requestUri", uri);
                java.net.URI oldUri = httpMethod.getURI();
                httpMethod.setURI(HttpUtils.createUri(oldUri.getScheme(), oldUri.getRawUserInfo(), oldUri.getHost(), oldUri.getPort(), oldUri.getRawPath(), uri.getEscapedQuery(), oldUri.getRawFragment()));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        } else if (StringUtils.hasContent(path)) {
            try {
                java.net.URI oldUri = httpMethod.getURI();
                String pathToSet = StringUtils.hasContent(oldUri.getRawPath()) && !"/".equals(oldUri.getRawPath()) ? oldUri.getRawPath() + path : path;
                java.net.URI newUri = URIUtils.createURI((String)oldUri.getScheme(), (String)oldUri.getHost(), (int)oldUri.getPort(), (String)pathToSet, (String)oldUri.getQuery(), (String)oldUri.getFragment());
                httpMethod.setURI(newUri);
                context.setProperty("requestUri", new URI(newUri.toString(), request.getSettings().getBoolean(HttpSettings.ENCODED_URLS)));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        if (query.length() > 0 && !request.isPostQueryString()) {
            try {
                java.net.URI oldUri = httpMethod.getURI();
                httpMethod.setURI(URIUtils.createURI((String)oldUri.getScheme(), (String)oldUri.getHost(), (int)oldUri.getPort(), (String)oldUri.getRawPath(), (String)query.toString(), (String)oldUri.getFragment()));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        if (formMp != null) {
            try {
                String requestContent;
                if (request.hasRequestBody() && httpMethod instanceof HttpEntityEnclosingRequest && StringUtils.hasContent(requestContent = PropertyExpander.expandProperties(context, request.getRequestContent(), request.isEntitizeProperties()))) {
                    this.initRootPart(request, requestContent, formMp);
                }
                for (Attachment attachment : request.getAttachments()) {
                    PreencodedMimeBodyPart part = new PreencodedMimeBodyPart("binary");
                    if (attachment instanceof FileAttachment) {
                        String name = attachment.getName();
                        if (StringUtils.hasContent(attachment.getContentID()) && !name.equals(attachment.getContentID())) {
                            name = attachment.getContentID();
                        }
                        part.setDisposition("form-data; name=\"" + name + "\"; filename=\"" + attachment.getName() + "\"");
                    } else {
                        part.setDisposition("form-data; name=\"" + attachment.getName() + "\"");
                    }
                    part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(attachment)));
                    formMp.addBodyPart((BodyPart)part);
                }
                MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
                message.setContent((Multipart)formMp);
                message.saveChanges();
                RestRequestMimeMessageRequestEntity mimeMessageRequestEntity = new RestRequestMimeMessageRequestEntity(message, request);
                ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)mimeMessageRequestEntity);
                httpMethod.setHeader("Content-Type", mimeMessageRequestEntity.getContentType().getValue());
                httpMethod.setHeader("MIME-Version", "1.0");
            }
            catch (Throwable e) {
                SoapUI.logError(e);
            }
        } else if (request.hasRequestBody() && httpMethod instanceof HttpEntityEnclosingRequest) {
            if (StringUtils.hasContent(request.getMediaType())) {
                httpMethod.setHeader("Content-Type", this.getContentTypeHeader(request.getMediaType(), encoding));
            }
            if (request.isPostQueryString()) {
                try {
                    ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)new StringEntity(query.toString()));
                }
                catch (UnsupportedEncodingException e) {
                    SoapUI.logError(e);
                }
            } else {
                String requestContent = PropertyExpander.expandProperties(context, request.getRequestContent(), request.isEntitizeProperties());
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Attachment attachment : request.getAttachments()) {
                    if (!attachment.getContentType().equals(request.getMediaType())) continue;
                    attachments.add(attachment);
                }
                if (StringUtils.hasContent(requestContent) && attachments.isEmpty()) {
                    try {
                        byte[] content = encoding == null ? requestContent.getBytes() : requestContent.getBytes(encoding);
                        ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(content));
                    }
                    catch (UnsupportedEncodingException e) {
                        ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)new ByteArrayEntity(requestContent.getBytes()));
                    }
                } else if (attachments.size() > 0) {
                    try {
                        MimeMultipart mp = null;
                        if (StringUtils.hasContent(requestContent)) {
                            mp = new MimeMultipart();
                            this.initRootPart(request, requestContent, mp);
                        } else if (attachments.size() == 1) {
                            ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)new InputStreamEntity(((Attachment)attachments.get(0)).getInputStream(), -1L));
                            httpMethod.setHeader("Content-Type", this.getContentTypeHeader(request.getMediaType(), encoding));
                        }
                        if (((HttpEntityEnclosingRequest)httpMethod).getEntity() == null) {
                            if (mp == null) {
                                mp = new MimeMultipart();
                            }
                            AttachmentUtils.addMimeParts(request, attachments, mp, new StringToStringMap());
                            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
                            message.setContent((Multipart)mp);
                            message.saveChanges();
                            RestRequestMimeMessageRequestEntity mimeMessageRequestEntity = new RestRequestMimeMessageRequestEntity(message, request);
                            ((HttpEntityEnclosingRequest)httpMethod).setEntity((HttpEntity)mimeMessageRequestEntity);
                            httpMethod.setHeader("Content-Type", this.getContentTypeHeader(mimeMessageRequestEntity.getContentType().getValue(), encoding));
                            httpMethod.setHeader("MIME-Version", "1.0");
                        }
                    }
                    catch (Exception e) {
                        SoapUI.logError(e);
                    }
                }
            }
        }
    }

    private boolean sendEmptyParameters(HttpRequestInterface<?> request) {
        return request instanceof HttpTestRequest && ((HttpTestRequest)request).isSendEmptyParameters();
    }

    private String getContentTypeHeader(String contentType, String encoding) {
        return encoding == null || encoding.trim().length() == 0 ? contentType : contentType + ";charset=" + encoding;
    }

    private void addFormMultipart(HttpRequestInterface<?> request, MimeMultipart formMp, String name, String value) throws MessagingException {
        MimeBodyPart part = new MimeBodyPart();
        if (value.startsWith("file:")) {
            String fileName = value.substring(5);
            File file = new File(fileName);
            part.setDisposition("form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"");
            if (file.exists()) {
                part.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
            } else {
                for (Attachment attachment : request.getAttachments()) {
                    if (!attachment.getName().equals(fileName)) continue;
                    part.setDataHandler(new DataHandler((DataSource)new AttachmentDataSource(attachment)));
                    break;
                }
            }
            part.setHeader("Content-Type", ContentTypeHandler.getContentTypeFromFilename(file.getName()));
            part.setHeader("Content-Transfer-Encoding", "binary");
        } else {
            part.setDisposition("form-data; name=\"" + name + "\"");
            part.setText(value, System.getProperty("soapui.request.encoding", request.getEncoding()));
        }
        formMp.addBodyPart((BodyPart)part);
    }

    protected void initRootPart(HttpRequestInterface<?> wsdlRequest, String requestContent, MimeMultipart mp) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new RestRequestDataSource(wsdlRequest, requestContent));
        rootPart.setDataHandler(dataHandler);
    }

    protected String getEncodedValue(String value, String encoding, boolean isDisableUrlEncoding, boolean isPreEncoded) throws UnsupportedEncodingException {
        if (value == null) {
            return "";
        }
        if (!StringUtils.hasContent(encoding)) {
            encoding = System.getProperty("file.encoding");
        }
        if (this.isAlreadyEncoded(value, encoding)) {
            return value;
        }
        if (isDisableUrlEncoding || isPreEncoded) {
            return value;
        }
        String encodedValue = URLEncoder.encode(value, encoding);
        return encodedValue.replaceAll("\\+", "%20");
    }

    protected boolean isAlreadyEncoded(String path, String encoding) throws UnsupportedEncodingException {
        String decodedPath = URLDecoder.decode(path, encoding);
        return !path.equals(decodedPath);
    }
}

