/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.AbstractWsdlMockResponseDesktopPanel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.AssertionsPanel;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.support.TestRunListenerAdapter;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.support.TestMonitorListenerAdapter;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.ModelItemPropertyEditorModel;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JComponentInspector;
import com.eviware.soapui.support.components.JInspectorPanel;
import com.eviware.soapui.support.components.JInspectorPanelFactory;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.AbstractMockResponseDesktopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class WsdlMockResponseStepDesktopPanel
extends AbstractWsdlMockResponseDesktopPanel<WsdlMockResponseTestStep> {
    private JTextArea logArea;
    private AssertionsPanel assertionsPanel;
    private JTextField portField;
    private JTextField pathField;
    private InternalTestRunListener testRunListener;
    private InternalTestMonitorListener testMonitorListener = new InternalTestMonitorListener();
    private InternalAssertionsListener assertionsListener = new InternalAssertionsListener();
    private JInspectorPanel inspectorPanel;
    private JComponentInspector<JComponent> assertionInspector;
    private JComponentInspector<JComponent> logInspector;
    private ModelItemPropertyEditorModel<WsdlMockResponseTestStep> queryEditorModel;
    private ModelItemPropertyEditorModel<WsdlMockResponseTestStep> matchEditorModel;

    public WsdlMockResponseStepDesktopPanel(WsdlMockResponseTestStep mockResponseStep) {
        super(mockResponseStep);
        this.init(mockResponseStep.getMockResponse());
        this.testRunListener = new InternalTestRunListener();
        mockResponseStep.getTestCase().addTestRunListener(this.testRunListener);
        SoapUI.getTestMonitor().addTestMonitorListener(this.testMonitorListener);
        this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(mockResponseStep.getTestCase()));
        mockResponseStep.addAssertionsListener(this.assertionsListener);
    }

    @Override
    protected JComponent buildContent() {
        this.inspectorPanel = JInspectorPanelFactory.build(super.buildContent());
        this.assertionsPanel = this.buildAssertionsPanel();
        this.assertionInspector = new JComponentInspector<AssertionsPanel>(this.assertionsPanel, "Assertions (" + ((WsdlMockResponseTestStep)this.getModelItem()).getAssertionCount() + ")", "Assertions for this Request", true);
        this.inspectorPanel.addInspector(this.assertionInspector);
        this.logInspector = new JComponentInspector<JComponent>(this.buildLogPanel(), "Request Log (0)", "Log of requests", true);
        this.inspectorPanel.addInspector(this.logInspector);
        this.inspectorPanel.addInspector(new JComponentInspector<JComponent>(this.buildQueryMatchPanel(), "Query/Match", "Query/Match configuration", true));
        this.inspectorPanel.setDefaultDividerLocation(0.6f);
        this.inspectorPanel.setCurrentInspector("Assertions");
        this.updateStatusIcon();
        return this.inspectorPanel.getComponent();
    }

    private void updateStatusIcon() {
        Assertable.AssertionStatus status = ((WsdlMockResponseTestStep)this.getModelItem()).getAssertionStatus();
        switch (status) {
            case FAILED: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/failed_assertion.gif"));
                this.inspectorPanel.activate(this.assertionInspector);
                break;
            }
            case UNKNOWN: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/unknown_assertion.png"));
                break;
            }
            case VALID: {
                this.assertionInspector.setIcon(UISupport.createImageIcon("/valid_assertion.gif"));
                this.inspectorPanel.deactivate();
            }
        }
    }

    private JComponent buildLogPanel() {
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setToolTipText("Response Log");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.logArea), "Center");
        return panel;
    }

    @Override
    public void setContent(JComponent content) {
        this.inspectorPanel.setContentComponent(content);
    }

    @Override
    public void removeContent(JComponent content) {
        this.inspectorPanel.setContentComponent(null);
    }

    @Override
    protected void createToolbar(JXToolBar toolbar) {
        toolbar.addUnrelatedGap();
        toolbar.addFixed(new JLabel("Path"));
        toolbar.addRelatedGap();
        this.pathField = new JTextField(((WsdlMockResponseTestStep)this.getModelItem()).getPath(), 15);
        this.pathField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).setPath(WsdlMockResponseStepDesktopPanel.this.pathField.getText());
            }
        });
        toolbar.addFixed(this.pathField);
        toolbar.addUnrelatedGap();
        toolbar.addFixed(new JLabel("Port"));
        toolbar.addRelatedGap();
        this.portField = new JTextField(String.valueOf(((WsdlMockResponseTestStep)this.getModelItem()).getPort()), 5);
        this.portField.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            @Override
            public void update(Document document) {
                try {
                    ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).setPort(Integer.parseInt(WsdlMockResponseStepDesktopPanel.this.portField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        toolbar.addFixed(this.portField);
    }

    private JComponent buildQueryMatchPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildQueryMatchToolbar(), "North");
        JSplitPane splitPane = UISupport.createHorizontalSplit(this.buildQueryEditor(), this.buildMatchEditor());
        panel.add((Component)splitPane, "Center");
        splitPane.setDividerLocation(200);
        return panel;
    }

    private Component buildMatchEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.matchEditorModel = new ModelItemPropertyEditorModel(this.getModelItem(), "match");
        panel.add((Component)UISupport.getEditorFactory().buildXmlEditor(this.matchEditorModel), "Center");
        UISupport.addTitledBorder(panel, "Matching Value");
        return panel;
    }

    private Component buildQueryEditor() {
        JPanel panel = new JPanel(new BorderLayout());
        this.queryEditorModel = new ModelItemPropertyEditorModel(this.getModelItem(), "query");
        panel.add((Component)UISupport.getEditorFactory().buildXPathEditor(this.queryEditorModel), "Center");
        UISupport.addTitledBorder(panel, "XPath Query");
        return panel;
    }

    protected JXToolBar buildQueryMatchToolbar() {
        JXToolBar toolBar = UISupport.createSmallToolbar();
        toolBar.addFixed(new JButton(new SelectFromCurrentAction()));
        return toolBar;
    }

    private AssertionsPanel buildAssertionsPanel() {
        this.assertionsPanel = new AssertionsPanel((Assertable)this.getModelItem()){

            @Override
            protected void selectError(AssertionError error) {
                AbstractMockResponseDesktopPanel.MockResponseMessageEditor editor = WsdlMockResponseStepDesktopPanel.this.getResponseEditor();
                editor.requestFocus();
            }
        };
        return this.assertionsPanel;
    }

    @Override
    public boolean onClose(boolean canCancel) {
        ((WsdlMockResponseTestStep)this.getModelItem()).getTestCase().removeTestRunListener(this.testRunListener);
        SoapUI.getTestMonitor().removeTestMonitorListener(this.testMonitorListener);
        this.assertionsPanel.release();
        this.queryEditorModel.release();
        this.matchEditorModel.release();
        this.inspectorPanel.release();
        ((WsdlMockResponseTestStep)this.getModelItem()).removeAssertionsListener(this.assertionsListener);
        return super.onClose(canCancel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pathField.setEnabled(enabled);
        this.portField.setEnabled(enabled);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockResponseTestStep)this.getModelItem()).getTestCase() || modelItem == ((WsdlMockResponseTestStep)this.getModelItem()).getOperation() || modelItem == ((WsdlMockResponseTestStep)this.getModelItem()).getOperation().getInterface() || modelItem == ((WsdlMockResponseTestStep)this.getModelItem()).getTestCase().getTestSuite() || modelItem == ((WsdlMockResponseTestStep)this.getModelItem()).getTestCase().getTestSuite().getProject();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals(WsdlMockResponseTestStep.STATUS_PROPERTY)) {
            this.updateStatusIcon();
        }
    }

    private final class InternalAssertionsListener
    implements AssertionsListener {
        private InternalAssertionsListener() {
        }

        @Override
        public void assertionAdded(TestAssertion assertion) {
            WsdlMockResponseStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionRemoved(TestAssertion assertion) {
            WsdlMockResponseStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }

        @Override
        public void assertionMoved(TestAssertion assertion, int ix, int offset) {
            WsdlMockResponseStepDesktopPanel.this.assertionInspector.setTitle("Assertions (" + ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getAssertionCount() + ")");
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/declareNs.gif"));
            this.putValue("ShortDescription", "Declare available response/request namespaces in source/target expressions");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MockResult lastResult = ((WsdlMockResponse)WsdlMockResponseStepDesktopPanel.this.getMockResponse()).getMockResult();
                String content = null;
                if (lastResult == null) {
                    if (!UISupport.confirm("Missing last result, declare from default request instead?", "Declare Namespaces")) {
                        return;
                    }
                    content = ((WsdlMockResponse)WsdlMockResponseStepDesktopPanel.this.getMockResponse()).getMockOperation().getOperation().createRequest(true);
                } else {
                    content = lastResult.getMockRequest().getRequestContent();
                }
                String path = ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getQuery();
                if (path == null) {
                    path = "";
                }
                ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).setQuery(XmlUtils.declareXPathNamespaces(content) + path);
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private class InternalTestMonitorListener
    extends TestMonitorListenerAdapter {
        private InternalTestMonitorListener() {
        }

        @Override
        public void loadTestFinished(LoadTestRunner runner) {
            WsdlMockResponseStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void loadTestStarted(LoadTestRunner runner) {
            if (runner.getLoadTest().getTestCase() == ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlMockResponseStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void securityTestFinished(SecurityTestRunner runner) {
            WsdlMockResponseStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void securityTestStarted(SecurityTestRunner runner) {
            if (runner.getSecurityTest().getTestCase() == ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlMockResponseStepDesktopPanel.this.setEnabled(false);
            }
        }

        @Override
        public void testCaseFinished(TestCaseRunner runner) {
            WsdlMockResponseStepDesktopPanel.this.setEnabled(!SoapUI.getTestMonitor().hasRunningTest(((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()));
        }

        @Override
        public void testCaseStarted(TestCaseRunner runner) {
            if (runner.getTestCase() == ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getTestCase()) {
                WsdlMockResponseStepDesktopPanel.this.setEnabled(false);
            }
        }
    }

    public class InternalTestRunListener
    extends TestRunListenerAdapter {
        @Override
        public void afterRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlMockResponseStepDesktopPanel.this.setEnabled(true);
        }

        @Override
        public void beforeRun(TestCaseRunner testRunner, TestCaseRunContext runContext) {
            WsdlMockResponseStepDesktopPanel.this.setEnabled(false);
        }

        @Override
        public void beforeStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStep testStep) {
            if (testStep == WsdlMockResponseStepDesktopPanel.this.getModelItem()) {
                WsdlMockResponseStepDesktopPanel.this.logArea.setText(WsdlMockResponseStepDesktopPanel.this.logArea.getText() + new Date(System.currentTimeMillis()).toString() + ": Waiting for request on http://127.0.0.1:" + ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getPort() + ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getPath() + "\r\n");
            }
        }

        @Override
        public void afterStep(TestCaseRunner testRunner, TestCaseRunContext runContext, TestStepResult result) {
            if (result.getTestStep() == WsdlMockResponseStepDesktopPanel.this.getModelItem()) {
                String msg = new Date(result.getTimeStamp()).toString() + ": Handled request in " + result.getTimeTaken() + "ms";
                WsdlMockResponseStepDesktopPanel.this.logArea.setText(WsdlMockResponseStepDesktopPanel.this.logArea.getText() + msg + "\r\n");
            }
        }
    }

    public class SelectFromCurrentAction
    extends AbstractAction {
        public SelectFromCurrentAction() {
            super("Select from current");
            this.putValue("ShortDescription", "Selects the Query XPath expression from the last request Match field");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getLastResult() != null && ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getLastResult().getMockRequest() != null && StringUtils.hasContent(((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getQuery())) {
                ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).setMatch(XmlUtils.getXPathValue(((WsdlMockRequest)((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getLastResult().getMockRequest()).getRequestContent(), PropertyExpander.expandProperties(WsdlMockResponseStepDesktopPanel.this.getModelItem(), ((WsdlMockResponseTestStep)WsdlMockResponseStepDesktopPanel.this.getModelItem()).getQuery())));
            }
        }
    }
}

