/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps;

import com.eviware.soapui.config.CredentialsConfig;
import com.eviware.soapui.impl.EmptyPanelBuilder;
import com.eviware.soapui.impl.wsdl.panels.teststeps.HttpTestRequestDesktopPanel;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStep;
import com.eviware.soapui.support.components.JPropertiesTable;
import com.eviware.soapui.support.types.StringList;
import javax.swing.JPanel;

public class HttpTestRequestPanelBuilder
extends EmptyPanelBuilder<HttpTestRequestStep> {
    public HttpTestRequestDesktopPanel buildDesktopPanel(HttpTestRequestStep testStep) {
        return new HttpTestRequestDesktopPanel(testStep);
    }

    @Override
    public boolean hasDesktopPanel() {
        return true;
    }

    public JPanel buildOverviewPanel(HttpTestRequestStep testStep) {
        HttpTestRequest request = testStep.getTestRequest();
        JPropertiesTable<HttpTestRequest> table = new JPropertiesTable<HttpTestRequest>("HTTP TestRequest Properties");
        table.addProperty("Name", "name", true);
        table.addProperty("Description", "description", true);
        table.addProperty("Encoding", "encoding", new String[]{null, "UTF-8", "iso-8859-1"});
        table.addProperty("Endpoint", "endpoint", true);
        table.addProperty("Timeout", "timeout", true);
        table.addProperty("Bind Address", "bindAddress", true);
        table.addProperty("Follow Redirects", "followRedirects", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Username", "username", true);
        table.addPropertyShadow("Password", "password", true);
        table.addProperty("Domain", "domain", true);
        table.addProperty("Authentication Type", "authType", new String[]{CredentialsConfig.AuthType.GLOBAL_HTTP_SETTINGS.toString(), CredentialsConfig.AuthType.PREEMPTIVE.toString(), CredentialsConfig.AuthType.SPNEGO_KERBEROS.toString(), CredentialsConfig.AuthType.NTLM.toString()});
        StringList keystores = new StringList(request.getTestStep().getTestCase().getTestSuite().getProject().getWssContainer().getCryptoNames());
        keystores.add("");
        table.addProperty("SSL Keystore", "sslKeystore", keystores.toStringArray());
        table.addProperty("Strip whitespaces", "stripWhitespaces", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Remove Empty Content", "removeEmptyContent", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Entitize Properties", "entitizeProperties", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Multi-Value Delimiter", "multiValueDelimiter", true);
        table.addProperty("Pretty Print", "prettyPrint", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Dump File", "dumpFile", true).setDescription("Dumps response message to specified file");
        table.addProperty("Max Size", "maxSize", true).setDescription("The maximum number of bytes to receive");
        table.addProperty("Discard Response", "discardResponse", JPropertiesTable.BOOLEAN_OPTIONS);
        table.addProperty("Send Empty Parameters", "sendEmptyParameters", JPropertiesTable.BOOLEAN_OPTIONS);
        table.setPropertyObject(request);
        return table;
    }

    @Override
    public boolean hasOverviewPanel() {
        return true;
    }
}

