/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.support;

import com.eviware.soapui.impl.wsdl.panels.support.MockTestRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractSubmitContext;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;

public class MockTestRunContext
extends AbstractSubmitContext<ModelItem>
implements TestCaseRunContext {
    private final MockTestRunner mockTestRunner;
    private final WsdlTestStep testStep;

    public MockTestRunContext(MockTestRunner mockTestRunner, WsdlTestStep testStep) {
        super(testStep == null ? mockTestRunner.getTestCase() : testStep);
        this.mockTestRunner = mockTestRunner;
        this.testStep = testStep;
        this.setProperty("log", mockTestRunner.getLog());
        mockTestRunner.setMockRunContext(this);
    }

    @Override
    public TestStep getCurrentStep() {
        return this.testStep;
    }

    @Override
    public void setProperty(String name, Object value) {
        super.setProperty(name, value, this.getTestCase());
    }

    @Override
    public int getCurrentStepIndex() {
        return this.testStep == null ? -1 : this.testStep.getTestCase().getIndexOfTestStep(this.testStep);
    }

    @Override
    public TestCaseRunner getTestRunner() {
        return this.mockTestRunner;
    }

    @Override
    public Object get(Object key) {
        if ("currentStep".equals(key)) {
            return this.getCurrentStep();
        }
        if ("currentStepIndex".equals(key)) {
            return this.getCurrentStepIndex();
        }
        if ("settings".equals(key)) {
            return this.getSettings();
        }
        if ("testCase".equals(key)) {
            return this.getTestCase();
        }
        if ("testRunner".equals(key)) {
            return this.getTestRunner();
        }
        Object result = this.getProperty(key.toString());
        if (result == null) {
            result = super.get(key);
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        Object oldValue = this.get(key);
        this.setProperty(key, value);
        return oldValue;
    }

    @Override
    public Object getProperty(String name) {
        return this.getProperty(name, this.testStep, this.testStep == null ? null : this.testStep.getTestCase());
    }

    @Override
    public Object getProperty(String testStepName, String propertyName) {
        WsdlTestStep ts = this.testStep == null ? null : this.testStep.getTestCase().getTestStepByName(testStepName);
        return ts == null ? null : ts.getPropertyValue(propertyName);
    }

    @Override
    public TestCase getTestCase() {
        return this.testStep == null ? null : this.testStep.getTestCase();
    }

    public Settings getSettings() {
        return this.testStep == null ? null : this.testStep.getSettings();
    }
}

