/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.assertions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.project.SimpleDialog;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionCategoriesTableModel;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionCategoryMapping;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionsListTable;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionsListTableModel;
import com.eviware.soapui.impl.wsdl.panels.assertions.CategoriesListTable;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.recent.RecentAssertionHandler;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.settings.AssertionDescriptionSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.ActionList;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleForm;
import com.l2fprod.common.swing.renderer.DefaultCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class AddAssertionPanel
extends SimpleDialog {
    private static final long serialVersionUID = 5770245094548607912L;
    private CategoriesListTable categoriesListTable;
    private AssertionsListTable assertionsTable;
    private Assertable assertable;
    public static final String NO_PROPERTY_SELECTED = "<Select Property>";
    public static final String RESPONSE_PROPERTY = "Response";
    private AddAssertionAction addAssertionAction;
    private AssertionsListTableModel assertionsListTableModel;
    private AssertionCategoriesTableModel categoriesTableModel;
    private SortedSet<AssertionListEntry> assertions;
    private ListSelectionListener selectionListener;
    private LinkedHashMap<String, SortedSet<AssertionListEntry>> categoriesAssertionsMap;
    private SimpleForm assertionsForm;
    private JCheckBox hideDescCB;
    private AssertionEntryRenderer assertionEntryRenderer = new AssertionEntryRenderer();
    private CategoryListRenderer categoriesListRenderer = new CategoryListRenderer();
    private InternalHideDescListener hideDescListener = new InternalHideDescListener();
    protected RecentAssertionHandler recentAssertionHandler = new RecentAssertionHandler();
    private AssertionListMouseAdapter mouseAdapter = new AssertionListMouseAdapter();
    private String selectedCategory;

    public AssertionsListTableModel getAssertionsListTableModel() {
        return this.assertionsListTableModel;
    }

    public AddAssertionPanel(Assertable assertable) {
        super("Add Assertion", "Select the source property and which assertion to apply below ", "/functional-testing/validating-messages/getting-started-with-assertions.html");
        this.assertable = assertable;
        this.assertionEntryRenderer.setAssertable(assertable);
        this.categoriesListRenderer.setAssertable(assertable);
        this.selectionListener = new InternalListSelectionListener();
        this.categoriesAssertionsMap = AssertionCategoryMapping.getCategoriesAssertionsMap(assertable, this.recentAssertionHandler);
        WsdlProject project = (WsdlProject)ModelSupport.getModelItemProject(assertable.getModelItem());
        for (Interface inf : project.getInterfaceList()) {
            try {
                if (!(inf instanceof WsdlInterface)) continue;
                ((WsdlInterface)inf).getWsdlContext().loadIfNecessary();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public RecentAssertionHandler getRecentAssertionHandler() {
        return this.recentAssertionHandler;
    }

    public AssertionEntryRenderer getAssertionEntryRenderer() {
        return this.assertionEntryRenderer;
    }

    public String getSelectedCategory() {
        return this.selectedCategory;
    }

    protected String getSelectedPropertyName() {
        return RESPONSE_PROPERTY;
    }

    public void setAssertable(Assertable assertable) {
        this.assertable = assertable;
    }

    public Assertable getAssertable() {
        return this.assertable;
    }

    @Override
    protected Component buildContent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JSplitPane splitPane = UISupport.createHorizontalSplit(this.buildCategoriesList(), this.buildAssertionsList());
        splitPane.setDividerLocation(220);
        this.getAssertionsTable().setSelectable(true);
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.hideDescCB = new JCheckBox("Hide descriptions");
        this.hideDescCB.setOpaque(false);
        this.hideDescCB.addItemListener(this.hideDescListener);
        this.hideDescCB.setSelected(SoapUI.getSettings().getBoolean(AssertionDescriptionSettings.SHOW_ASSERTION_DESCRIPTION));
        toolbar.add(new JLabel("Assertions"));
        toolbar.addGlue();
        toolbar.add(this.hideDescCB);
        mainPanel.add((Component)toolbar, "North");
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    public AssertionListMouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    protected Component buildAssertionsList() {
        this.assertionsForm = new SimpleForm();
        this.assertionsListTableModel = new AssertionsListTableModel();
        this.assertionsTable = new AssertionsListTable(this.assertionsListTableModel);
        int selectedRow = this.categoriesListTable.getSelectedRow();
        String category = (String)this.categoriesListTable.getModel().getValueAt(selectedRow, 0);
        if (category != null && this.categoriesAssertionsMap.containsKey(category)) {
            this.assertions = this.categoriesAssertionsMap.get(category);
            this.assertionsListTableModel.setListEntriesSet(this.assertions);
        }
        this.assertionsTable.setTableHeader(null);
        this.assertionsTable.setSelectionMode(0);
        this.assertionsTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.assertionsTable.setEditable(false);
        this.assertionsTable.setGridColor(Color.BLACK);
        this.assertionsTable.addMouseListener(this.mouseAdapter);
        this.assertionsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)this.assertionEntryRenderer));
        this.assertionsForm.addComponent((JComponent)((Object)this.assertionsTable));
        return new JScrollPane(this.assertionsForm.getPanel());
    }

    private Component buildCategoriesList() {
        JPanel panel = new JPanel(new BorderLayout());
        this.categoriesTableModel = new AssertionCategoriesTableModel();
        this.categoriesTableModel.setLisetEntriesSet(this.categoriesAssertionsMap.keySet());
        this.categoriesListTable = new CategoriesListTable(this.categoriesTableModel);
        this.categoriesListTable.setTableHeader(null);
        this.categoriesListTable.setEditable(false);
        this.categoriesListTable.setGridColor(Color.BLACK);
        this.categoriesListTable.setSelectionMode(0);
        this.categoriesListTable.getSelectionModel().setSelectionInterval(0, 0);
        this.renderAssertions();
        this.populateSelectableCategoriesIndexes();
        this.categoriesListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                AddAssertionPanel.this.renderAssertionsTable();
            }
        });
        this.categoriesListTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)this.categoriesListRenderer));
        panel.add(new JScrollPane((Component)((Object)this.categoriesListTable)));
        return panel;
    }

    protected void renderAssertionsTable() {
        int selectedRow = this.categoriesListTable.getSelectedRow();
        if (selectedRow > -1) {
            this.selectedCategory = (String)this.categoriesListTable.getModel().getValueAt(selectedRow, 0);
            if (this.selectedCategory != null && this.categoriesAssertionsMap.containsKey(this.selectedCategory)) {
                this.assertions = this.categoriesAssertionsMap.get(this.selectedCategory);
                this.assertionsListTableModel.setListEntriesSet(this.assertions);
                this.renderAssertions();
                this.populateNonSelectableAssertionIndexes();
                this.assertionsListTableModel.fireTableDataChanged();
            }
        }
    }

    protected void renderCategoriesTable() {
        this.categoriesListRenderer.setAssertable(this.getAssertable());
        this.populateSelectableCategoriesIndexes();
        this.categoriesTableModel.fireTableDataChanged();
    }

    protected void renderAssertions() {
    }

    protected void populateNonSelectableAssertionIndexes() {
        this.getAssertionsTable().setSelectable(true);
        SortedSet<AssertionListEntry> assertionsList = this.getCategoriesAssertionsMap().get(this.getSelectedCategory());
        ArrayList<Integer> assertionsIndexList = new ArrayList<Integer>();
        for (int i = 0; i < assertionsList.size(); ++i) {
            AssertionListEntry assertionListEntry = (AssertionListEntry)assertionsList.toArray()[i];
            if (this.isAssertionApplicable(assertionListEntry.getTypeId())) continue;
            assertionsIndexList.add(i);
        }
        this.getAssertionsTable().setNonSelectableIndexes(assertionsIndexList);
    }

    protected void populateSelectableCategoriesIndexes() {
        this.getCategoriesListTable().setSelectable(true);
        ArrayList<Integer> categoriesIndexList = new ArrayList<Integer>();
        Set<String> ctgs = this.getCategoriesAssertionsMap().keySet();
        block0: for (int j = 0; j < ctgs.size(); ++j) {
            String selCat = (String)ctgs.toArray()[j];
            SortedSet<AssertionListEntry> assertionsList = this.getCategoriesAssertionsMap().get(selCat);
            for (int i = 0; i < assertionsList.size(); ++i) {
                AssertionListEntry assertionListEntry = (AssertionListEntry)assertionsList.toArray()[i];
                if (!this.isAssertionApplicable(assertionListEntry.getTypeId())) continue;
                categoriesIndexList.add(j);
                continue block0;
            }
        }
        this.getCategoriesListTable().setSelectableIndexes(categoriesIndexList);
    }

    protected boolean isAssertionApplicable(String assertionType) {
        return TestAssertionRegistry.getInstance().canAssert(assertionType, this.assertable);
    }

    protected boolean isAssertionApplicable(String assertionType, ModelItem modelItem, String property) {
        try {
            return TestAssertionRegistry.getInstance().canAssert(assertionType, this.assertable);
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            return false;
        }
    }

    protected void enableCategoriesList(boolean enable) {
        this.categoriesListTable.setEnabled(enable);
    }

    @Override
    protected boolean handleOk() {
        this.setVisible(false);
        int selectedRow = this.assertionsTable.getSelectedRow();
        String selection = ((AssertionListEntry)this.assertionsListTableModel.getValueAt(selectedRow, 0)).getName();
        if (selection == null) {
            return false;
        }
        if (!TestAssertionRegistry.getInstance().canAddMultipleAssertions(selection, this.assertable)) {
            UISupport.showErrorMessage("This assertion can only be added once");
            return false;
        }
        TestAssertion assertion = this.assertable.addAssertion(selection);
        if (assertion == null) {
            UISupport.showErrorMessage("Failed to add assertion");
            return false;
        }
        this.recentAssertionHandler.add(selection);
        if (assertion.isConfigurable()) {
            assertion.configure();
            return true;
        }
        return true;
    }

    @Override
    public ActionList buildActions(String url, boolean okAndCancel) {
        DefaultActionList actions = new DefaultActionList("Actions");
        if (url != null) {
            actions.addAction(new ShowOnlineHelpAction(url));
        }
        this.addAssertionAction = new AddAssertionAction();
        actions.addAction(this.addAssertionAction);
        if (okAndCancel) {
            actions.addAction(new SimpleDialog.CancelAction());
            actions.setDefaultAction(this.addAssertionAction);
        }
        return actions;
    }

    public void release() {
        this.assertionsTable.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.assertionsTable.removeMouseListener(this.mouseAdapter);
        this.hideDescCB.removeItemListener(this.hideDescListener);
    }

    protected boolean isHideDescriptionSelected() {
        return this.hideDescCB.isSelected();
    }

    @Override
    protected void beforeShow() {
        this.setSize(new Dimension(650, 500));
    }

    public void setCategoriesAssertionsMap(LinkedHashMap<String, SortedSet<AssertionListEntry>> categoriesAssertionsMap) {
        this.categoriesAssertionsMap = categoriesAssertionsMap;
    }

    public LinkedHashMap<String, SortedSet<AssertionListEntry>> getCategoriesAssertionsMap() {
        return this.categoriesAssertionsMap;
    }

    public AssertionsListTable getAssertionsTable() {
        return this.assertionsTable;
    }

    public CategoriesListTable getCategoriesListTable() {
        return this.categoriesListTable;
    }

    public AddAssertionAction getAddAssertionAction() {
        return this.addAssertionAction;
    }

    public void setSelectionListener(ListSelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    public class AssertionListMouseAdapter
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && !AddAssertionPanel.this.assertionsTable.getSelectionModel().isSelectionEmpty()) {
                AddAssertionPanel.this.handleOk();
            }
        }
    }

    protected class CategoryListRenderer
    extends DefaultCellRenderer {
        private static final long serialVersionUID = 1L;
        private Assertable assertable;

        protected CategoryListRenderer() {
        }

        public void setAssertable(Assertable assertable) {
            this.assertable = assertable;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String categoryName = (String)value;
            boolean disabled = true;
            Font boldFont = this.getFont().deriveFont(1);
            SortedSet assertions = (SortedSet)AddAssertionPanel.this.categoriesAssertionsMap.get(categoryName);
            for (AssertionListEntry assertionListEntry : assertions) {
                if (!AddAssertionPanel.this.isAssertionApplicable(assertionListEntry.getTypeId())) continue;
                disabled = false;
                break;
            }
            JLabel label = new JLabel(categoryName);
            SimpleForm form = new SimpleForm();
            form.addComponent(label);
            label.setFont(boldFont);
            if (disabled || !((CategoriesListTable)((Object)table)).isSelectable(row)) {
                label.setForeground(Color.GRAY);
            }
            if (isSelected) {
                form.getPanel().setBackground(Color.LIGHT_GRAY);
            } else {
                form.getPanel().setBackground(Color.WHITE);
            }
            return form.getPanel();
        }
    }

    protected class AssertionEntryRenderer
    extends DefaultCellRenderer {
        private static final long serialVersionUID = -6843334509897580699L;
        private Assertable assertable;
        private Font boldFont;

        protected AssertionEntryRenderer() {
        }

        public void setAssertable(Assertable assertable) {
            this.assertable = assertable;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.boldFont = this.getFont().deriveFont(1);
            AssertionListEntry entry = (AssertionListEntry)value;
            String type = TestAssertionRegistry.getInstance().getAssertionTypeForName(entry.getName());
            boolean canAssert = false;
            boolean disable = true;
            if (type != null && this.assertable != null && this.assertable.getModelItem() != null) {
                canAssert = AddAssertionPanel.this.isAssertionApplicable(type, this.assertable.getModelItem(), AddAssertionPanel.this.getSelectedPropertyName());
                disable = !AddAssertionPanel.this.categoriesListTable.isEnabled() || !canAssert;
            }
            String str = entry.getName();
            JLabel label = new JLabel(str);
            label.setFont(this.boldFont);
            JTextArea descText = new JTextArea(((AssertionListEntry)value).getDescription());
            descText.setSize(new Dimension(80, 20));
            descText.setLineWrap(true);
            descText.setWrapStyleWord(true);
            JLabel disabledInfo = new JLabel("Not applicable with selected Source and Property");
            descText.setFont(disabledInfo.getFont());
            if (disable) {
                label.setForeground(Color.LIGHT_GRAY);
                descText.setForeground(Color.LIGHT_GRAY);
                disabledInfo.setForeground(Color.LIGHT_GRAY);
            }
            SimpleForm form = new SimpleForm();
            form.addComponent(label);
            if (!AddAssertionPanel.this.isHideDescriptionSelected()) {
                form.addComponent(descText);
                AddAssertionPanel.this.getAssertionsTable().setRowHeight(70);
            } else {
                if (disable) {
                    form.addComponent(disabledInfo);
                }
                AddAssertionPanel.this.getAssertionsTable().setRowHeight(40);
            }
            if (isSelected) {
                descText.setBackground(Color.LIGHT_GRAY);
                form.getPanel().setBackground(Color.LIGHT_GRAY);
            } else {
                descText.setBackground(Color.WHITE);
                form.getPanel().setBackground(Color.WHITE);
            }
            return form.getPanel();
        }
    }

    private class InternalHideDescListener
    implements ItemListener {
        private InternalHideDescListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            AddAssertionPanel.this.assertionsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)AddAssertionPanel.this.assertionEntryRenderer));
            AddAssertionPanel.this.assertionsListTableModel.fireTableDataChanged();
            SoapUI.getSettings().setBoolean(AssertionDescriptionSettings.SHOW_ASSERTION_DESCRIPTION, arg0.getStateChange() == 1);
        }
    }

    private class InternalListSelectionListener
    implements ListSelectionListener {
        private InternalListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (AddAssertionPanel.this.assertionsTable.getSelectedRow() >= 0) {
                AddAssertionPanel.this.addAssertionAction.setEnabled(true);
            } else {
                AddAssertionPanel.this.addAssertionAction.setEnabled(false);
            }
        }
    }

    protected final class AddAssertionAction
    extends AbstractAction {
        private static final long serialVersionUID = 4741995448420710392L;

        public AddAssertionAction() {
            super("Add");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddAssertionPanel.this.handleOk();
        }
    }
}

