/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.monitor.SoapMonitorAction;
import com.eviware.soapui.impl.wsdl.monitor.ContentTypes;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorEngine;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitorListenerCallBack;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.JettyServer;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.ProxyServlet;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.TunnelServlet;
import com.eviware.soapui.monitor.SoapUIJettyThreadPool;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import java.net.BindException;
import javax.servlet.Servlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class SoapMonitorEngineImpl
implements SoapMonitorEngine {
    private static final String ROOT = "/";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    JettyServer server = new JettyServer();
    SocketConnector connector = new SocketConnector();
    private SslSocketConnector sslConnector;
    private final String sslEndpoint;
    private boolean proxyOrTunnel = true;
    private ContentTypes includedContentTypes = SoapMonitorAction.defaultContentTypes();

    public SoapMonitorEngineImpl(String sslEndpoint) {
        this.sslEndpoint = sslEndpoint;
    }

    @Override
    public boolean isRunning() {
        return this.server.isRunning();
    }

    @Override
    public void start(WsdlProject project, int localPort, SoapMonitorListenerCallBack listenerCallBack) {
        XmlBeansSettingsImpl settings = project.getSettings();
        this.server.setThreadPool(new SoapUIJettyThreadPool());
        Context context = new Context((HandlerContainer)this.server, ROOT, 0);
        if (!StringUtils.isNullOrEmpty(this.sslEndpoint)) {
            TunnelServlet tunnelServlet;
            if (this.sslEndpoint.startsWith(HTTPS)) {
                this.sslConnector = new SslSocketConnector();
                this.sslConnector.setKeystore(settings.getString("HTTP tunnel - KeyStore", "JKS"));
                this.sslConnector.setPassword(settings.getString("HTTP tunnel - Password", ""));
                this.sslConnector.setKeyPassword(settings.getString("HTTP tunnel - KeyPassword", ""));
                this.sslConnector.setTruststore(settings.getString("HTTP tunnel - TrustStore", "JKS"));
                this.sslConnector.setTrustPassword(settings.getString("HTTP tunnel - TrustStore Password", ""));
                this.sslConnector.setNeedClientAuth(false);
                this.sslConnector.setMaxIdleTime(30000);
                this.sslConnector.setPort(localPort);
                this.server.addConnector((Connector)this.sslConnector);
                tunnelServlet = new TunnelServlet(project, this.sslEndpoint, listenerCallBack);
                tunnelServlet.setIncludedContentTypes(this.includedContentTypes);
                context.addServlet(new ServletHolder((Servlet)tunnelServlet), ROOT);
            } else if (this.sslEndpoint.startsWith(HTTP)) {
                this.connector.setPort(localPort);
                this.server.addConnector((Connector)this.connector);
                tunnelServlet = new TunnelServlet(project, this.sslEndpoint, listenerCallBack);
                tunnelServlet.setIncludedContentTypes(this.includedContentTypes);
                context.addServlet(new ServletHolder((Servlet)tunnelServlet), ROOT);
            } else {
                UISupport.showErrorMessage("Unsupported/unknown protocol tunnel will not start");
                return;
            }
            this.proxyOrTunnel = false;
        } else {
            this.proxyOrTunnel = true;
            this.connector.setPort(localPort);
            this.server.addConnector((Connector)this.connector);
            ProxyServlet proxyServlet = new ProxyServlet(project, listenerCallBack);
            proxyServlet.setIncludedContentTypes(this.includedContentTypes);
            context.addServlet(new ServletHolder((Servlet)proxyServlet), ROOT);
        }
        try {
            this.server.start();
        }
        catch (BindException e) {
            UISupport.showErrorMessage("Error starting " + this.getProxyOrTunnelString() + ": Could not open port " + localPort + ".\nTry a different port number.");
        }
        catch (Exception e) {
            UISupport.showErrorMessage("Error starting " + this.getProxyOrTunnelString() + ": " + e.getMessage());
        }
    }

    private String getProxyOrTunnelString() {
        return this.proxyOrTunnel ? "proxy" : "tunnel";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.server != null) {
                this.server.destroy();
            }
        }
    }

    @Override
    public void setIncludedContentTypes(ContentTypes includedContentTypes) {
        this.includedContentTypes = includedContentTypes;
    }

    @Override
    public boolean isProxy() {
        return this.proxyOrTunnel;
    }
}

