/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CaptureInputStream
extends FilterInputStream {
    private final ByteArrayOutputStream capture = new ByteArrayOutputStream();
    private long maxData = 0L;
    private boolean inCapture;

    public CaptureInputStream(InputStream in, long maxData) {
        super(in);
        this.maxData = maxData;
    }

    public CaptureInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.inCapture) {
            return super.read();
        }
        this.inCapture = true;
        int i = super.read();
        if (i != -1 && (this.maxData == 0L || (long)this.capture.size() < this.maxData)) {
            this.capture.write(i);
        }
        this.inCapture = false;
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.inCapture) {
            return super.read(b);
        }
        this.inCapture = true;
        int i = super.read(b);
        if (i > 0) {
            if (this.maxData == 0L) {
                this.capture.write(b, 0, i);
            } else if (i > 0 && this.maxData > 0L && (long)this.capture.size() < this.maxData) {
                if ((long)(i + this.capture.size()) < this.maxData) {
                    this.capture.write(b, 0, i);
                } else {
                    this.capture.write(b, 0, (int)(this.maxData - (long)this.capture.size()));
                }
            }
        }
        this.inCapture = false;
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inCapture) {
            return super.read(b, off, len);
        }
        this.inCapture = true;
        int i = super.read(b, off, len);
        if (i > 0) {
            if (this.maxData == 0L) {
                this.capture.write(b, off, i);
            } else if (i > 0 && this.maxData > 0L && (long)this.capture.size() < this.maxData) {
                if ((long)(i + this.capture.size()) < this.maxData) {
                    this.capture.write(b, off, i);
                } else {
                    this.capture.write(b, off, (int)(this.maxData - (long)this.capture.size()));
                }
            }
            this.inCapture = false;
        }
        return i;
    }

    public byte[] getCapturedData() {
        return this.capture.toByteArray();
    }
}

