/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockOperationDocumentConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.support.AbstractMockService;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockDispatcher;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockDispatcher;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class WsdlMockService
extends AbstractMockService<WsdlMockOperation, MockServiceConfig> {
    private static final String REQUIRE_SOAP_VERSION = WsdlMockService.class.getName() + "@require-soap-version";
    private static final String REQUIRE_SOAP_ACTION = WsdlMockService.class.getName() + "@require-soap-action";
    public static final String INCOMING_WSS = WsdlMockService.class.getName() + "@incoming-wss";
    public static final String OUTGOING_WSS = WsdlMockService.class.getName() + "@outgoing-wss";
    private WsdlMockOperation faultMockOperation;
    private String mockServiceEndpoint;
    public static final String ICON_NAME = "/soap_virt.png";
    public static final String STRING_ID = "MOCK";

    @Override
    public String getStringID() {
        return STRING_ID;
    }

    public WsdlMockService(Project project, MockServiceConfig config) {
        super(config, (ModelItem)project, ICON_NAME);
        List<MockOperationConfig> testStepConfigs = config.getMockOperationList();
        for (MockOperationConfig tsc : testStepConfigs) {
            WsdlMockOperation testStep = new WsdlMockOperation(this, tsc);
            this.addMockOperation(testStep);
        }
        if (!this.getSettings().isSet(REQUIRE_SOAP_ACTION)) {
            this.setRequireSoapAction(false);
        }
        for (MockRunListener listener : SoapUI.getListenerRegistry().getListeners(MockRunListener.class)) {
            this.addMockRunListener(listener);
        }
        if (!((MockServiceConfig)this.getConfig()).isSetProperties()) {
            ((MockServiceConfig)this.getConfig()).addNewProperties();
        }
        this.setPropertiesConfig(((MockServiceConfig)this.getConfig()).getProperties());
        if (((MockServiceConfig)this.getConfig()).isSetFaultMockOperation()) {
            this.faultMockOperation = (WsdlMockOperation)this.getMockOperationByName(((MockServiceConfig)this.getConfig()).getFaultMockOperation());
        }
    }

    public WsdlMockOperation getMockOperation(Operation operation) {
        for (int c = 0; c < this.getMockOperationCount(); ++c) {
            WsdlMockOperation mockOperation = (WsdlMockOperation)this.getMockOperationAt(c);
            if (mockOperation.getOperation() != operation) continue;
            return mockOperation;
        }
        return null;
    }

    @Override
    public MockOperation addNewMockOperation(Operation operation) {
        if (this.getMockOperation(operation) != null) {
            return null;
        }
        MockOperationConfig config = ((MockServiceConfig)this.getConfig()).addNewMockOperation();
        config.setName(operation.getName());
        WsdlMockOperation mockOperation = new WsdlMockOperation(this, config, (WsdlOperation)operation);
        this.addMockOperation(mockOperation);
        this.fireMockOperationAdded(mockOperation);
        return mockOperation;
    }

    @Override
    public void setPort(int port) {
        String oldEndpoint = this.getLocalEndpoint();
        int oldPort = this.getPort();
        if (port != oldPort) {
            super.setPort(port);
            for (WsdlInterface iface : this.getMockedInterfaces()) {
                if (!Arrays.asList(iface.getEndpoints()).contains(oldEndpoint)) continue;
                iface.changeEndpoint(oldEndpoint, this.getLocalEndpoint());
            }
        }
    }

    public WsdlInterface[] getMockedInterfaces() {
        HashSet<WsdlInterface> result = new HashSet<WsdlInterface>();
        for (MockOperation mockOperation : this.getMockOperationList()) {
            WsdlOperation operation = (WsdlOperation)mockOperation.getOperation();
            if (operation == null) continue;
            result.add(operation.getInterface());
        }
        return result.toArray(new WsdlInterface[result.size()]);
    }

    @Override
    public void release() {
        super.release();
        for (MockOperation operation : this.getMockOperationList()) {
            operation.release();
        }
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public MockDispatcher createDispatcher(WsdlMockRunContext mockContext) {
        return new WsdlMockDispatcher(this, mockContext);
    }

    @Override
    public void setPath(String path) {
        String oldEndpoint = this.getLocalEndpoint();
        String oldPath = this.getPath();
        if (!path.equals(oldPath)) {
            super.setPath(path);
            for (WsdlInterface iface : this.getMockedInterfaces()) {
                if (!Arrays.asList(iface.getEndpoints()).contains(oldEndpoint)) continue;
                iface.changeEndpoint(oldEndpoint, this.getLocalEndpoint());
            }
        }
    }

    public WsdlMockOperation getFaultMockOperation() {
        return this.faultMockOperation;
    }

    public void setFaultMockOperation(WsdlMockOperation mockOperation) {
        this.faultMockOperation = mockOperation;
        if (this.faultMockOperation == null) {
            if (((MockServiceConfig)this.getConfig()).isSetFaultMockOperation()) {
                ((MockServiceConfig)this.getConfig()).unsetFaultMockOperation();
            }
        } else {
            ((MockServiceConfig)this.getConfig()).setFaultMockOperation(this.faultMockOperation.getName());
        }
    }

    @Override
    public String getHost() {
        return ((MockServiceConfig)this.getConfig()).getHost();
    }

    public boolean isRequireSoapVersion() {
        return this.getSettings().getBoolean(REQUIRE_SOAP_VERSION);
    }

    public void setRequireSoapVersion(boolean requireSoapVersion) {
        this.getSettings().setBoolean(REQUIRE_SOAP_VERSION, requireSoapVersion);
    }

    public boolean isRequireSoapAction() {
        return this.getSettings().getBoolean(REQUIRE_SOAP_ACTION);
    }

    public void setRequireSoapAction(boolean requireSoapAction) {
        this.getSettings().setBoolean(REQUIRE_SOAP_ACTION, requireSoapAction);
    }

    public boolean hasMockOperation(Operation operation) {
        return this.getMockOperation(operation) != null;
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.mockOperations;
    }

    public String getIncomingWss() {
        return ((MockServiceConfig)this.getConfig()).getIncomingWss();
    }

    public void setIncomingWss(String incomingWss) {
        String old = this.getIncomingWss();
        ((MockServiceConfig)this.getConfig()).setIncomingWss(incomingWss);
        this.notifyPropertyChanged(INCOMING_WSS, old, incomingWss);
    }

    public String getOutgoingWss() {
        return ((MockServiceConfig)this.getConfig()).getOutgoingWss();
    }

    public void setOutgoingWss(String outgoingWss) {
        String old = this.getOutgoingWss();
        ((MockServiceConfig)this.getConfig()).setOutgoingWss(outgoingWss);
        this.notifyPropertyChanged(OUTGOING_WSS, old, outgoingWss);
    }

    public List<WsdlOperation> getMockedOperations() {
        ArrayList<WsdlOperation> result = new ArrayList<WsdlOperation>();
        for (MockOperation mockOperation : this.mockOperations) {
            result.add((WsdlOperation)mockOperation.getOperation());
        }
        return result;
    }

    public void replace(WsdlMockOperation mockOperation, MockOperationConfig reloadedMockOperation) {
        int ix = this.mockOperations.indexOf(mockOperation);
        if (ix == -1) {
            throw new RuntimeException("Unkonws MockOperation specified to removeMockOperation");
        }
        this.mockOperations.remove(ix);
        this.fireMockOperationRemoved(mockOperation);
        mockOperation.release();
        ((MockServiceConfig)this.getConfig()).removeMockOperation(ix);
        MockOperationConfig newConfig = (MockOperationConfig)((MockServiceConfig)this.getConfig()).insertNewMockOperation(ix).set(reloadedMockOperation).changeType(MockOperationConfig.type);
        WsdlMockOperation newOperation = new WsdlMockOperation(this, newConfig);
        this.mockOperations.add(ix, newOperation);
        newOperation.afterLoad();
        this.fireMockOperationAdded(newOperation);
    }

    public void export(File file) {
        try {
            ((MockServiceConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importMockOperation(File file) {
        MockOperationConfig mockOperationNewConfig = null;
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading mock operation.");
            return;
        }
        try {
            mockOperationNewConfig = MockOperationDocumentConfig.Factory.parse(file).getMockOperation();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (mockOperationNewConfig != null) {
            MockOperationConfig newConfig = (MockOperationConfig)((MockServiceConfig)this.getConfig()).addNewMockOperation().set(mockOperationNewConfig).changeType(TestCaseConfig.type);
            WsdlMockOperation newMockOperation = new WsdlMockOperation(this, newConfig);
            ModelSupport.createNewIds(newMockOperation);
            newMockOperation.afterLoad();
            this.mockOperations.add(newMockOperation);
            this.fireMockOperationAdded(newMockOperation);
            this.resolveImportedMockOperation(newMockOperation);
        } else {
            UISupport.showErrorMessage("Not valid mock operation xml");
        }
    }

    private void resolveImportedMockOperation(WsdlMockOperation mockOperation) {
        ResolveDialog resolver = new ResolveDialog("Validate MockOperation", "Checks MockOperation for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(mockOperation);
    }

    public String toString() {
        return this.getName();
    }

    public String getMockServiceEndpoint() {
        return this.mockServiceEndpoint;
    }

    public void setMockServiceEndpoint(String mockServiceEndpoint) {
        this.mockServiceEndpoint = mockServiceEndpoint;
    }

    public String getLocalMockServiceEndpoint() {
        if (this.mockServiceEndpoint != null) {
            return this.mockServiceEndpoint + this.getPath();
        }
        String host = this.getHost();
        if (StringUtils.isNullOrEmpty(host)) {
            host = "127.0.0.1";
        }
        int port = (int)(this.getSettings().getBoolean(SSLSettings.ENABLE_MOCK_SSL) ? this.getSettings().getLong(SSLSettings.MOCK_PORT, 443L) : (long)this.getPort());
        return this.getProtocol() + host + ":" + port + this.getPath();
    }

    @Override
    public boolean canIAddAMockOperation(WsdlMockOperation mockOperation) {
        return ((MockServiceConfig)this.getConfig()).getMockOperationList().contains(mockOperation.getConfig());
    }

    @Override
    public String getHelpUrl() {
        return "/Service-Mocking/mocking-soap-services.html";
    }
}

