/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockOperationConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.impl.support.AbstractMockOperation;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.support.CompressedStringSupport;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.InterfaceListener;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.project.ProjectListener;
import com.eviware.soapui.model.support.InterfaceListenerAdapter;
import com.eviware.soapui.model.support.ProjectListenerAdapter;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.UISupport;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class WsdlMockOperation
extends AbstractMockOperation<MockOperationConfig, WsdlMockResponse> {
    private static final Logger log = Logger.getLogger(WsdlMockOperation.class);
    public static final String OPERATION_PROPERTY = WsdlMockOperation.class.getName() + "@operation";
    public static final String ICON_NAME = "/mockOperation.gif";
    private WsdlOperation operation;
    private InterfaceListener interfaceListener = new InternalInterfaceListener();
    private ProjectListener projectListener = new InternalProjectListener();
    private ImageIcon oneWayIcon;
    private ImageIcon notificationIcon;
    private ImageIcon solicitResponseIcon;

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config) {
        super(config, mockService, ICON_NAME);
        Interface iface = mockService.getProject().getInterfaceByName(config.getInterface());
        if (iface == null) {
            SoapUI.log.warn((Object)("Missing interface [" + config.getInterface() + "] for MockOperation in project"));
        } else {
            this.operation = (WsdlOperation)iface.getOperationByName(config.getOperation());
        }
        List<MockResponseConfig> responseConfigs = config.getResponseList();
        for (MockResponseConfig responseConfig : responseConfigs) {
            WsdlMockResponse wsdlMockResponse = new WsdlMockResponse(this, responseConfig);
            wsdlMockResponse.addPropertyChangeListener(this);
            super.addMockResponse(wsdlMockResponse);
        }
        this.setupConfig(config);
    }

    public WsdlMockOperation(WsdlMockService mockService, MockOperationConfig config, WsdlOperation operation) {
        super(config, mockService, ICON_NAME);
        this.operation = operation;
        config.setInterface(operation.getInterface().getName());
        config.setOperation(operation.getName());
        this.setupConfig(config);
    }

    @Override
    protected void setupConfig(MockOperationConfig config) {
        if (!((MockOperationConfig)this.getConfig()).isSetDispatchConfig()) {
            ((MockOperationConfig)this.getConfig()).addNewDispatchConfig();
        }
        super.setupConfig(config);
        this.createIcons();
        this.addListeners();
    }

    private void addListeners() {
        WsdlOperation operation = this.getOperation();
        if (operation != null) {
            operation.getInterface().getProject().addProjectListener(this.projectListener);
            operation.getInterface().addInterfaceListener(this.interfaceListener);
            operation.getInterface().addPropertyChangeListener(WsdlInterface.NAME_PROPERTY, this);
        }
    }

    private void createIcons() {
        this.oneWayIcon = UISupport.createImageIcon("/onewaymockoperation.gif");
        this.notificationIcon = UISupport.createImageIcon("/mocknotificationoperation.gif");
        this.solicitResponseIcon = UISupport.createImageIcon("/mocksolicitresponseoperation.gif");
    }

    @Override
    public ImageIcon getIcon() {
        if (this.operation != null) {
            if (this.isOneWay()) {
                return this.oneWayIcon;
            }
            if (this.isNotification()) {
                return this.notificationIcon;
            }
            if (this.isSolicitResponse()) {
                return this.solicitResponseIcon;
            }
        }
        return super.getIcon();
    }

    @Override
    public WsdlMockService getMockService() {
        return (WsdlMockService)this.getParent();
    }

    @Override
    public WsdlOperation getOperation() {
        return this.operation;
    }

    @Override
    public String getScriptHelpUrl() {
        return "/soap-mocking/working-with-mockservices.html";
    }

    @Override
    public MockResponse addNewMockResponse(String name) {
        return this.addNewMockResponse(name, true);
    }

    public WsdlMockResponse addNewMockResponse(MockResponseConfig responseConfig) {
        WsdlMockResponse mockResponse = new WsdlMockResponse(this, responseConfig);
        super.addMockResponse(mockResponse);
        if (this.getMockResponseCount() == 1) {
            this.setDefaultResponse(mockResponse.getName());
        }
        WsdlUtils.setDefaultWsaAction(mockResponse.getWsaConfig(), true);
        this.getMockService().fireMockResponseAdded(mockResponse);
        this.notifyPropertyChanged("mockResponses", null, mockResponse);
        return mockResponse;
    }

    public WsdlMockResponse addNewMockResponse(String name, boolean createResponse) {
        MockResponseConfig responseConfig = ((MockOperationConfig)this.getConfig()).addNewResponse();
        responseConfig.setName(name);
        responseConfig.addNewResponseContent();
        if (createResponse && this.getOperation() != null && this.getOperation().isBidirectional()) {
            boolean createOptional = SoapUI.getSettings().getBoolean(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS);
            CompressedStringSupport.setString(responseConfig.getResponseContent(), this.getOperation().createResponse(createOptional));
        }
        return this.addNewMockResponse(responseConfig);
    }

    public WsdlMockResult dispatchRequest(WsdlMockRequest request) throws DispatchException {
        try {
            request.setOperation(this.getOperation());
            WsdlMockResult result = new WsdlMockResult(request);
            if (this.getMockResponseCount() == 0) {
                throw new DispatchException("Missing MockResponse(s) in MockOperation [" + this.getName() + "]");
            }
            result.setMockOperation(this);
            WsdlMockResponse response = (WsdlMockResponse)this.getDispatcher().selectMockResponse(request, result);
            if (response == null) {
                response = (WsdlMockResponse)this.getMockResponseByName(this.getDefaultResponse());
            }
            if (response == null) {
                throw new DispatchException("Failed to find MockResponse");
            }
            result.setMockResponse(response);
            response.execute(request, result);
            return result;
        }
        catch (Throwable e) {
            if (e instanceof DispatchException) {
                throw (DispatchException)e;
            }
            throw new DispatchException(e);
        }
    }

    @Override
    public MockOperationDispatcher setDispatchStyle(String dispatchStyle) {
        if (!((MockOperationConfig)this.getConfig()).isSetDispatchConfig()) {
            ((MockOperationConfig)this.getConfig()).addNewDispatchConfig();
        }
        return super.setDispatchStyle(dispatchStyle);
    }

    @Override
    public void release() {
        super.release();
        if (this.getDispatcher() != null) {
            this.getDispatcher().release();
        }
        for (MockResponse response : this.getMockResponses()) {
            response.removePropertyChangeListener(this);
            response.release();
        }
        if (this.operation != null) {
            this.operation.getInterface().getProject().removeProjectListener(this.projectListener);
            this.operation.getInterface().removeInterfaceListener(this.interfaceListener);
            this.operation.getInterface().removePropertyChangeListener(WsdlInterface.NAME_PROPERTY, this);
        }
    }

    public String getWsdlOperationName() {
        return this.operation.getName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getPropertyName().equals(WsdlMockResponse.NAME_PROPERTY)) {
            if (arg0.getOldValue().equals(this.getDefaultResponse())) {
                this.setDefaultResponse(arg0.getNewValue().toString());
            }
        } else if (arg0.getPropertyName().equals(WsdlInterface.NAME_PROPERTY)) {
            ((MockOperationConfig)this.getConfig()).setInterface(arg0.getNewValue().toString());
        }
    }

    public void setOperation(WsdlOperation operation) {
        WsdlOperation oldOperation = this.getOperation();
        if (operation == null) {
            ((MockOperationConfig)this.getConfig()).unsetInterface();
            ((MockOperationConfig)this.getConfig()).unsetOperation();
        } else {
            ((MockOperationConfig)this.getConfig()).setInterface(operation.getInterface().getName());
            ((MockOperationConfig)this.getConfig()).setOperation(operation.getName());
        }
        this.operation = operation;
        this.notifyPropertyChanged(OPERATION_PROPERTY, oldOperation, operation);
    }

    @Override
    public void removeResponseFromConfig(int index) {
        ((MockOperationConfig)this.getConfig()).removeResponse(index);
    }

    public boolean isOneWay() {
        return this.operation == null ? false : this.operation.isOneWay();
    }

    public boolean isNotification() {
        return this.operation == null ? false : this.operation.isNotification();
    }

    public boolean isSolicitResponse() {
        return this.operation == null ? false : this.operation.isSolicitResponse();
    }

    public boolean isUnidirectional() {
        return this.operation == null ? false : this.operation.isUnidirectional();
    }

    public boolean isBidirectional() {
        return !this.isUnidirectional();
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getMockResponses();
    }

    public void exportMockOperation(File file) {
        try {
            ((MockOperationConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class InternalProjectListener
    extends ProjectListenerAdapter {
        private InternalProjectListener() {
        }

        @Override
        public void interfaceRemoved(Interface iface) {
            if (WsdlMockOperation.this.operation.getInterface() == iface) {
                WsdlMockOperation.this.getMockService().removeMockOperation(WsdlMockOperation.this);
            }
        }

        @Override
        public void interfaceUpdated(Interface iface) {
            if (WsdlMockOperation.this.operation.getInterface() == iface) {
                ((MockOperationConfig)WsdlMockOperation.this.getConfig()).setInterface(iface.getName());
            }
        }
    }

    private class InternalInterfaceListener
    extends InterfaceListenerAdapter {
        private InternalInterfaceListener() {
        }

        @Override
        public void operationUpdated(Operation operation) {
            if (operation == WsdlMockOperation.this.operation) {
                ((MockOperationConfig)WsdlMockOperation.this.getConfig()).setOperation(operation.getName());
            }
        }

        @Override
        public void operationRemoved(Operation operation) {
            if (operation == WsdlMockOperation.this.operation) {
                WsdlMockOperation.this.getMockService().removeMockOperation(WsdlMockOperation.this);
            }
        }
    }
}

