/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.definition.export.WsdlDefinitionExporter;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.soap.SoapUtils;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.impl.wsdl.support.wsdl.WsdlUtils;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.support.AbstractMockDispatcher;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.editor.inspectors.attachments.ContentTypeHandler;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Request;
import org.xml.sax.InputSource;

public class WsdlMockDispatcher
extends AbstractMockDispatcher {
    private WsdlMockService mockService;
    private WsdlMockRunContext mockContext;
    private final Map<String, StringToStringMap> wsdlCache = new HashMap<String, StringToStringMap>();
    private static final Logger log = Logger.getLogger(WsdlMockDispatcher.class);

    public WsdlMockDispatcher(WsdlMockService mockService, WsdlMockRunContext mockContext) {
        this.mockService = mockService;
        this.mockContext = mockContext;
        this.initWsdlCache();
    }

    private void initWsdlCache() {
        for (WsdlInterface iface : this.mockService.getMockedInterfaces()) {
            if (!iface.getInterfaceType().equals("wsdl")) continue;
            try {
                WsdlDefinitionExporter exporter = new WsdlDefinitionExporter(iface);
                String wsdlPrefix = this.trimLastSlash(this.getInterfacePrefix(iface));
                StringToStringMap parts = exporter.createFilesForExport(wsdlPrefix + "&part=");
                for (Map.Entry partEntry : parts.entrySet()) {
                    InputSource inputSource;
                    String content;
                    if (!((String)partEntry.getKey()).toLowerCase().endsWith(".wsdl") || (content = WsdlUtils.replacePortEndpoint(iface, inputSource = new InputSource(new StringReader((String)partEntry.getValue())), this.mockService.getLocalMockServiceEndpoint())) == null) continue;
                    parts.put(partEntry.getKey(), content);
                }
                this.wsdlCache.put(iface.getName(), parts);
                log.info((Object)("Mounted WSDL for interface [" + iface.getName() + "] at [" + this.getOverviewUrl() + "]"));
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
    }

    @Override
    public MockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        MockResult mockResult;
        Object result = null;
        try {
            WsdlMockRequest mockRequest = new WsdlMockRequest(request, response, this.mockContext);
            result = this.mockService.runOnRequestScript(this.mockContext, mockRequest);
            if (!(result instanceof MockResult)) {
                result = mockRequest.getMethod() == RestRequestInterface.HttpMethod.POST ? this.dispatchPostRequest(mockRequest) : super.dispatchRequest(request, response);
            }
            this.mockService.runAfterRequestScript(this.mockContext, (MockResult)result);
            mockResult = (MockResult)result;
        }
        catch (Throwable e) {
            try {
                if (e instanceof DispatchException) {
                    throw (DispatchException)e;
                }
                throw new DispatchException(e);
            }
            catch (Throwable throwable) {
                this.mockService.fireOnMockResult(result);
                throw throwable;
            }
        }
        this.mockService.fireOnMockResult(result);
        return mockResult;
    }

    @Override
    public MockResult dispatchGetRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        try {
            String qs = request.getQueryString();
            if (qs != null && qs.toUpperCase().startsWith("WSDL")) {
                this.dispatchWsdlRequest(request, response);
            } else {
                String docroot = PropertyExpander.expandProperties(this.mockContext, this.mockService.getDocroot());
                if (StringUtils.hasContent(docroot)) {
                    try {
                        String filename;
                        File file;
                        String pathInfo = request.getPathInfo();
                        if (pathInfo == null) {
                            pathInfo = "";
                        }
                        if (this.mockService.getPath().length() > 1 && pathInfo.startsWith(this.mockService.getPath())) {
                            pathInfo = pathInfo.substring(this.mockService.getPath().length());
                        }
                        if ((file = new File(filename = docroot + pathInfo.replace('/', File.separatorChar))).exists()) {
                            this.returnFile(response, file);
                        }
                    }
                    catch (Throwable e) {
                        throw new DispatchException(e);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new DispatchException(e);
        }
    }

    public WsdlMockResult dispatchPostRequest(WsdlMockRequest mockRequest) throws Exception {
        WsdlMockResult result = null;
        try {
            long timestamp = System.currentTimeMillis();
            SoapVersion soapVersion = mockRequest.getSoapVersion();
            if (soapVersion == null) {
                throw new DispatchException("Unrecognized SOAP Version");
            }
            String soapAction = mockRequest.getSoapAction();
            WsdlOperation operation = null;
            if (SoapUtils.isSoapFault(mockRequest.getRequestContent(), soapVersion)) {
                WsdlMockOperation faultMockOperation = this.mockService.getFaultMockOperation();
                if (faultMockOperation != null) {
                    operation = faultMockOperation.getOperation();
                }
            } else {
                try {
                    operation = SoapUtils.findOperationForRequest(soapVersion, soapAction, mockRequest.getRequestXmlObject(), this.mockService.getMockedOperations(), this.mockService.isRequireSoapVersion(), this.mockService.isRequireSoapAction(), mockRequest.getRequestAttachments());
                }
                catch (Exception e) {
                    if (this.mockService.isDispatchResponseMessages()) {
                        try {
                            operation = SoapUtils.findOperationForResponse(soapVersion, soapAction, mockRequest.getRequestXmlObject(), this.mockService.getMockedOperations(), this.mockService.isRequireSoapVersion(), this.mockService.isRequireSoapAction());
                            if (operation != null) {
                                mockRequest.setResponseMessage(true);
                            }
                        }
                        catch (Exception e2) {
                            throw e;
                        }
                    }
                    throw e;
                }
            }
            if (operation != null) {
                WsdlMockOperation mockOperation = this.mockService.getMockOperation(operation);
                if (mockOperation != null) {
                    long startTime = System.nanoTime();
                    result = mockOperation.dispatchRequest(mockRequest);
                    if (mockRequest.getHttpRequest() instanceof Request) {
                        ((Request)mockRequest.getHttpRequest()).setHandled(true);
                    }
                    result.setTimeTaken((System.nanoTime() - startTime) / 1000000L);
                    result.setTimestamp(timestamp);
                    this.addMockResult(result);
                    return result;
                }
                throw new DispatchException("Failed to find matching operation for request");
            }
            throw new DispatchException("Missing operation for soapAction [" + soapAction + "] and body element [" + XmlUtils.getQName(mockRequest.getContentElement()) + "] with SOAP Version [" + mockRequest.getSoapVersion() + "]");
        }
        catch (Exception e) {
            if (e instanceof DispatchException) {
                throw e;
            }
            throw new DispatchException(e);
        }
    }

    @Override
    public MockResult dispatchHeadRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        response.setStatus(200);
        return null;
    }

    protected void dispatchWsdlRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String content;
        if (request.getQueryString().equalsIgnoreCase("WSDL")) {
            this.printWsdl(response);
            return;
        }
        String ifaceName = request.getParameter("interface");
        WsdlInterface iface = (WsdlInterface)this.mockService.getProject().getInterfaceByName(ifaceName);
        if (iface == null) {
            this.printInterfaceList(response);
            return;
        }
        StringToStringMap parts = this.wsdlCache.get(iface.getName());
        String part = request.getParameter("part");
        String string = content = StringUtils.isNullOrEmpty(part) ? null : (String)parts.get(part);
        if (content == null) {
            this.printPartList(iface, parts, response);
            return;
        }
        if (content != null) {
            this.printOkXmlResult(response, content);
        }
    }

    public void release() {
        this.clearResults();
        this.mockContext.clear();
    }

    public void printWsdl(HttpServletResponse response) throws IOException {
        WsdlInterface[] mockedInterfaces = this.mockService.getMockedInterfaces();
        if (mockedInterfaces.length == 1) {
            StringToStringMap parts = this.wsdlCache.get(mockedInterfaces[0].getName());
            this.printOkXmlResult(response, (String)parts.get(parts.get("#root#")));
        } else {
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                Definition def = wsdlFactory.newDefinition();
                for (WsdlInterface iface : mockedInterfaces) {
                    StringToStringMap parts = this.wsdlCache.get(iface.getName());
                    Import wsdlImport = def.createImport();
                    wsdlImport.setLocationURI(this.getInterfacePrefix(iface) + "&part=" + (String)parts.get("#root#"));
                    wsdlImport.setNamespaceURI(WsdlUtils.getTargetNamespace(iface.getWsdlContext().getDefinition()));
                    def.addImport(wsdlImport);
                }
                response.setStatus(200);
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                WSDLWriter writer = wsdlFactory.newWSDLWriter();
                writer.writeWSDL(def, (Writer)response.getWriter());
            }
            catch (Exception e) {
                SoapUI.logError(e);
                throw new IOException("Failed to create combined WSDL");
            }
        }
    }

    public void printOkXmlResult(HttpServletResponse response, String content) throws IOException {
        response.setStatus(200);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(content);
    }

    public void printPartList(WsdlInterface iface, StringToStringMap parts, HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><body><p>Parts in interface [" + iface.getName() + "]</p><ul>");
        for (String key : parts.keySet()) {
            if (key.equals("#root#")) continue;
            out.print("<li><a href=\"");
            out.print(this.getInterfacePrefix(iface) + "&part=" + key);
            out.print("\">" + key + "</a></li>");
        }
        out.print("</ul></p></body></html>");
    }

    public void printInterfaceList(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<html><body><p>Mocked Interfaces in project [" + this.mockService.getProject().getName() + "]</p><ul>");
        for (Interface interface_ : ModelSupport.getChildren(this.mockService.getProject(), WsdlInterface.class)) {
            out.print("<li><a href=\"");
            out.print(this.getInterfacePrefix(interface_));
            out.print("\">" + interface_.getName() + "</a></li>");
        }
        out.print("</ul></p></body></html>");
    }

    public void returnFile(HttpServletResponse response, File file) throws FileNotFoundException, IOException {
        FileInputStream in = new FileInputStream(file);
        response.setStatus(200);
        long length = file.length();
        response.setContentLength((int)length);
        response.setContentType(ContentTypeHandler.getContentTypeFromFilename(file.getName()));
        Tools.readAndWrite(in, length, (OutputStream)response.getOutputStream());
        in.close();
    }

    public String getInterfacePrefix(Interface iface) {
        String wsdlPrefix = this.getOverviewUrl() + "&interface=" + iface.getName();
        return wsdlPrefix;
    }

    public String getOverviewUrl() {
        return this.mockService.getPath() + "?WSDL";
    }

    private String trimLastSlash(String wsdlPrefix) {
        int lastSlash = wsdlPrefix.lastIndexOf(47);
        if (lastSlash != -1) {
            return wsdlPrefix.substring(lastSlash + 1);
        }
        return wsdlPrefix;
    }
}

