/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.strategy;

import com.eviware.soapui.impl.wsdl.loadtest.strategy.BurstLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.LoadStrategyFactory;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.SimpleLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.ThreadCountChangeLoadStrategy;
import com.eviware.soapui.impl.wsdl.loadtest.strategy.VarianceLoadStrategy;
import com.eviware.soapui.support.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class LoadStrategyRegistry {
    private static LoadStrategyRegistry instance;
    private Map<String, LoadStrategyFactory> factories = new HashMap<String, LoadStrategyFactory>();

    public LoadStrategyRegistry() {
        this.addFactory(new SimpleLoadStrategy.Factory());
        this.addFactory(new BurstLoadStrategy.Factory());
        this.addFactory(new VarianceLoadStrategy.Factory());
        this.addFactory(new ThreadCountChangeLoadStrategy.Factory());
    }

    public void addFactory(LoadStrategyFactory factory) {
        this.factories.put(factory.getType(), factory);
    }

    public String[] getStrategies() {
        return StringUtils.sortNames(this.factories.keySet().toArray(new String[this.factories.size()]));
    }

    public static LoadStrategyRegistry getInstance() {
        if (instance == null) {
            instance = new LoadStrategyRegistry();
        }
        return instance;
    }

    public LoadStrategyFactory getFactory(String type) {
        return this.factories.get(type);
    }
}

