/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.testcase;

import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;

public class AddWsdlTestStepAction
extends AbstractSoapUIAction<WsdlTestCase> {
    public static final String SOAPUI_ACTION_ID = "AddWsdlTestStepAction";

    public AddWsdlTestStepAction() {
        super("Add Step", "Adds a TestStep to this TestCase");
    }

    @Override
    public void perform(WsdlTestCase testCase, Object param) {
        WsdlTestStep testStep;
        WsdlTestStepFactory factory = (WsdlTestStepFactory)param;
        if (!factory.canAddTestStepToTestCase(testCase)) {
            return;
        }
        String name = UISupport.prompt("Specify name for new step", "Add Step", factory.getTestStepName());
        if (name == null) {
            return;
        }
        while (testCase.getTestStepByName(name.trim()) != null) {
            if (!StringUtils.isNullOrEmpty(name = UISupport.prompt("Specify unique name of TestStep", "Rename TestStep", name))) continue;
            return;
        }
        TestStepConfig newTestStepConfig = factory.createNewTestStep(testCase, name);
        if (newTestStepConfig != null && (testStep = testCase.addTestStep(newTestStepConfig)) != null) {
            UISupport.selectAndShow(testStep);
        }
    }
}

