/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.monitor;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.monitor.ContentTypes;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.panels.monitor.SoapMonitorContainer;
import com.eviware.soapui.impl.wsdl.panels.monitor.SoapMonitorDesktopPanel;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.support.AbstractSoapUIAction;
import com.eviware.soapui.ui.desktop.DesktopPanel;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.support.ADialogBuilder;
import com.eviware.x.form.support.AField;
import com.eviware.x.form.support.AForm;
import com.eviware.x.form.support.APage;

public class SoapMonitorAction
extends AbstractSoapUIAction<WsdlProject> {
    public static final String SOAPUI_ACTION_ID = "SoapMonitorAction";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String HTTP_TUNNEL = "HTTP Tunnel";
    private static final String HTTP_PROXY = "HTTP Proxy";
    private SoapMonitor soapMonitor;

    public SoapMonitorAction() {
        super("Launch HTTP Monitor", "Launches a HTTP traffic monitor for this project");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(WsdlProject project, Object param) {
        DialogHandler dialogHandler = this.createDialogHandler(project, param);
        XFormDialog dialog = dialogHandler.buildDialog();
        XmlBeansSettingsImpl settings = project.getSettings();
        dialogHandler.setDialogValues(settings);
        this.soapMonitor = null;
        if (dialog.show()) {
            try {
                UISupport.setHourglassCursor();
                dialogHandler.saveDialogValues(settings);
                this.loadAllInterfacesIn(project);
                this.soapMonitor = dialogHandler.createSoapMonitor();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
            finally {
                UISupport.resetCursor();
            }
        }
    }

    private void loadAllInterfacesIn(WsdlProject project) throws Exception {
        for (Interface iface : project.getInterfaceList()) {
            iface.getDefinitionContext().loadIfNecessary();
        }
    }

    protected DialogHandler createDialogHandler(WsdlProject project, Object param) {
        return new FullMonitorDialogHandler(project);
    }

    public static ContentTypes defaultContentTypes() {
        return ContentTypes.of("*/html, */xml, */soap+xml, */json, */x-json, */javascript, */x-amf, */http");
    }

    public SoapMonitor getSoapMonitor() {
        return this.soapMonitor;
    }

    protected SoapMonitor openSoapMonitor(WsdlProject target, int listenPort, String incomingRequestWss, String incomingResponseWss, boolean setAsProxy, String sslEndpoint) {
        DesktopPanel desktopPanel = null;
        if (sslEndpoint == null) {
            desktopPanel = this.createDesktopPanel(target, listenPort, incomingRequestWss, incomingResponseWss, setAsProxy, null);
            UISupport.showDesktopPanel(desktopPanel);
        } else {
            String ssl = this.validate(sslEndpoint);
            if (ssl == null) {
                UISupport.showErrorMessage("SSL Monitor needs endpoint.");
            } else {
                desktopPanel = this.createDesktopPanel(target, listenPort, incomingRequestWss, incomingResponseWss, setAsProxy, ssl);
                UISupport.showDesktopPanel(desktopPanel);
            }
        }
        return desktopPanel != null ? ((SoapMonitorContainer)((Object)desktopPanel)).getSoapMonitor() : null;
    }

    protected DesktopPanel createDesktopPanel(WsdlProject target, int listenPort, String incomingRequestWss, String incomingResponseWss, boolean setAsProxy, String ssl) {
        return new SoapMonitorDesktopPanel(target, listenPort, incomingRequestWss, incomingResponseWss, setAsProxy, ssl);
    }

    protected String validate(String sslEndpoint) {
        if (sslEndpoint.trim().length() > 0) {
            return sslEndpoint.trim();
        }
        return null;
    }

    private void setDialogState(XFormDialog dialog, String newValue) {
        if (HTTP_PROXY.equals(newValue)) {
            dialog.getFormField("Set endpoint for HTTP Tunnel:").setEnabled(false);
            dialog.getFormField("HTTP tunnel - KeyStore").setEnabled(false);
            dialog.getFormField("HTTP tunnel - Password").setEnabled(false);
            dialog.getFormField("HTTP tunnel - KeyPassword").setEnabled(false);
            dialog.getFormField("HTTP tunnel - TrustStore").setEnabled(false);
            dialog.getFormField("HTTP tunnel - TrustStore Password").setEnabled(false);
            dialog.getFormField("Reuse request state").setEnabled(false);
            dialog.getFormField("HTTP tunnel - Set SSL Client Key Store path").setEnabled(false);
            dialog.getFormField("Content types to monitor").setEnabled(true);
            dialog.getFormField("HTTP tunnel - Set SSL Client Key Store Password").setEnabled(false);
            dialog.getFormField("Set as Proxy").setEnabled(true);
            dialog.getFormField("Incoming Request WSS").setEnabled(true);
            dialog.getFormField("Incoming Response WSS").setEnabled(true);
        } else {
            dialog.getFormField("Set endpoint for HTTP Tunnel:").setEnabled(true);
            dialog.getFormField("HTTP tunnel - KeyStore").setEnabled(true);
            dialog.getFormField("HTTP tunnel - Password").setEnabled(true);
            dialog.getFormField("HTTP tunnel - KeyPassword").setEnabled(true);
            dialog.getFormField("HTTP tunnel - TrustStore").setEnabled(true);
            dialog.getFormField("HTTP tunnel - TrustStore Password").setEnabled(true);
            dialog.getFormField("Reuse request state").setEnabled(true);
            dialog.getFormField("HTTP tunnel - Set SSL Client Key Store path").setEnabled(true);
            dialog.getFormField("Content types to monitor").setEnabled(true);
            dialog.getFormField("HTTP tunnel - Set SSL Client Key Store Password").setEnabled(true);
            dialog.getFormField("Set as Proxy").setEnabled(false);
            dialog.getFormField("Incoming Request WSS").setEnabled(false);
            dialog.getFormField("Incoming Response WSS").setEnabled(false);
        }
    }

    protected class FullMonitorDialogHandler
    implements DialogHandler {
        private WsdlProject project;
        private XFormDialog dialog;

        public FullMonitorDialogHandler(WsdlProject project) {
            this.project = project;
        }

        @Override
        public XFormDialog buildDialog() {
            this.dialog = ADialogBuilder.buildTabbedDialog(WizardForm.class, null);
            this.dialog.setSize(650, 500);
            return this.dialog;
        }

        @Override
        public void setDialogValues(Settings settings) {
            this.dialog.setIntValue("Port", (int)settings.getLong("Port", 8081L));
            this.dialog.setOptions("Incoming Request WSS", StringUtils.merge(this.project.getWssContainer().getIncomingWssNames(), "<none>"));
            this.dialog.setOptions("Incoming Response WSS", StringUtils.merge(this.project.getWssContainer().getIncomingWssNames(), "<none>"));
            this.dialog.setValue("Set endpoint for HTTP Tunnel:", settings.getString("Set endpoint for HTTP Tunnel:", "").length() > 0 ? settings.getString("Set endpoint for HTTP Tunnel:", "") : SoapMonitorAction.HTTPS_PROTOCOL);
            this.dialog.setOptions("Choose one:", new String[]{SoapMonitorAction.HTTP_TUNNEL, SoapMonitorAction.HTTP_PROXY});
            this.dialog.setValue("HTTP tunnel - KeyStore", settings.getString("HTTP tunnel - KeyStore", ""));
            this.dialog.setValue("HTTP tunnel - Password", settings.getString("HTTP tunnel - Password", ""));
            this.dialog.setValue("HTTP tunnel - KeyPassword", settings.getString("HTTP tunnel - KeyPassword", ""));
            this.dialog.setValue("HTTP tunnel - TrustStore", settings.getString("HTTP tunnel - TrustStore", ""));
            this.dialog.setValue("HTTP tunnel - TrustStore Password", settings.getString("HTTP tunnel - TrustStore Password", ""));
            this.dialog.setBooleanValue("Reuse request state", settings.getBoolean("Reuse request state"));
            this.dialog.setValue("Content types to monitor", settings.getString("Content types to monitor", SoapMonitorAction.defaultContentTypes().toString()));
            this.dialog.setValue("HTTP tunnel - Set SSL Client Key Store path", settings.getString("HTTP tunnel - Set SSL Client Key Store path", ""));
            this.dialog.setValue("HTTP tunnel - Set SSL Client Key Store Password", settings.getString("HTTP tunnel - Set SSL Client Key Store Password", ""));
            XFormField sslOrHttp = this.dialog.getFormField("Choose one:");
            sslOrHttp.setValue(SoapMonitorAction.HTTP_PROXY);
            SoapMonitorAction.this.setDialogState(this.dialog, SoapMonitorAction.HTTP_PROXY);
            sslOrHttp.addFormFieldListener(new XFormFieldListener(){

                @Override
                public void valueChanged(XFormField sourceField, String newValue, String oldValue) {
                    SoapMonitorAction.this.setDialogState(FullMonitorDialogHandler.this.dialog, newValue);
                }
            });
        }

        @Override
        public void saveDialogValues(Settings settings) {
            int listenPort = this.dialog.getIntValue("Port", 8080);
            settings.setLong("Port", listenPort);
            settings.setString("Set endpoint for HTTP Tunnel:", this.dialog.getValue("Set endpoint for HTTP Tunnel:"));
            settings.setString("HTTP tunnel - KeyStore", this.dialog.getValue("HTTP tunnel - KeyStore"));
            settings.setString("HTTP tunnel - Password", this.dialog.getValue("HTTP tunnel - Password"));
            settings.setString("HTTP tunnel - KeyPassword", this.dialog.getValue("HTTP tunnel - KeyPassword"));
            settings.setString("HTTP tunnel - TrustStore", this.dialog.getValue("HTTP tunnel - TrustStore"));
            settings.setString("HTTP tunnel - TrustStore Password", this.dialog.getValue("HTTP tunnel - TrustStore Password"));
            settings.setString("Reuse request state", this.dialog.getValue("Reuse request state"));
            settings.setString("HTTP tunnel - Set SSL Client Key Store path", this.dialog.getValue("HTTP tunnel - Set SSL Client Key Store path"));
            if (this.dialog.getValue("Content types to monitor") != null && this.dialog.getValue("Content types to monitor").trim().equals("")) {
                settings.setString("Content types to monitor", SoapMonitorAction.defaultContentTypes().toString());
            } else {
                settings.setString("Content types to monitor", this.dialog.getValue("Content types to monitor"));
            }
            settings.setString("HTTP tunnel - Set SSL Client Key Store Password", this.dialog.getValue("HTTP tunnel - Set SSL Client Key Store Password"));
        }

        @Override
        public SoapMonitor createSoapMonitor() {
            int listenPort = this.dialog.getIntValue("Port", 8080);
            if (SoapMonitorAction.HTTP_PROXY.equals(this.dialog.getValue("Choose one:"))) {
                return SoapMonitorAction.this.openSoapMonitor(this.project, listenPort, this.dialog.getValue("Incoming Request WSS"), this.dialog.getValue("Incoming Response WSS"), this.dialog.getBooleanValue("Set as Proxy"), null);
            }
            return SoapMonitorAction.this.openSoapMonitor(this.project, listenPort, this.dialog.getValue("Incoming Request WSS"), this.dialog.getValue("Incoming Response WSS"), false, this.dialog.getValue("Set endpoint for HTTP Tunnel:"));
        }
    }

    @AForm(description="Specify HTTP tunnel security settings", name="HTTP tunnel security", helpUrl="/HTTP-Recording/general-options.html")
    public static interface SecurityTabForm {
        @AField(description="Set SSL Tunnel KeyStore", name="HTTP tunnel - KeyStore", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_KEYSTORE = "HTTP tunnel - KeyStore";
        @AField(description="Set SSL Tunnel Password", name="HTTP tunnel - Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_PASSWORD = "HTTP tunnel - Password";
        @AField(description="Set SSL Tunnel KeyPassword", name="HTTP tunnel - KeyPassword", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_KEYPASSWORD = "HTTP tunnel - KeyPassword";
        @AField(description="Set SSL Tunnel TrustStore", name="HTTP tunnel - TrustStore", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_TRUSTSTORE = "HTTP tunnel - TrustStore";
        @AField(description="Set SSL Tunnel TrustStore Password", name="HTTP tunnel - TrustStore Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_TRUSTSTORE_PASSWORD = "HTTP tunnel - TrustStore Password";
        @AField(description="Set SSL Client Key Store", name="HTTP tunnel - Set SSL Client Key Store path", type=AField.AFieldType.FILE)
        public static final String SSLTUNNEL_KEYSTOREPATH = "HTTP tunnel - Set SSL Client Key Store path";
        @AField(description="Set SSL Client Key Store Password", name="HTTP tunnel - Set SSL Client Key Store Password", type=AField.AFieldType.PASSWORD)
        public static final String SSLTUNNEL_KEYSTOREPASSWORD = "HTTP tunnel - Set SSL Client Key Store Password";
    }

    @AForm(description="Specify HTTP Monitor settings", name="Launch HTTP Monitor", helpUrl="/HTTP-Recording/general-options.html")
    public static interface LaunchForm {
        @AField(description="SSL tunnel or HTTP proxy", name="Choose one:", type=AField.AFieldType.RADIOGROUP)
        public static final String SSLORHTTP = "Choose one:";
        @AField(description="The local port to listen on", name="Port", type=AField.AFieldType.INT)
        public static final String PORT = "Port";
        @AField(description="The Incoming WSS configuration to use for processing requests", name="Incoming Request WSS", type=AField.AFieldType.ENUMERATION)
        public static final String REQUEST_WSS = "Incoming Request WSS";
        @AField(description="The Outgoing WSS configuration to use for processing responses", name="Incoming Response WSS", type=AField.AFieldType.ENUMERATION)
        public static final String RESPONSE_WSS = "Incoming Response WSS";
        @AField(description="Set as Global Proxy", name="Set as Proxy", type=AField.AFieldType.BOOLEAN)
        public static final String SETASPROXY = "Set as Proxy";
        @AField(description="Set endpoint", name="Set endpoint for HTTP Tunnel:", type=AField.AFieldType.STRING)
        public static final String SETSSLMON = "Set endpoint for HTTP Tunnel:";
        @AField(description="Keep request state", name="Reuse request state", type=AField.AFieldType.BOOLEAN)
        public static final String SSLTUNNEL_REUSESTATE = "Reuse request state";
        @AField(description="Content types to monitor, if blank default types will be set!", name="Content types to monitor", type=AField.AFieldType.STRINGAREA)
        public static final String SET_CONTENT_TYPES = "Content types to monitor";
    }

    @AForm(description="Specify HTTP Monitor settings", name="General Options", helpUrl="/HTTP-Recording/general-options.html", icon="/applications-system.png")
    private static interface WizardForm {
        @APage(name="General")
        public static final LaunchForm general = null;
        @APage(name="Security")
        public static final SecurityTabForm security = null;
    }

    protected static interface DialogHandler {
        public XFormDialog buildDialog();

        public void setDialogValues(Settings var1);

        public void saveDialogValues(Settings var1);

        public SoapMonitor createSoapMonitor();
    }
}

