/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolRunner;
import com.eviware.soapui.support.UISupport;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class ProcessDialog
extends JDialog
implements RunnerContext {
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JButton cancelButton;
    private JTextArea logArea;
    private JButton closeButton;
    private ToolRunner runner;
    private RunnerContext.RunnerStatus status;
    private static final Logger log = Logger.getLogger((String)"toolLogger");

    public ProcessDialog(String title, String description, boolean showLog, boolean allowCancel) throws HeadlessException {
        super(UISupport.getMainFrame());
        ButtonBarBuilder builder;
        this.setTitle(title);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProcessDialog.this.runner != null && !ProcessDialog.this.runner.isRunning()) {
                    ProcessDialog.this.dispose();
                } else {
                    UISupport.showErrorMessage("Cannot close while task is running..");
                }
            }
        });
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setValue(0);
        this.progressBar.setIndeterminate(false);
        this.getContentPane().setLayout(new BorderLayout());
        if (description != null) {
            this.progressBar.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)new JLabel(description), "North");
            p.add((Component)this.progressBar, "Center");
            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)p, "North");
        } else {
            this.progressBar.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add((Component)this.progressBar, "North");
        }
        if (showLog) {
            this.getContentPane().add(this.buildLog(), "Center");
        }
        if (allowCancel) {
            builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            this.cancelButton = new JButton(new CancelAction());
            builder.addFixed((JComponent)this.cancelButton);
            builder.addUnrelatedGap();
            if (showLog) {
                this.closeButton = new JButton(new CloseAction());
                builder.addFixed((JComponent)this.closeButton);
            }
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.getContentPane().add((Component)builder.getPanel(), "South");
        } else if (showLog) {
            builder = ButtonBarBuilder.createLeftToRightBuilder();
            builder.addGlue();
            this.closeButton = new JButton(new CloseAction());
            builder.addFixed((JComponent)this.closeButton);
            builder.addGlue();
            builder.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.getContentPane().add((Component)builder.getPanel(), "South");
        }
        this.pack();
    }

    private Component buildLog() {
        this.logArea = new JTextArea();
        this.logArea.setEditable(false);
        this.logArea.setBackground(Color.WHITE);
        JScrollPane scrollPane = new JScrollPane(this.logArea);
        scrollPane.setPreferredSize(new Dimension(500, 300));
        return UISupport.wrapInEmptyPanel(scrollPane, BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    public void setProgress(String string) {
        this.progressBar.setString(string);
    }

    public void run(ToolRunner toolRunner) {
        if (!SoapUI.getLogMonitor().hasLogArea("toolLogger")) {
            SoapUI.getLogMonitor().addLogArea("tools", "toolLogger", false);
        }
        this.runner = toolRunner;
        this.runner.setContext(this);
        Thread thread = new Thread((Runnable)this.runner, toolRunner.getName());
        thread.start();
        UISupport.centerDialog(this);
        this.setVisible(true);
    }

    public void setCancelLabel(String label) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(label);
        }
    }

    @Override
    public void setStatus(RunnerContext.RunnerStatus status) {
        this.status = status;
        if (status == RunnerContext.RunnerStatus.RUNNING) {
            this.progressBar.setIndeterminate(true);
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(true);
            }
            if (this.closeButton != null) {
                this.closeButton.setEnabled(false);
            }
        } else if (status == RunnerContext.RunnerStatus.ERROR) {
            if (this.logArea == null) {
                this.setVisible(false);
                return;
            }
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(0);
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(false);
            }
            if (this.closeButton != null) {
                this.closeButton.setEnabled(true);
            }
        } else if (status == RunnerContext.RunnerStatus.FINISHED) {
            if (this.logArea == null) {
                this.setVisible(false);
                return;
            }
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(1);
            if (this.cancelButton != null) {
                this.cancelButton.setEnabled(false);
            }
            if (this.closeButton != null) {
                this.closeButton.setEnabled(true);
            }
        }
    }

    @Override
    public void disposeContext() {
    }

    @Override
    public void log(String msg) {
        if (this.logArea == null) {
            return;
        }
        this.logArea.insert(msg, this.logArea.getText().length());
        log.info((Object)msg);
        try {
            this.logArea.setCaretPosition(this.logArea.getLineStartOffset(this.logArea.getLineCount() - 1));
        }
        catch (BadLocationException e) {
            SoapUI.logError(e);
            log.error((Object)e.toString());
        }
    }

    @Override
    public void logError(String msg) {
        this.log(msg);
    }

    @Override
    public RunnerContext.RunnerStatus getStatus() {
        return this.status;
    }

    private final class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProcessDialog.this.setVisible(false);
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ProcessDialog.this.runner.isRunning()) {
                ProcessDialog.this.runner.cancel();
            }
        }
    }
}

