/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wadl.inference.schema.types;

import com.eviware.soapui.impl.wadl.inference.schema.Context;
import com.eviware.soapui.impl.wadl.inference.schema.Schema;
import com.eviware.soapui.impl.wadl.inference.schema.Type;
import com.eviware.soapui.impl.wadl.inference.schema.content.EmptyContent;
import com.eviware.soapui.impl.wadl.inference.schema.types.ComplexType;
import com.eviware.soapui.impl.wadl.inference.schema.types.SimpleType;
import com.eviware.soapui.impl.wadl.inference.support.TypeInferrer;
import com.eviware.soapui.inferredSchema.EmptyTypeConfig;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;

public class EmptyType
implements Type {
    private Schema schema;
    private EmptyContent empty;
    private boolean completed = false;

    public EmptyType(Schema schema) {
        this.schema = schema;
        this.empty = new EmptyContent(schema, false);
    }

    public EmptyType(EmptyTypeConfig xml, Schema schema) {
        this.schema = schema;
        this.empty = new EmptyContent(schema, xml.getCompleted());
        this.completed = xml.getCompleted();
    }

    @Override
    public EmptyTypeConfig save() {
        EmptyTypeConfig xml = EmptyTypeConfig.Factory.newInstance();
        xml.setCompleted(this.completed);
        return xml;
    }

    @Override
    public String getName() {
        return "empty_element";
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Type validate(Context context) throws XmlException {
        XmlCursor cursor = context.getCursor();
        if (!cursor.isAttr() && (cursor.toFirstAttribute() || cursor.toFirstChild())) {
            ComplexType newType = new ComplexType(this.schema, context.getName(), this.completed);
            newType.setContent(this.empty);
            return newType;
        }
        cursor.toFirstContentToken();
        if (this.empty.validate(context) != this.empty) {
            String value = cursor.getTextValue();
            XmlAnySimpleType simpleType = this.completed ? TypeInferrer.getBlankType() : TypeInferrer.inferSimpleType(value);
            return new SimpleType(this.schema, simpleType, this.completed);
        }
        this.completed = true;
        return this;
    }

    @Override
    public String toString() {
        String xsdns = this.schema.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema");
        StringBuilder s = new StringBuilder("<" + xsdns + ":complexType name=\"" + this.getName() + "\"/>");
        return s.toString();
    }
}

