/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.BaseMockServiceConfig;
import com.eviware.soapui.config.MockServiceConfig;
import com.eviware.soapui.config.RESTMockServiceConfig;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.support.HasHelpUrl;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunner;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.IconAnimator;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.BeanPathPropertySupport;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockRequest;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.mock.MockServiceListener;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.SSLSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.scripting.ScriptEnginePool;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractMockService<MockOperationType extends MockOperation, MockServiceConfigType extends BaseMockServiceConfig>
extends AbstractTestPropertyHolderWsdlModelItem<MockServiceConfigType>
implements MockService,
HasHelpUrl {
    public static final String START_SCRIPT_PROPERTY = AbstractMockService.class.getName() + "@startScript";
    public static final String STOP_SCRIPT_PROPERTY = AbstractMockService.class.getName() + "@stopScript";
    protected List<MockOperation> mockOperations = new ArrayList<MockOperation>();
    private Set<MockRunListener> mockRunListeners = new HashSet<MockRunListener>();
    private Set<MockServiceListener> mockServiceListeners = new HashSet<MockServiceListener>();
    private MockServiceIconAnimator iconAnimator;
    private WsdlMockRunner mockRunner;
    private SoapUIScriptEngine startScriptEngine;
    private SoapUIScriptEngine stopScriptEngine;
    private BeanPathPropertySupport docrootProperty;
    private ScriptEnginePool onRequestScriptEnginePool;
    private ScriptEnginePool afterRequestScriptEnginePool;

    protected AbstractMockService(MockServiceConfigType config, ModelItem parent, String icon) {
        super(config, parent, icon);
        if (!config.isSetPort() || config.getPort() < 1) {
            config.setPort(8080);
        }
        if (!config.isSetPath()) {
            config.setPath("/");
        }
        if (!config.isSetId()) {
            config.setId(ModelSupport.generateModelItemID());
        }
        this.initHost(config);
        this.docrootProperty = new BeanPathPropertySupport(this, "docroot");
        this.iconAnimator = new MockServiceIconAnimator();
        this.addMockRunListener(this.iconAnimator);
    }

    private void initHost(MockServiceConfigType config) {
        try {
            if (!config.isSetHost() || !StringUtils.hasContent(config.getHost())) {
                config.setHost(InetAddress.getLocalHost().getHostName());
            }
        }
        catch (UnknownHostException e) {
            SoapUI.logError(e);
        }
    }

    @Override
    public WsdlProject getProject() {
        return (WsdlProject)this.getParent();
    }

    public MockOperationType getMockOperationAt(int index) {
        return (MockOperationType)this.mockOperations.get(index);
    }

    @Override
    public MockOperation getMockOperationByName(String name) {
        for (MockOperation operation : this.mockOperations) {
            if (operation.getName() == null || !operation.getName().equals(name)) continue;
            return operation;
        }
        return null;
    }

    public void addMockOperation(MockOperationType mockOperation) {
        if (!this.canIAddAMockOperation(mockOperation)) {
            throw new IllegalStateException(mockOperation.getName() + " is not attached to service " + this.getName());
        }
        this.mockOperations.add((MockOperation)mockOperation);
    }

    protected String getProtocol() {
        try {
            boolean sslEnabled = SoapUI.getSettings().getBoolean(SSLSettings.ENABLE_MOCK_SSL);
            String protocol = sslEnabled ? "https://" : "http://";
            return protocol;
        }
        catch (Exception e) {
            return "http://";
        }
    }

    protected abstract boolean canIAddAMockOperation(MockOperationType var1);

    @Override
    public int getMockOperationCount() {
        return this.mockOperations.size();
    }

    @Override
    public int getPort() {
        return ((BaseMockServiceConfig)this.getConfig()).getPort();
    }

    @Override
    public String getPath() {
        return ((BaseMockServiceConfig)this.getConfig()).getPath();
    }

    @Override
    public void removeMockOperation(MockOperation mockOperation) {
        int ix = this.mockOperations.indexOf(mockOperation);
        if (ix == -1) {
            throw new RuntimeException("Unknown MockOperation specified to removeMockOperation");
        }
        this.mockOperations.remove(ix);
        this.fireMockOperationRemoved(mockOperation);
        mockOperation.release();
        if (this instanceof WsdlMockService) {
            ((MockServiceConfig)((WsdlMockService)this).getConfig()).removeMockOperation(ix);
        } else if (this instanceof RestMockService) {
            ((RESTMockServiceConfig)((RestMockService)this).getConfig()).removeRestMockAction(ix);
        }
    }

    @Override
    public String getLocalEndpoint() {
        String host = this.getHost();
        if (StringUtils.isNullOrEmpty(host)) {
            host = "127.0.0.1";
        }
        return this.getProtocol() + host + ":" + this.getPort() + this.getPath();
    }

    @Override
    public String getHost() {
        return ((BaseMockServiceConfig)this.getConfig()).getHost();
    }

    public void setHost(String host) {
        ((BaseMockServiceConfig)this.getConfig()).setHost(host);
    }

    @Override
    public void setPort(int port) {
        int oldPort = this.getPort();
        ((BaseMockServiceConfig)this.getConfig()).setPort(port);
        this.notifyPropertyChanged(PORT_PROPERTY, oldPort, port);
    }

    @Override
    public void setPath(String path) {
        String oldPath = this.getPath();
        ((BaseMockServiceConfig)this.getConfig()).setPath(path);
        this.notifyPropertyChanged(PATH_PROPERTY, oldPath, path);
    }

    @Override
    public WsdlMockRunner start() throws Exception {
        return this.start(null);
    }

    @Override
    public void startIfConfigured() throws Exception {
        if (SoapUI.getSettings().getBoolean(HttpSettings.START_MOCK_SERVICE)) {
            this.start();
        }
    }

    @Override
    public boolean getBindToHostOnly() {
        return ((BaseMockServiceConfig)this.getConfig()).getBindToHostOnly();
    }

    public void setBindToHostOnly(boolean bindToHostOnly) {
        ((BaseMockServiceConfig)this.getConfig()).setBindToHostOnly(bindToHostOnly);
    }

    public WsdlMockRunner start(WsdlTestRunContext context) throws Exception {
        String path = this.getPath();
        if (path == null || path.trim().length() == 0 || path.trim().charAt(0) != '/') {
            throw new Exception("Invalid path; must start with '/'");
        }
        this.mockRunner = new WsdlMockRunner(this, context);
        return this.mockRunner;
    }

    @Override
    public void addMockRunListener(MockRunListener listener) {
        this.mockRunListeners.add(listener);
    }

    @Override
    public void removeMockRunListener(MockRunListener listener) {
        this.mockRunListeners.remove(listener);
    }

    @Override
    public void addMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.add(listener);
    }

    @Override
    public void removeMockServiceListener(MockServiceListener listener) {
        this.mockServiceListeners.remove(listener);
    }

    @Override
    public WsdlMockRunner getMockRunner() {
        return this.mockRunner;
    }

    public void setMockRunner(WsdlMockRunner mockRunner) {
        this.mockRunner = mockRunner;
    }

    @Override
    public MockRunListener[] getMockRunListeners() {
        return this.mockRunListeners.toArray(new MockRunListener[this.mockRunListeners.size()]);
    }

    public MockServiceListener[] getMockServiceListeners() {
        return this.mockServiceListeners.toArray(new MockServiceListener[this.mockServiceListeners.size()]);
    }

    @Override
    public List<MockOperation> getMockOperationList() {
        return Collections.unmodifiableList(new ArrayList<MockOperation>(this.mockOperations));
    }

    protected List<MockOperation> getMockOperations() {
        return this.mockOperations;
    }

    @Override
    public void fireMockOperationAdded(MockOperation mockOperation) {
        for (MockServiceListener listener : this.getMockServiceListeners()) {
            listener.mockOperationAdded(mockOperation);
        }
    }

    @Override
    public void fireMockOperationRemoved(MockOperation mockOperation) {
        for (MockServiceListener listener : this.getMockServiceListeners()) {
            listener.mockOperationRemoved(mockOperation);
        }
    }

    @Override
    public void fireMockResponseAdded(MockResponse mockResponse) {
        for (MockServiceListener listener : this.getMockServiceListeners()) {
            listener.mockResponseAdded(mockResponse);
        }
    }

    @Override
    public void fireMockResponseRemoved(MockResponse mockResponse) {
        for (MockServiceListener listener : this.getMockServiceListeners()) {
            listener.mockResponseRemoved(mockResponse);
        }
    }

    @Override
    public void release() {
        super.release();
        this.mockServiceListeners.clear();
        if (this.mockRunner != null) {
            if (this.mockRunner.isRunning()) {
                this.mockRunner.stop();
            }
            if (this.mockRunner != null) {
                this.mockRunner.release();
            }
        }
        if (this.onRequestScriptEnginePool != null) {
            this.onRequestScriptEnginePool.release();
        }
        if (this.afterRequestScriptEnginePool != null) {
            this.afterRequestScriptEnginePool.release();
        }
        if (this.startScriptEngine != null) {
            this.startScriptEngine.release();
        }
        if (this.stopScriptEngine != null) {
            this.stopScriptEngine.release();
        }
    }

    @Override
    public void setStartScript(String script) {
        String oldScript = this.getStartScript();
        if (!((BaseMockServiceConfig)this.getConfig()).isSetStartScript()) {
            ((BaseMockServiceConfig)this.getConfig()).addNewStartScript();
        }
        ((BaseMockServiceConfig)this.getConfig()).getStartScript().setStringValue(script);
        if (this.startScriptEngine != null) {
            this.startScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(START_SCRIPT_PROPERTY, oldScript, script);
    }

    @Override
    public String getStartScript() {
        return ((BaseMockServiceConfig)this.getConfig()).isSetStartScript() ? ((BaseMockServiceConfig)this.getConfig()).getStartScript().getStringValue() : null;
    }

    @Override
    public void setStopScript(String script) {
        String oldScript = this.getStopScript();
        if (!((BaseMockServiceConfig)this.getConfig()).isSetStopScript()) {
            ((BaseMockServiceConfig)this.getConfig()).addNewStopScript();
        }
        ((BaseMockServiceConfig)this.getConfig()).getStopScript().setStringValue(script);
        if (this.stopScriptEngine != null) {
            this.stopScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(STOP_SCRIPT_PROPERTY, oldScript, script);
    }

    @Override
    public String getStopScript() {
        return ((BaseMockServiceConfig)this.getConfig()).isSetStopScript() ? ((BaseMockServiceConfig)this.getConfig()).getStopScript().getStringValue() : null;
    }

    @Override
    public Object runStartScript(WsdlMockRunContext runContext, MockRunner runner) throws Exception {
        String script = this.getStartScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.startScriptEngine == null) {
            this.startScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.startScriptEngine.setScript(script);
        }
        this.startScriptEngine.setVariable("context", runContext);
        this.startScriptEngine.setVariable("mockRunner", runner);
        this.startScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.startScriptEngine.run();
    }

    @Override
    public Object runStopScript(WsdlMockRunContext runContext, MockRunner runner) throws Exception {
        String script = this.getStopScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.stopScriptEngine == null) {
            this.stopScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.stopScriptEngine.setScript(script);
        }
        this.stopScriptEngine.setVariable("context", runContext);
        this.stopScriptEngine.setVariable("mockRunner", runner);
        this.stopScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.stopScriptEngine.run();
    }

    @Override
    public void setOnRequestScript(String script) {
        String oldScript = this.getOnRequestScript();
        if (!((BaseMockServiceConfig)this.getConfig()).isSetOnRequestScript()) {
            ((BaseMockServiceConfig)this.getConfig()).addNewOnRequestScript();
        }
        ((BaseMockServiceConfig)this.getConfig()).getOnRequestScript().setStringValue(script);
        if (this.onRequestScriptEnginePool != null) {
            this.onRequestScriptEnginePool.setScript(script);
        }
        this.notifyPropertyChanged("onRequestScript", oldScript, script);
    }

    @Override
    public String getOnRequestScript() {
        return ((BaseMockServiceConfig)this.getConfig()).isSetOnRequestScript() ? ((BaseMockServiceConfig)this.getConfig()).getOnRequestScript().getStringValue() : null;
    }

    @Override
    public void setAfterRequestScript(String script) {
        String oldScript = this.getAfterRequestScript();
        if (!((BaseMockServiceConfig)this.getConfig()).isSetAfterRequestScript()) {
            ((BaseMockServiceConfig)this.getConfig()).addNewAfterRequestScript();
        }
        ((BaseMockServiceConfig)this.getConfig()).getAfterRequestScript().setStringValue(script);
        if (this.afterRequestScriptEnginePool != null) {
            this.afterRequestScriptEnginePool.setScript(script);
        }
        this.notifyPropertyChanged("afterRequestScript", oldScript, script);
    }

    @Override
    public String getAfterRequestScript() {
        return ((BaseMockServiceConfig)this.getConfig()).isSetAfterRequestScript() ? ((BaseMockServiceConfig)this.getConfig()).getAfterRequestScript().getStringValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runOnRequestScript(WsdlMockRunContext runContext, MockRequest mockRequest) throws Exception {
        String script = this.getOnRequestScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.onRequestScriptEnginePool == null) {
            this.onRequestScriptEnginePool = new ScriptEnginePool(this);
            this.onRequestScriptEnginePool.setScript(script);
        }
        SoapUIScriptEngine scriptEngine = this.onRequestScriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setVariable("context", runContext);
            scriptEngine.setVariable("mockRequest", mockRequest);
            scriptEngine.setVariable("mockRunner", this.getMockRunner());
            scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            Object object = scriptEngine.run();
            return object;
        }
        finally {
            this.onRequestScriptEnginePool.returnScriptEngine(scriptEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runAfterRequestScript(WsdlMockRunContext runContext, MockResult mockResult) throws Exception {
        String script = this.getAfterRequestScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.afterRequestScriptEnginePool == null) {
            this.afterRequestScriptEnginePool = new ScriptEnginePool(this);
            this.afterRequestScriptEnginePool.setScript(script);
        }
        SoapUIScriptEngine scriptEngine = this.afterRequestScriptEnginePool.getScriptEngine();
        try {
            scriptEngine.setVariable("context", runContext);
            scriptEngine.setVariable("mockResult", mockResult);
            scriptEngine.setVariable("mockRunner", this.getMockRunner());
            scriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
            Object object = scriptEngine.run();
            return object;
        }
        finally {
            this.afterRequestScriptEnginePool.returnScriptEngine(scriptEngine);
        }
    }

    public void setDocroot(String docroot) {
        this.docrootProperty.set(docroot, true);
    }

    public String getDocroot() {
        return this.docrootProperty.get();
    }

    @Override
    public void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.docrootProperty.resolveFile(context, "Missing MockService docroot");
    }

    public boolean isDispatchResponseMessages() {
        return ((BaseMockServiceConfig)this.getConfig()).getDispatchResponseMessages();
    }

    public void setDispatchResponseMessages(boolean dispatchResponseMessages) {
        boolean old = this.isDispatchResponseMessages();
        ((BaseMockServiceConfig)this.getConfig()).setDispatchResponseMessages(dispatchResponseMessages);
        this.notifyPropertyChanged("dispatchResponseMessages", old, dispatchResponseMessages);
    }

    public abstract String getIconName();

    public void fireOnMockResult(Object result) {
        if (result != null && result instanceof MockResult) {
            for (MockRunListener listener : this.getMockRunListeners()) {
                listener.onMockResult((MockResult)result);
            }
        }
    }

    private class MockServiceIconAnimator
    extends IconAnimator<MockService>
    implements MockRunListener {
        public MockServiceIconAnimator() {
            super(AbstractMockService.this, AbstractMockService.this.getIconName(), AbstractMockService.this.getIconName(), 4);
        }

        @Override
        public MockResult onMockRequest(MockRunner runner, HttpServletRequest request, HttpServletResponse response) {
            return null;
        }

        @Override
        public void onMockResult(MockResult result) {
        }

        @Override
        public void onMockRunnerStart(MockRunner mockRunner) {
            this.start();
        }

        @Override
        public void onMockRunnerStop(MockRunner mockRunner) {
            this.stop();
            AbstractMockService.this.mockRunner = null;
        }
    }
}

