/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.rest.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.rest.RestResource;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.types.StringList;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlBoolean;

public class RestUtils {
    public static String[] extractTemplateParams(String path) {
        int endIx;
        if (StringUtils.isNullOrEmpty(path)) {
            return new String[0];
        }
        StringList result = new StringList();
        int ix = path.indexOf(123);
        while (ix != -1 && (endIx = path.indexOf(125, ix)) != -1) {
            if (endIx > ix + 1 && ix > 0 && path.charAt(ix - 1) != '$') {
                result.add(path.substring(ix + 1, endIx));
            }
            ix = path.indexOf(123, ix + 1);
        }
        return result.toStringArray();
    }

    public static String extractParams(String pathOrEndpoint, RestParamsPropertyHolder params, boolean keepHost) {
        return RestUtils.extractParams(pathOrEndpoint, params, keepHost, TemplateExtractionOption.EXTRACT_TEMPLATE_PARAMETERS);
    }

    public static String extractParams(String pathOrEndpoint, RestParamsPropertyHolder params, boolean keepHost, TemplateExtractionOption templateExtractionOptions) {
        URL url;
        String queryString;
        String path;
        block16: {
            if (StringUtils.isNullOrEmpty(pathOrEndpoint)) {
                return "";
            }
            path = pathOrEndpoint;
            queryString = "";
            url = null;
            try {
                url = new URL(pathOrEndpoint);
                path = url.getPath();
                queryString = url.getQuery();
            }
            catch (MalformedURLException e) {
                int ix = path.indexOf(63);
                if (ix < 0) break block16;
                queryString = path.substring(ix + 1);
                path = path.substring(0, ix);
            }
        }
        String[] items = path.split("/");
        StringBuilder resultPath = new StringBuilder();
        for (String item : items) {
            try {
                String[] matrixParams;
                if (templateExtractionOptions == TemplateExtractionOption.EXTRACT_TEMPLATE_PARAMETERS) {
                    int openCurlyIndex = item.indexOf("{");
                    int closingCurlyIndex = item.indexOf("}");
                    if (openCurlyIndex != -1 && closingCurlyIndex > openCurlyIndex) {
                        String name = item.substring(openCurlyIndex + 1, closingCurlyIndex);
                        RestParamProperty property = params.getProperty(name);
                        if (!params.hasProperty(name)) {
                            property = params.addProperty(name);
                        }
                        property.setStyle(RestParamsPropertyHolder.ParameterStyle.TEMPLATE);
                        property.setValue(name);
                        property.setDefaultValue(name);
                    }
                }
                if ((matrixParams = item.split(";")).length > 0) {
                    item = matrixParams[0];
                    for (int c = 1; c < matrixParams.length; ++c) {
                        String name;
                        String matrixParam = matrixParams[c];
                        int ix = matrixParam.indexOf(61);
                        if (ix == -1) {
                            name = URLDecoder.decode(matrixParam, "Utf-8");
                            if (params.hasProperty(name)) continue;
                            params.addProperty(name).setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                            continue;
                        }
                        name = URLDecoder.decode(matrixParam.substring(0, ix), "Utf-8");
                        RestParamProperty property = params.getProperty(name);
                        if (property == null) {
                            property = params.addProperty(name);
                        }
                        property.setStyle(RestParamsPropertyHolder.ParameterStyle.MATRIX);
                        property.setValue(URLDecoder.decode(matrixParam.substring(ix + 1), "Utf-8"));
                        property.setDefaultValue(URLDecoder.decode(matrixParam.substring(ix + 1), "Utf-8"));
                    }
                }
            }
            catch (Exception e) {
                SoapUI.logError(e, "Couldn't parse the template/matrix parameters from URI");
            }
            if (!StringUtils.hasContent(item)) continue;
            resultPath.append('/').append(item);
        }
        if (StringUtils.hasContent(queryString)) {
            RestUtils.extractParamsFromQueryString(params, queryString);
        }
        if (path.endsWith("/")) {
            resultPath.append('/');
        }
        if (keepHost && url != null) {
            return Tools.getEndpointFromUrl(url) + resultPath.toString();
        }
        return resultPath.toString();
    }

    public static void extractParamsFromQueryString(RestParamsPropertyHolder params, String queryString) {
        String[] items;
        for (String item : items = queryString.split("&")) {
            try {
                String name;
                int ix = item.indexOf(61);
                if (ix == -1) {
                    name = URLDecoder.decode(item, "Utf-8");
                    if (params.hasProperty(name)) continue;
                    params.addProperty(name).setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                    continue;
                }
                name = URLDecoder.decode(item.substring(0, ix), "Utf-8");
                RestParamProperty property = params.getProperty(name);
                if (property == null) {
                    property = params.addProperty(name);
                }
                property.setStyle(RestParamsPropertyHolder.ParameterStyle.QUERY);
                property.setValue(URLDecoder.decode(item.substring(ix + 1), "Utf-8"));
                property.setDefaultValue(URLDecoder.decode(item.substring(ix + 1), "Utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public static String expandPath(String path, RestParamsPropertyHolder params, RestRequestInterface request) {
        DefaultPropertyExpansionContext context = new DefaultPropertyExpansionContext(request);
        for (int c = 0; c < params.getPropertyCount(); ++c) {
            RestParamProperty param = params.getPropertyAt(c);
            String value = PropertyExpander.expandProperties(context, param.getValue());
            if (!StringUtils.hasContent(value) && !param.getRequired()) continue;
            if (value != null && !param.isDisableUrlEncoding()) {
                try {
                    String encoding = System.getProperty("soapui.request.encoding", request.getEncoding());
                    encoding = StringUtils.hasContent(encoding) ? encoding : Charset.defaultCharset().toString();
                    value = URLEncoder.encode(value, encoding);
                }
                catch (UnsupportedEncodingException e1) {
                    SoapUI.logError(e1);
                    value = HttpUtils.urlEncodeWithUtf8(value);
                }
            }
            if (param.getStyle() != RestParamsPropertyHolder.ParameterStyle.TEMPLATE) continue;
            path = path.replaceAll("\\{" + param.getName() + "\\}", value);
        }
        return path + RestUtils.makeSuffixParameterString(request);
    }

    public static String makeSuffixParameterString(RestRequestInterface request) {
        return RestUtils.makeMatrixParameterString(request.getParams()) + RestUtils.getQueryParamsString(request);
    }

    private static String makeMatrixParameterString(RestParamsPropertyHolder params) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < params.getPropertyCount(); ++i) {
            RestParamProperty param = params.getPropertyAt(i);
            String value = param.getValue();
            if (param.getStyle() != RestParamsPropertyHolder.ParameterStyle.MATRIX) continue;
            if (param.getType().equals(XmlBoolean.type.getName())) {
                if (!value.toUpperCase().equals("TRUE") && !value.equals("1")) continue;
                buffer.append(";").append(param.getName());
                continue;
            }
            buffer.append(";").append(param.getName());
            if (!StringUtils.hasContent(value)) continue;
            buffer.append("=").append(value);
        }
        return buffer.toString();
    }

    public static String getQueryParamsString(RestRequestInterface request) {
        if (RestUtils.isRequestWithoutQueryString(request)) {
            return "";
        }
        RestParamsPropertyHolder params = request.getParams();
        StringBuilder query = new StringBuilder();
        for (int c = 0; c < params.getPropertyCount(); ++c) {
            RestParamProperty param = params.getPropertyAt(c);
            String value = param.getValue();
            List<String> valueParts = RestUtils.splitMultipleParameters(value, request.getMultiValueDelimiter());
            if (param.getStyle() != RestParamsPropertyHolder.ParameterStyle.QUERY || valueParts.isEmpty() && !param.getRequired()) continue;
            for (String valuePart : valueParts) {
                if (query.length() > 0) {
                    query.append('&');
                }
                query.append(param.getName()).append('=');
                if (!StringUtils.hasContent(valuePart)) continue;
                query.append(valuePart);
            }
        }
        return (query.length() > 0 ? "?" : "") + query.toString();
    }

    private static boolean isRequestWithoutQueryString(RestRequestInterface request) {
        return request.isPostQueryString() || "multipart/form-data".equals(request.getMediaType()) || "multipart/mixed".equals(request.getMediaType());
    }

    public static List<String> splitMultipleParameters(String paramStr, String delimiter) {
        StringList result = new StringList();
        if (StringUtils.hasContent(paramStr)) {
            if (!StringUtils.hasContent(delimiter)) {
                result.add(paramStr);
            } else {
                result.addAll(paramStr.split(delimiter));
            }
        }
        return result;
    }

    public static List<String> splitMultipleParametersEmptyIncluded(String paramStr, String delimiter) {
        StringList result = new StringList();
        if (!StringUtils.hasContent(delimiter)) {
            result.add(paramStr);
        } else {
            result.addAll(paramStr.split(delimiter));
        }
        return result;
    }

    public static List<RestResource> extractAncestorsParentFirst(RestResource childResource) {
        ArrayList<RestResource> resources = new ArrayList<RestResource>();
        for (RestResource r = childResource; r != null; r = r.getParentResource()) {
            resources.add(r);
        }
        Collections.reverse(resources);
        return resources;
    }

    public static String getExpandedPath(String path, RestParamsPropertyHolder params, ModelItem context) {
        String expandedPath = path;
        expandedPath = PropertyExpander.expandProperties(context, expandedPath);
        for (String pathParam : RestUtils.extractTemplateParams(expandedPath)) {
            String pathParamValue = params.getPropertyValue(pathParam);
            pathParamValue = PropertyExpander.expandProperties(context, pathParamValue);
            expandedPath = expandedPath.replaceAll("\\{" + pathParam + "\\}", pathParamValue == null ? "" : pathParamValue);
        }
        return expandedPath;
    }

    public static enum TemplateExtractionOption {
        EXTRACT_TEMPLATE_PARAMETERS,
        IGNORE_TEMPLATE_PARAMETERS;

    }
}

